/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kamelets.utils.format.converter.json;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.kamelets.utils.format.SchemaType;
import org.apache.camel.kamelets.utils.format.converter.json.Json;
import org.apache.camel.kamelets.utils.format.converter.json.JsonFormatSchema;
import org.apache.camel.kamelets.utils.format.converter.utils.SchemaHelper;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;

public class JsonSchemaResolver
implements SchemaResolver,
Processor {
    private final ConcurrentMap<String, JsonNode> schemes = new ConcurrentHashMap<String, JsonNode>();
    private JsonNode schema;
    private String contentClass;

    public String getSchema() {
        if (this.schema != null) {
            try {
                return Json.MAPPER.writeValueAsString((Object)this.schema);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setSchema(String schema) {
        if (ObjectHelper.isNotEmpty((String)schema)) {
            try {
                this.schema = Json.MAPPER.readTree(schema);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.schema = null;
        }
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = ObjectHelper.isNotEmpty((String)contentClass) ? contentClass : null;
    }

    public void process(Exchange exchange) throws Exception {
        Object payload = exchange.getMessage().getBody();
        if (payload == null) {
            return;
        }
        JsonNode answer = this.computeIfAbsent(exchange);
        if (answer != null) {
            exchange.setProperty("X-Content-Schema", (Object)answer);
            exchange.setProperty("X-Content-Schema-Type", (Object)SchemaType.JSON.type());
            exchange.setProperty("X-Content-Class", (Object)SchemaHelper.resolveContentClass(exchange, this.contentClass));
        }
    }

    private JsonNode computeIfAbsent(Exchange exchange) {
        String contentClass;
        if (this.schema != null) {
            return this.schema;
        }
        JsonNode answer = (JsonNode)exchange.getProperty("X-Content-Schema", JsonNode.class);
        if (answer == null && exchange.getProperties().containsKey("schema")) {
            String schemaJson = (String)exchange.getProperty("schema", String.class);
            try {
                answer = Json.MAPPER.readTree(schemaJson);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Unable to load Json schema", e);
            }
        }
        if (answer == null && (contentClass = SchemaHelper.resolveContentClass(exchange, this.contentClass)) != null) {
            answer = this.schemes.computeIfAbsent(contentClass, t -> {
                Resource res = PluginHelper.getResourceLoader((CamelContext)exchange.getContext()).resolveResource("classpath:schemas/" + SchemaType.JSON.type() + "/" + t + "." + SchemaType.JSON.type());
                try {
                    if (!res.exists()) return null;
                    try (InputStream is = res.getInputStream();){
                        if (is == null) return null;
                        JsonNode jsonNode = Json.MAPPER.readTree(is);
                        return jsonNode;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to load Json schema for type: " + t + ", resource: " + res.getLocation(), e);
                }
            });
        }
        if (answer != null) {
            this.schema = answer;
        }
        return answer;
    }

    public FormatSchema resolve(Exchange exchange) {
        JsonNode answer = (JsonNode)exchange.getProperty("X-Content-Schema", JsonNode.class);
        if (answer == null) {
            answer = this.computeIfAbsent(exchange);
        }
        return new JsonFormatSchema(answer);
    }
}

