/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.kafka;

import java.util.Map;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

public class CamelKafkaSinkConnectorConfig
extends CamelSinkConnectorConfig {
    public static final String CAMEL_SINK_KAFKA_PATH_TOPIC_CONF = "camel.sink.path.topic";
    public static final String CAMEL_SINK_KAFKA_PATH_TOPIC_DOC = "Name of the topic to use. On the consumer you can use comma to separate multiple topics. A producer can only send a message to a single topic.";
    public static final String CAMEL_SINK_KAFKA_PATH_TOPIC_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_ADDITIONAL_PROPERTIES_CONF = "camel.sink.endpoint.additionalProperties";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_ADDITIONAL_PROPERTIES_DOC = "Sets additional properties for either kafka consumer or kafka producer in case they can't be set directly on the camel configurations (e.g: new Kafka properties that are not reflected yet in Camel configurations), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BROKERS_CONF = "camel.sink.endpoint.brokers";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BROKERS_DOC = "URL of the Kafka brokers to use. The format is host1:port1,host2:port2, and the list can be a subset of brokers or a VIP pointing to a subset of brokers. This option is known as bootstrap.servers in the Kafka documentation.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BROKERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CLIENT_ID_CONF = "camel.sink.endpoint.clientId";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CLIENT_ID_DOC = "The client id is a user-specified string sent in each request to help trace calls. It should logically identify the application making the request.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_FILTER_STRATEGY_CONF = "camel.sink.endpoint.headerFilterStrategy";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MAX_MS_CONF = "camel.sink.endpoint.reconnectBackoffMaxMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MAX_MS_DEFAULT = "1000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SHUTDOWN_TIMEOUT_CONF = "camel.sink.endpoint.shutdownTimeout";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SHUTDOWN_TIMEOUT_DOC = "Timeout in milli seconds to wait gracefully for the consumer or producer to shutdown and terminate its worker threads.";
    public static final Integer CAMEL_SINK_KAFKA_ENDPOINT_SHUTDOWN_TIMEOUT_DEFAULT = 30000;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BUFFER_MEMORY_SIZE_CONF = "camel.sink.endpoint.bufferMemorySize";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BUFFER_MEMORY_SIZE_DOC = "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by block.on.buffer.full.This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_BUFFER_MEMORY_SIZE_DEFAULT = "33554432";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_COMPRESSION_CODEC_CONF = "camel.sink.endpoint.compressionCodec";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_COMPRESSION_CODEC_DOC = "This parameter allows you to specify the compression codec for all data generated by this producer. Valid values are none, gzip and snappy. One of: [none] [gzip] [snappy] [lz4]";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_COMPRESSION_CODEC_DEFAULT = "none";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CONNECTION_MAX_IDLE_MS_CONF = "camel.sink.endpoint.connectionMaxIdleMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CONNECTION_MAX_IDLE_MS_DOC = "Close idle connections after the number of milliseconds specified by this config.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_CONNECTION_MAX_IDLE_MS_DEFAULT = "540000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_ENABLE_IDEMPOTENCE_CONF = "camel.sink.endpoint.enableIdempotence";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_ENABLE_IDEMPOTENCE_DOC = "If set to 'true' the producer will ensure that exactly one copy of each message is written in the stream. If 'false', producer retries may write duplicates of the retried message in the stream. If set to true this option will require max.in.flight.requests.per.connection to be set to 1 and retries cannot be zero and additionally acks must be set to 'all'.";
    public static final Boolean CAMEL_SINK_KAFKA_ENDPOINT_ENABLE_IDEMPOTENCE_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_SERIALIZER_CONF = "camel.sink.endpoint.headerSerializer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_SERIALIZER_DOC = "To use a custom KafkaHeaderSerializer to serialize kafka headers values";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_HEADER_SERIALIZER_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_CONF = "camel.sink.endpoint.key";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_DOC = "The record key (or null if no key is specified). If this option has been configured then it take precedence over header KafkaConstants#KEY";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_SERIALIZER_CONF = "camel.sink.endpoint.keySerializer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_SERIALIZER_DOC = "The serializer class for keys (defaults to the same as for messages if nothing is given).";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KEY_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.StringSerializer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_LAZY_START_PRODUCER_CONF = "camel.sink.endpoint.lazyStartProducer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_KAFKA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_LINGER_MS_CONF = "camel.sink.endpoint.lingerMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_LINGER_MS_DOC = "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting linger.ms=5, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_LINGER_MS_DEFAULT = "0";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_BLOCK_MS_CONF = "camel.sink.endpoint.maxBlockMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_BLOCK_MS_DOC = "The configuration controls how long sending to kafka will block. These methods can be blocked for multiple reasons. For e.g: buffer full, metadata unavailable.This configuration imposes maximum limit on the total time spent in fetching metadata, serialization of key and value, partitioning and allocation of buffer memory when doing a send(). In case of partitionsFor(), this configuration imposes a maximum time threshold on waiting for metadata";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_BLOCK_MS_DEFAULT = "60000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_IN_FLIGHT_REQUEST_CONF = "camel.sink.endpoint.maxInFlightRequest";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_IN_FLIGHT_REQUEST_DOC = "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_IN_FLIGHT_REQUEST_DEFAULT = "5";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_REQUEST_SIZE_CONF = "camel.sink.endpoint.maxRequestSize";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_REQUEST_SIZE_DOC = "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_MAX_REQUEST_SIZE_DEFAULT = "1048576";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METADATA_MAX_AGE_MS_CONF = "camel.sink.endpoint.metadataMaxAgeMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METADATA_MAX_AGE_MS_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METADATA_MAX_AGE_MS_DEFAULT = "300000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRIC_REPORTERS_CONF = "camel.sink.endpoint.metricReporters";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRIC_REPORTERS_DOC = "A list of classes to use as metrics reporters. Implementing the MetricReporter interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRIC_REPORTERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRICS_SAMPLE_WINDOW_MS_CONF = "camel.sink.endpoint.metricsSampleWindowMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRICS_SAMPLE_WINDOW_MS_DOC = "The number of samples maintained to compute metrics.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_METRICS_SAMPLE_WINDOW_MS_DEFAULT = "30000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_NO_OF_METRICS_SAMPLE_CONF = "camel.sink.endpoint.noOfMetricsSample";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_NO_OF_METRICS_SAMPLE_DOC = "The number of samples maintained to compute metrics.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_NO_OF_METRICS_SAMPLE_DEFAULT = "2";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITIONER_CONF = "camel.sink.endpoint.partitioner";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITIONER_DOC = "The partitioner class for partitioning messages amongst sub-topics. The default partitioner is based on the hash of the key.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITIONER_DEFAULT = "org.apache.kafka.clients.producer.internals.DefaultPartitioner";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITION_KEY_CONF = "camel.sink.endpoint.partitionKey";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITION_KEY_DOC = "The partition to which the record will be sent (or null if no partition was specified). If this option has been configured then it take precedence over header KafkaConstants#PARTITION_KEY";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PARTITION_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PRODUCER_BATCH_SIZE_CONF = "camel.sink.endpoint.producerBatchSize";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PRODUCER_BATCH_SIZE_DOC = "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. No attempt will be made to batch records larger than this size.Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent.A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_PRODUCER_BATCH_SIZE_DEFAULT = "16384";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_QUEUE_BUFFERING_MAX_MESSAGES_CONF = "camel.sink.endpoint.queueBufferingMaxMessages";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_QUEUE_BUFFERING_MAX_MESSAGES_DOC = "The maximum number of unsent messages that can be queued up the producer when using async mode before either the producer must be blocked or data must be dropped.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_QUEUE_BUFFERING_MAX_MESSAGES_DEFAULT = "10000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECEIVE_BUFFER_BYTES_CONF = "camel.sink.endpoint.receiveBufferBytes";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECEIVE_BUFFER_BYTES_DOC = "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECEIVE_BUFFER_BYTES_DEFAULT = "65536";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MS_CONF = "camel.sink.endpoint.reconnectBackoffMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MS_DOC = "The amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all requests sent by the consumer to the broker.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MS_DEFAULT = "50";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECORD_METADATA_CONF = "camel.sink.endpoint.recordMetadata";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RECORD_METADATA_DOC = "Whether the producer should store the RecordMetadata results from sending to Kafka. The results are stored in a List containing the RecordMetadata metadata's. The list is stored on a header with the key KafkaConstants#KAFKA_RECORDMETA";
    public static final Boolean CAMEL_SINK_KAFKA_ENDPOINT_RECORD_METADATA_DEFAULT = true;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_REQUIRED_ACKS_CONF = "camel.sink.endpoint.requestRequiredAcks";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_REQUIRED_ACKS_DOC = "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent. The following settings are common: acks=0 If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the retries configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. acks=1 This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. acks=all This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee. One of: [-1] [0] [1] [all]";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_REQUIRED_ACKS_DEFAULT = "1";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_TIMEOUT_MS_CONF = "camel.sink.endpoint.requestTimeoutMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_TIMEOUT_MS_DOC = "The amount of time the broker will wait trying to meet the request.required.acks requirement before sending back an error to the client.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_TIMEOUT_MS_DEFAULT = "30000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRIES_CONF = "camel.sink.endpoint.retries";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRIES_DOC = "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRIES_DEFAULT = "0";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRY_BACKOFF_MS_CONF = "camel.sink.endpoint.retryBackoffMs";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRY_BACKOFF_MS_DOC = "Before each retry, the producer refreshes the metadata of relevant topics to see if a new leader has been elected. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_RETRY_BACKOFF_MS_DEFAULT = "100";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SEND_BUFFER_BYTES_CONF = "camel.sink.endpoint.sendBufferBytes";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SEND_BUFFER_BYTES_DOC = "Socket write buffer size";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SEND_BUFFER_BYTES_DEFAULT = "131072";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_VALUE_SERIALIZER_CONF = "camel.sink.endpoint.valueSerializer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_VALUE_SERIALIZER_DOC = "The serializer class for messages.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_VALUE_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.StringSerializer";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CONF = "camel.sink.endpoint.workerPool";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_DOC = "To use a custom worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing. If using this option then you must handle the lifecycle of the thread pool to shut the pool down when no longer needed.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CORE_SIZE_CONF = "camel.sink.endpoint.workerPoolCoreSize";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CORE_SIZE_DOC = "Number of core threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CORE_SIZE_DEFAULT = "10";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_MAX_SIZE_CONF = "camel.sink.endpoint.workerPoolMaxSize";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_MAX_SIZE_DOC = "Maximum number of threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_MAX_SIZE_DEFAULT = "20";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SYNCHRONOUS_CONF = "camel.sink.endpoint.synchronous";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used";
    public static final Boolean CAMEL_SINK_KAFKA_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SCHEMA_REGISTRY_URLCONF = "camel.sink.endpoint.schemaRegistryURL";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SCHEMA_REGISTRY_URLDOC = "URL of the Confluent Platform schema registry servers to use. The format is host1:port1,host2:port2. This is known as schema.registry.url in the Confluent Platform documentation. This option is only available in the Confluent Platform (not standard Apache Kafka)";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SCHEMA_REGISTRY_URLDEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_INTERCEPTOR_CLASSES_CONF = "camel.sink.endpoint.interceptorClasses";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_INTERCEPTOR_CLASSES_DOC = "Sets interceptors for producer or consumers. Producer interceptors have to be classes implementing org.apache.kafka.clients.producer.ProducerInterceptor Consumer interceptors have to be classes implementing org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if you use Producer interceptor on a consumer it will throw a class cast exception in runtime";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_INTERCEPTOR_CLASSES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_CONF = "camel.sink.endpoint.kerberosBeforeReloginMinTime";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_DOC = "Login thread sleep time between refresh attempts.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_DEFAULT = "60000";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_INIT_CMD_CONF = "camel.sink.endpoint.kerberosInitCmd";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_INIT_CMD_DOC = "Kerberos kinit command path. Default is /usr/bin/kinit";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_INIT_CMD_DEFAULT = "/usr/bin/kinit";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_CONF = "camel.sink.endpoint.kerberosPrincipalToLocalRules";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_DOC = "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form {username}/{hostname}{REALM} are mapped to {username}. For more details on the format please see the security authorization and acls documentation.. Multiple values can be separated by comma";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_DEFAULT = "DEFAULT";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_JITTER_CONF = "camel.sink.endpoint.kerberosRenewJitter";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_JITTER_DOC = "Percentage of random jitter added to the renewal time.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_JITTER_DEFAULT = "0.05";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_WINDOW_FACTOR_CONF = "camel.sink.endpoint.kerberosRenewWindowFactor";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_WINDOW_FACTOR_DOC = "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_WINDOW_FACTOR_DEFAULT = "0.8";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_JAAS_CONFIG_CONF = "camel.sink.endpoint.saslJaasConfig";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_JAAS_CONFIG_DOC = "Expose the kafka sasl.jaas.config parameter Example: org.apache.kafka.common.security.plain.PlainLoginModule required username=USERNAME password=PASSWORD;";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_JAAS_CONFIG_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_KERBEROS_SERVICE_NAME_CONF = "camel.sink.endpoint.saslKerberosServiceName";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_KERBEROS_SERVICE_NAME_DOC = "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_KERBEROS_SERVICE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_MECHANISM_CONF = "camel.sink.endpoint.saslMechanism";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_MECHANISM_DOC = "The Simple Authentication and Security Layer (SASL) Mechanism used. For the valid values see http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SASL_MECHANISM_DEFAULT = "GSSAPI";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SECURITY_PROTOCOL_CONF = "camel.sink.endpoint.securityProtocol";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SECURITY_PROTOCOL_DOC = "Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT and SSL are supported";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SECURITY_PROTOCOL_DEFAULT = "PLAINTEXT";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CIPHER_SUITES_CONF = "camel.sink.endpoint.sslCipherSuites";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CIPHER_SUITES_DOC = "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.By default all the available cipher suites are supported.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CIPHER_SUITES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF = "camel.sink.endpoint.sslContextParameters";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CONTEXT_PARAMETERS_DOC = "SSL configuration using a Camel SSLContextParameters object. If configured it's applied before the other SSL endpoint parameters. NOTE: Kafka only supports loading keystore from file locations, so prefix the location with file: in the KeyStoreParameters.resource option.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENABLED_PROTOCOLS_CONF = "camel.sink.endpoint.sslEnabledProtocols";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1 and TLSv1 are enabled by default.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENABLED_PROTOCOLS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENDPOINT_ALGORITHM_CONF = "camel.sink.endpoint.sslEndpointAlgorithm";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENDPOINT_ALGORITHM_DOC = "The endpoint identification algorithm to validate server hostname using server certificate.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENDPOINT_ALGORITHM_DEFAULT = "https";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYMANAGER_ALGORITHM_CONF = "camel.sink.endpoint.sslKeymanagerAlgorithm";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYMANAGER_ALGORITHM_DEFAULT = "SunX509";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEY_PASSWORD_CONF = "camel.sink.endpoint.sslKeyPassword";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_LOCATION_CONF = "camel.sink.endpoint.sslKeystoreLocation";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_PASSWORD_CONF = "camel.sink.endpoint.sslKeystorePassword";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file.This is optional for client and only needed if ssl.keystore.location is configured.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_TYPE_CONF = "camel.sink.endpoint.sslKeystoreType";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client. Default value is JKS";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROTOCOL_CONF = "camel.sink.endpoint.sslProtocol";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLS, which is fine for most cases. Allowed values in recent JVMs are TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROVIDER_CONF = "camel.sink.endpoint.sslProvider";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROVIDER_DOC = "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTMANAGER_ALGORITHM_CONF = "camel.sink.endpoint.sslTrustmanagerAlgorithm";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTMANAGER_ALGORITHM_DEFAULT = "PKIX";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_LOCATION_CONF = "camel.sink.endpoint.sslTruststoreLocation";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_PASSWORD_CONF = "camel.sink.endpoint.sslTruststorePassword";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_TYPE_CONF = "camel.sink.endpoint.sslTruststoreType";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file. Default value is JKS.";
    public static final String CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_ADDITIONAL_PROPERTIES_CONF = "camel.component.kafka.additionalProperties";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_ADDITIONAL_PROPERTIES_DOC = "Sets additional properties for either kafka consumer or kafka producer in case they can't be set directly on the camel configurations (e.g: new Kafka properties that are not reflected yet in Camel configurations), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BROKERS_CONF = "camel.component.kafka.brokers";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BROKERS_DOC = "URL of the Kafka brokers to use. The format is host1:port1,host2:port2, and the list can be a subset of brokers or a VIP pointing to a subset of brokers. This option is known as bootstrap.servers in the Kafka documentation.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BROKERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CLIENT_ID_CONF = "camel.component.kafka.clientId";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CLIENT_ID_DOC = "The client id is a user-specified string sent in each request to help trace calls. It should logically identify the application making the request.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CLIENT_ID_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_CONF = "camel.component.kafka.configuration";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_DOC = "Allows to pre-configure the Kafka component with common options that the endpoints will reuse.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_FILTER_STRATEGY_CONF = "camel.component.kafka.headerFilterStrategy";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_FILTER_STRATEGY_DOC = "To use a custom HeaderFilterStrategy to filter header to and from Camel message.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MAX_MS_CONF = "camel.component.kafka.reconnectBackoffMaxMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MAX_MS_DOC = "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MAX_MS_DEFAULT = "1000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SHUTDOWN_TIMEOUT_CONF = "camel.component.kafka.shutdownTimeout";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SHUTDOWN_TIMEOUT_DOC = "Timeout in milli seconds to wait gracefully for the consumer or producer to shutdown and terminate its worker threads.";
    public static final Integer CAMEL_SINK_KAFKA_COMPONENT_SHUTDOWN_TIMEOUT_DEFAULT = 30000;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BUFFER_MEMORY_SIZE_CONF = "camel.component.kafka.bufferMemorySize";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BUFFER_MEMORY_SIZE_DOC = "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by block.on.buffer.full.This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_BUFFER_MEMORY_SIZE_DEFAULT = "33554432";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_COMPRESSION_CODEC_CONF = "camel.component.kafka.compressionCodec";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_COMPRESSION_CODEC_DOC = "This parameter allows you to specify the compression codec for all data generated by this producer. Valid values are none, gzip and snappy. One of: [none] [gzip] [snappy] [lz4]";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_COMPRESSION_CODEC_DEFAULT = "none";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONNECTION_MAX_IDLE_MS_CONF = "camel.component.kafka.connectionMaxIdleMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONNECTION_MAX_IDLE_MS_DOC = "Close idle connections after the number of milliseconds specified by this config.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_CONNECTION_MAX_IDLE_MS_DEFAULT = "540000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_ENABLE_IDEMPOTENCE_CONF = "camel.component.kafka.enableIdempotence";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_ENABLE_IDEMPOTENCE_DOC = "If set to 'true' the producer will ensure that exactly one copy of each message is written in the stream. If 'false', producer retries may write duplicates of the retried message in the stream. If set to true this option will require max.in.flight.requests.per.connection to be set to 1 and retries cannot be zero and additionally acks must be set to 'all'.";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_ENABLE_IDEMPOTENCE_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_SERIALIZER_CONF = "camel.component.kafka.headerSerializer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_SERIALIZER_DOC = "To use a custom KafkaHeaderSerializer to serialize kafka headers values";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_HEADER_SERIALIZER_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_CONF = "camel.component.kafka.key";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_DOC = "The record key (or null if no key is specified). If this option has been configured then it take precedence over header KafkaConstants#KEY";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_SERIALIZER_CONF = "camel.component.kafka.keySerializer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_SERIALIZER_DOC = "The serializer class for keys (defaults to the same as for messages if nothing is given).";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KEY_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.StringSerializer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_LAZY_START_PRODUCER_CONF = "camel.component.kafka.lazyStartProducer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_LAZY_START_PRODUCER_DOC = "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_LAZY_START_PRODUCER_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_LINGER_MS_CONF = "camel.component.kafka.lingerMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_LINGER_MS_DOC = "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting linger.ms=5, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_LINGER_MS_DEFAULT = "0";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_BLOCK_MS_CONF = "camel.component.kafka.maxBlockMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_BLOCK_MS_DOC = "The configuration controls how long sending to kafka will block. These methods can be blocked for multiple reasons. For e.g: buffer full, metadata unavailable.This configuration imposes maximum limit on the total time spent in fetching metadata, serialization of key and value, partitioning and allocation of buffer memory when doing a send(). In case of partitionsFor(), this configuration imposes a maximum time threshold on waiting for metadata";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_BLOCK_MS_DEFAULT = "60000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_IN_FLIGHT_REQUEST_CONF = "camel.component.kafka.maxInFlightRequest";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_IN_FLIGHT_REQUEST_DOC = "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_IN_FLIGHT_REQUEST_DEFAULT = "5";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_REQUEST_SIZE_CONF = "camel.component.kafka.maxRequestSize";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_REQUEST_SIZE_DOC = "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_MAX_REQUEST_SIZE_DEFAULT = "1048576";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METADATA_MAX_AGE_MS_CONF = "camel.component.kafka.metadataMaxAgeMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METADATA_MAX_AGE_MS_DOC = "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METADATA_MAX_AGE_MS_DEFAULT = "300000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRIC_REPORTERS_CONF = "camel.component.kafka.metricReporters";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRIC_REPORTERS_DOC = "A list of classes to use as metrics reporters. Implementing the MetricReporter interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRIC_REPORTERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRICS_SAMPLE_WINDOW_MS_CONF = "camel.component.kafka.metricsSampleWindowMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRICS_SAMPLE_WINDOW_MS_DOC = "The number of samples maintained to compute metrics.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_METRICS_SAMPLE_WINDOW_MS_DEFAULT = "30000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_NO_OF_METRICS_SAMPLE_CONF = "camel.component.kafka.noOfMetricsSample";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_NO_OF_METRICS_SAMPLE_DOC = "The number of samples maintained to compute metrics.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_NO_OF_METRICS_SAMPLE_DEFAULT = "2";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITIONER_CONF = "camel.component.kafka.partitioner";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITIONER_DOC = "The partitioner class for partitioning messages amongst sub-topics. The default partitioner is based on the hash of the key.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITIONER_DEFAULT = "org.apache.kafka.clients.producer.internals.DefaultPartitioner";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITION_KEY_CONF = "camel.component.kafka.partitionKey";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITION_KEY_DOC = "The partition to which the record will be sent (or null if no partition was specified). If this option has been configured then it take precedence over header KafkaConstants#PARTITION_KEY";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PARTITION_KEY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PRODUCER_BATCH_SIZE_CONF = "camel.component.kafka.producerBatchSize";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PRODUCER_BATCH_SIZE_DOC = "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. No attempt will be made to batch records larger than this size.Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent.A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_PRODUCER_BATCH_SIZE_DEFAULT = "16384";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_QUEUE_BUFFERING_MAX_MESSAGES_CONF = "camel.component.kafka.queueBufferingMaxMessages";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_QUEUE_BUFFERING_MAX_MESSAGES_DOC = "The maximum number of unsent messages that can be queued up the producer when using async mode before either the producer must be blocked or data must be dropped.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_QUEUE_BUFFERING_MAX_MESSAGES_DEFAULT = "10000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECEIVE_BUFFER_BYTES_CONF = "camel.component.kafka.receiveBufferBytes";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECEIVE_BUFFER_BYTES_DOC = "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECEIVE_BUFFER_BYTES_DEFAULT = "65536";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MS_CONF = "camel.component.kafka.reconnectBackoffMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MS_DOC = "The amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all requests sent by the consumer to the broker.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MS_DEFAULT = "50";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECORD_METADATA_CONF = "camel.component.kafka.recordMetadata";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RECORD_METADATA_DOC = "Whether the producer should store the RecordMetadata results from sending to Kafka. The results are stored in a List containing the RecordMetadata metadata's. The list is stored on a header with the key KafkaConstants#KAFKA_RECORDMETA";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_RECORD_METADATA_DEFAULT = true;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_REQUIRED_ACKS_CONF = "camel.component.kafka.requestRequiredAcks";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_REQUIRED_ACKS_DOC = "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent. The following settings are common: acks=0 If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the retries configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. acks=1 This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. acks=all This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee. One of: [-1] [0] [1] [all]";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_REQUIRED_ACKS_DEFAULT = "1";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_TIMEOUT_MS_CONF = "camel.component.kafka.requestTimeoutMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_TIMEOUT_MS_DOC = "The amount of time the broker will wait trying to meet the request.required.acks requirement before sending back an error to the client.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_REQUEST_TIMEOUT_MS_DEFAULT = "30000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRIES_CONF = "camel.component.kafka.retries";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRIES_DOC = "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRIES_DEFAULT = "0";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRY_BACKOFF_MS_CONF = "camel.component.kafka.retryBackoffMs";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRY_BACKOFF_MS_DOC = "Before each retry, the producer refreshes the metadata of relevant topics to see if a new leader has been elected. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_RETRY_BACKOFF_MS_DEFAULT = "100";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SEND_BUFFER_BYTES_CONF = "camel.component.kafka.sendBufferBytes";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SEND_BUFFER_BYTES_DOC = "Socket write buffer size";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SEND_BUFFER_BYTES_DEFAULT = "131072";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_VALUE_SERIALIZER_CONF = "camel.component.kafka.valueSerializer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_VALUE_SERIALIZER_DOC = "The serializer class for messages.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_VALUE_SERIALIZER_DEFAULT = "org.apache.kafka.common.serialization.StringSerializer";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CONF = "camel.component.kafka.workerPool";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_DOC = "To use a custom worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing. If using this option then you must handle the lifecycle of the thread pool to shut the pool down when no longer needed.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CORE_SIZE_CONF = "camel.component.kafka.workerPoolCoreSize";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CORE_SIZE_DOC = "Number of core threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CORE_SIZE_DEFAULT = "10";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_MAX_SIZE_CONF = "camel.component.kafka.workerPoolMaxSize";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_MAX_SIZE_DOC = "Maximum number of threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_MAX_SIZE_DEFAULT = "20";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.kafka.autowiredEnabled";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_CONF = "camel.component.kafka.kafkaClientFactory";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_DOC = "Factory to use for creating org.apache.kafka.clients.consumer.KafkaConsumer and org.apache.kafka.clients.producer.KafkaProducer instances. This allows to configure a custom factory to create instances with logic that extends the vanilla Kafka clients.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SYNCHRONOUS_CONF = "camel.component.kafka.synchronous";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SCHEMA_REGISTRY_URLCONF = "camel.component.kafka.schemaRegistryURL";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SCHEMA_REGISTRY_URLDOC = "URL of the Confluent Platform schema registry servers to use. The format is host1:port1,host2:port2. This is known as schema.registry.url in the Confluent Platform documentation. This option is only available in the Confluent Platform (not standard Apache Kafka)";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SCHEMA_REGISTRY_URLDEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_INTERCEPTOR_CLASSES_CONF = "camel.component.kafka.interceptorClasses";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_INTERCEPTOR_CLASSES_DOC = "Sets interceptors for producer or consumers. Producer interceptors have to be classes implementing org.apache.kafka.clients.producer.ProducerInterceptor Consumer interceptors have to be classes implementing org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if you use Producer interceptor on a consumer it will throw a class cast exception in runtime";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_INTERCEPTOR_CLASSES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_CONF = "camel.component.kafka.kerberosBeforeReloginMinTime";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_DOC = "Login thread sleep time between refresh attempts.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_DEFAULT = "60000";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_INIT_CMD_CONF = "camel.component.kafka.kerberosInitCmd";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_INIT_CMD_DOC = "Kerberos kinit command path. Default is /usr/bin/kinit";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_INIT_CMD_DEFAULT = "/usr/bin/kinit";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_CONF = "camel.component.kafka.kerberosPrincipalToLocalRules";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_DOC = "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form {username}/{hostname}{REALM} are mapped to {username}. For more details on the format please see the security authorization and acls documentation.. Multiple values can be separated by comma";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_DEFAULT = "DEFAULT";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_JITTER_CONF = "camel.component.kafka.kerberosRenewJitter";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_JITTER_DOC = "Percentage of random jitter added to the renewal time.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_JITTER_DEFAULT = "0.05";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_WINDOW_FACTOR_CONF = "camel.component.kafka.kerberosRenewWindowFactor";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_WINDOW_FACTOR_DOC = "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_WINDOW_FACTOR_DEFAULT = "0.8";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_JAAS_CONFIG_CONF = "camel.component.kafka.saslJaasConfig";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_JAAS_CONFIG_DOC = "Expose the kafka sasl.jaas.config parameter Example: org.apache.kafka.common.security.plain.PlainLoginModule required username=USERNAME password=PASSWORD;";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_JAAS_CONFIG_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_KERBEROS_SERVICE_NAME_CONF = "camel.component.kafka.saslKerberosServiceName";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_KERBEROS_SERVICE_NAME_DOC = "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_KERBEROS_SERVICE_NAME_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_MECHANISM_CONF = "camel.component.kafka.saslMechanism";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_MECHANISM_DOC = "The Simple Authentication and Security Layer (SASL) Mechanism used. For the valid values see http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SASL_MECHANISM_DEFAULT = "GSSAPI";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SECURITY_PROTOCOL_CONF = "camel.component.kafka.securityProtocol";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SECURITY_PROTOCOL_DOC = "Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT and SSL are supported";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SECURITY_PROTOCOL_DEFAULT = "PLAINTEXT";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CIPHER_SUITES_CONF = "camel.component.kafka.sslCipherSuites";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CIPHER_SUITES_DOC = "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.By default all the available cipher suites are supported.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CIPHER_SUITES_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.kafka.sslContextParameters";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CONTEXT_PARAMETERS_DOC = "SSL configuration using a Camel SSLContextParameters object. If configured it's applied before the other SSL endpoint parameters. NOTE: Kafka only supports loading keystore from file locations, so prefix the location with file: in the KeyStoreParameters.resource option.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENABLED_PROTOCOLS_CONF = "camel.component.kafka.sslEnabledProtocols";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1 and TLSv1 are enabled by default.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENABLED_PROTOCOLS_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENDPOINT_ALGORITHM_CONF = "camel.component.kafka.sslEndpointAlgorithm";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENDPOINT_ALGORITHM_DOC = "The endpoint identification algorithm to validate server hostname using server certificate.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_ENDPOINT_ALGORITHM_DEFAULT = "https";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYMANAGER_ALGORITHM_CONF = "camel.component.kafka.sslKeymanagerAlgorithm";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYMANAGER_ALGORITHM_DOC = "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYMANAGER_ALGORITHM_DEFAULT = "SunX509";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEY_PASSWORD_CONF = "camel.component.kafka.sslKeyPassword";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEY_PASSWORD_DOC = "The password of the private key in the key store file. This is optional for client.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEY_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_LOCATION_CONF = "camel.component.kafka.sslKeystoreLocation";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_LOCATION_DOC = "The location of the key store file. This is optional for client and can be used for two-way authentication for client.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_PASSWORD_CONF = "camel.component.kafka.sslKeystorePassword";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_PASSWORD_DOC = "The store password for the key store file.This is optional for client and only needed if ssl.keystore.location is configured.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_TYPE_CONF = "camel.component.kafka.sslKeystoreType";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_TYPE_DOC = "The file format of the key store file. This is optional for client. Default value is JKS";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_TYPE_DEFAULT = "JKS";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROTOCOL_CONF = "camel.component.kafka.sslProtocol";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROTOCOL_DOC = "The SSL protocol used to generate the SSLContext. Default setting is TLS, which is fine for most cases. Allowed values in recent JVMs are TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROTOCOL_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROVIDER_CONF = "camel.component.kafka.sslProvider";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROVIDER_DOC = "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_PROVIDER_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTMANAGER_ALGORITHM_CONF = "camel.component.kafka.sslTrustmanagerAlgorithm";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTMANAGER_ALGORITHM_DOC = "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTMANAGER_ALGORITHM_DEFAULT = "PKIX";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_LOCATION_CONF = "camel.component.kafka.sslTruststoreLocation";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_LOCATION_DOC = "The location of the trust store file.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_LOCATION_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_PASSWORD_CONF = "camel.component.kafka.sslTruststorePassword";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_PASSWORD_DOC = "The password for the trust store file.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_TYPE_CONF = "camel.component.kafka.sslTruststoreType";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_TYPE_DOC = "The file format of the trust store file. Default value is JKS.";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_TYPE_DEFAULT = "JKS";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF = "camel.component.kafka.useGlobalSslContextParameters";
    public static final String CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC = "Enable usage of global SSL context parameters.";
    public static final Boolean CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT = false;

    public CamelKafkaSinkConnectorConfig(ConfigDef config, Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelKafkaSinkConnectorConfig(Map<String, String> parsedConfig) {
        this(CamelKafkaSinkConnectorConfig.conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSinkConnectorConfig.conf());
        conf.define(CAMEL_SINK_KAFKA_PATH_TOPIC_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_PATH_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SINK_KAFKA_PATH_TOPIC_DOC);
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets additional properties for either kafka consumer or kafka producer in case they can't be set directly on the camel configurations (e.g: new Kafka properties that are not reflected yet in Camel configurations), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_BROKERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_BROKERS_DEFAULT, ConfigDef.Importance.MEDIUM, "URL of the Kafka brokers to use. The format is host1:port1,host2:port2, and the list can be a subset of brokers or a VIP pointing to a subset of brokers. This option is known as bootstrap.servers in the Kafka documentation.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_CLIENT_ID_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, "The client id is a user-specified string sent in each request to help trace calls. It should logically identify the application making the request.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom HeaderFilterStrategy to filter header to and from Camel message.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MAX_MS_CONF, ConfigDef.Type.STRING, (Object)"1000", ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SHUTDOWN_TIMEOUT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SHUTDOWN_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, "Timeout in milli seconds to wait gracefully for the consumer or producer to shutdown and terminate its worker threads.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_BUFFER_MEMORY_SIZE_CONF, ConfigDef.Type.STRING, (Object)"33554432", ConfigDef.Importance.MEDIUM, "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by block.on.buffer.full.This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_COMPRESSION_CODEC_CONF, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.MEDIUM, "This parameter allows you to specify the compression codec for all data generated by this producer. Valid values are none, gzip and snappy. One of: [none] [gzip] [snappy] [lz4]");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_CONNECTION_MAX_IDLE_MS_CONF, ConfigDef.Type.STRING, (Object)"540000", ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_ENABLE_IDEMPOTENCE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_ENDPOINT_ENABLE_IDEMPOTENCE_DEFAULT, ConfigDef.Importance.MEDIUM, "If set to 'true' the producer will ensure that exactly one copy of each message is written in the stream. If 'false', producer retries may write duplicates of the retried message in the stream. If set to true this option will require max.in.flight.requests.per.connection to be set to 1 and retries cannot be zero and additionally acks must be set to 'all'.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_HEADER_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_HEADER_SERIALIZER_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom KafkaHeaderSerializer to serialize kafka headers values");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KEY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, "The record key (or null if no key is specified). If this option has been configured then it take precedence over header KafkaConstants#KEY");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KEY_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.common.serialization.StringSerializer", ConfigDef.Importance.MEDIUM, "The serializer class for keys (defaults to the same as for messages if nothing is given).");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_ENDPOINT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_LINGER_MS_CONF, ConfigDef.Type.STRING, (Object)"0", ConfigDef.Importance.MEDIUM, "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting linger.ms=5, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_MAX_BLOCK_MS_CONF, ConfigDef.Type.STRING, (Object)"60000", ConfigDef.Importance.MEDIUM, "The configuration controls how long sending to kafka will block. These methods can be blocked for multiple reasons. For e.g: buffer full, metadata unavailable.This configuration imposes maximum limit on the total time spent in fetching metadata, serialization of key and value, partitioning and allocation of buffer memory when doing a send(). In case of partitionsFor(), this configuration imposes a maximum time threshold on waiting for metadata");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_MAX_IN_FLIGHT_REQUEST_CONF, ConfigDef.Type.STRING, (Object)"5", ConfigDef.Importance.MEDIUM, "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_MAX_REQUEST_SIZE_CONF, ConfigDef.Type.STRING, (Object)"1048576", ConfigDef.Importance.MEDIUM, "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_METADATA_MAX_AGE_MS_CONF, ConfigDef.Type.STRING, (Object)"300000", ConfigDef.Importance.MEDIUM, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_METRIC_REPORTERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_METRIC_REPORTERS_DEFAULT, ConfigDef.Importance.MEDIUM, "A list of classes to use as metrics reporters. Implementing the MetricReporter interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_METRICS_SAMPLE_WINDOW_MS_CONF, ConfigDef.Type.STRING, (Object)"30000", ConfigDef.Importance.MEDIUM, "The number of samples maintained to compute metrics.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_NO_OF_METRICS_SAMPLE_CONF, ConfigDef.Type.STRING, (Object)"2", ConfigDef.Importance.MEDIUM, "The number of samples maintained to compute metrics.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_PARTITIONER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.clients.producer.internals.DefaultPartitioner", ConfigDef.Importance.MEDIUM, "The partitioner class for partitioning messages amongst sub-topics. The default partitioner is based on the hash of the key.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_PARTITION_KEY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_PARTITION_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, "The partition to which the record will be sent (or null if no partition was specified). If this option has been configured then it take precedence over header KafkaConstants#PARTITION_KEY");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_PRODUCER_BATCH_SIZE_CONF, ConfigDef.Type.STRING, (Object)"16384", ConfigDef.Importance.MEDIUM, "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. No attempt will be made to batch records larger than this size.Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent.A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_QUEUE_BUFFERING_MAX_MESSAGES_CONF, ConfigDef.Type.STRING, (Object)"10000", ConfigDef.Importance.MEDIUM, "The maximum number of unsent messages that can be queued up the producer when using async mode before either the producer must be blocked or data must be dropped.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RECEIVE_BUFFER_BYTES_CONF, ConfigDef.Type.STRING, (Object)"65536", ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RECONNECT_BACKOFF_MS_CONF, ConfigDef.Type.STRING, (Object)"50", ConfigDef.Importance.MEDIUM, "The amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all requests sent by the consumer to the broker.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RECORD_METADATA_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_ENDPOINT_RECORD_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should store the RecordMetadata results from sending to Kafka. The results are stored in a List containing the RecordMetadata metadata's. The list is stored on a header with the key KafkaConstants#KAFKA_RECORDMETA");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_REQUIRED_ACKS_CONF, ConfigDef.Type.STRING, (Object)"1", ConfigDef.Importance.MEDIUM, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent. The following settings are common: acks=0 If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the retries configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. acks=1 This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. acks=all This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee. One of: [-1] [0] [1] [all]");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_REQUEST_TIMEOUT_MS_CONF, ConfigDef.Type.STRING, (Object)"30000", ConfigDef.Importance.MEDIUM, "The amount of time the broker will wait trying to meet the request.required.acks requirement before sending back an error to the client.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RETRIES_CONF, ConfigDef.Type.STRING, (Object)"0", ConfigDef.Importance.MEDIUM, "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_RETRY_BACKOFF_MS_CONF, ConfigDef.Type.STRING, (Object)"100", ConfigDef.Importance.MEDIUM, "Before each retry, the producer refreshes the metadata of relevant topics to see if a new leader has been elected. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SEND_BUFFER_BYTES_CONF, ConfigDef.Type.STRING, (Object)"131072", ConfigDef.Importance.MEDIUM, "Socket write buffer size");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_VALUE_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.common.serialization.StringSerializer", ConfigDef.Importance.MEDIUM, "The serializer class for messages.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing. If using this option then you must handle the lifecycle of the thread pool to shut the pool down when no longer needed.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_CORE_SIZE_CONF, ConfigDef.Type.STRING, (Object)"10", ConfigDef.Importance.MEDIUM, "Number of core threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_WORKER_POOL_MAX_SIZE_CONF, ConfigDef.Type.STRING, (Object)"20", ConfigDef.Importance.MEDIUM, "Maximum number of threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets whether synchronous processing should be strictly used");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SCHEMA_REGISTRY_URLCONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SCHEMA_REGISTRY_URLDEFAULT, ConfigDef.Importance.MEDIUM, "URL of the Confluent Platform schema registry servers to use. The format is host1:port1,host2:port2. This is known as schema.registry.url in the Confluent Platform documentation. This option is only available in the Confluent Platform (not standard Apache Kafka)");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_INTERCEPTOR_CLASSES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_INTERCEPTOR_CLASSES_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets interceptors for producer or consumers. Producer interceptors have to be classes implementing org.apache.kafka.clients.producer.ProducerInterceptor Consumer interceptors have to be classes implementing org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if you use Producer interceptor on a consumer it will throw a class cast exception in runtime");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_CONF, ConfigDef.Type.STRING, (Object)"60000", ConfigDef.Importance.MEDIUM, "Login thread sleep time between refresh attempts.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_INIT_CMD_CONF, ConfigDef.Type.STRING, (Object)"/usr/bin/kinit", ConfigDef.Importance.MEDIUM, "Kerberos kinit command path. Default is /usr/bin/kinit");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_CONF, ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form {username}/{hostname}{REALM} are mapped to {username}. For more details on the format please see the security authorization and acls documentation.. Multiple values can be separated by comma");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_JITTER_CONF, ConfigDef.Type.STRING, (Object)"0.05", ConfigDef.Importance.MEDIUM, "Percentage of random jitter added to the renewal time.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_KERBEROS_RENEW_WINDOW_FACTOR_CONF, ConfigDef.Type.STRING, (Object)"0.8", ConfigDef.Importance.MEDIUM, "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SASL_JAAS_CONFIG_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SASL_JAAS_CONFIG_DEFAULT, ConfigDef.Importance.MEDIUM, "Expose the kafka sasl.jaas.config parameter Example: org.apache.kafka.common.security.plain.PlainLoginModule required username=USERNAME password=PASSWORD;");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SASL_KERBEROS_SERVICE_NAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SASL_KERBEROS_SERVICE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SASL_MECHANISM_CONF, ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "The Simple Authentication and Security Layer (SASL) Mechanism used. For the valid values see http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SECURITY_PROTOCOL_CONF, ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT and SSL are supported");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_CIPHER_SUITES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_CIPHER_SUITES_DEFAULT, ConfigDef.Importance.MEDIUM, "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.By default all the available cipher suites are supported.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, "SSL configuration using a Camel SSLContextParameters object. If configured it's applied before the other SSL endpoint parameters. NOTE: Kafka only supports loading keystore from file locations, so prefix the location with file: in the KeyStoreParameters.resource option.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1 and TLSv1 are enabled by default.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_ENDPOINT_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"https", ConfigDef.Importance.MEDIUM, "The endpoint identification algorithm to validate server hostname using server certificate.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYMANAGER_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"SunX509", ConfigDef.Importance.MEDIUM, "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEY_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password of the private key in the key store file. This is optional for client.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_LOCATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, "The location of the key store file. This is optional for client and can be used for two-way authentication for client.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The store password for the key store file.This is optional for client and only needed if ssl.keystore.location is configured.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_KEYSTORE_TYPE_CONF, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the key store file. This is optional for client. Default value is JKS");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, "The SSL protocol used to generate the SSLContext. Default setting is TLS, which is fine for most cases. Allowed values in recent JVMs are TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROVIDER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTMANAGER_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"PKIX", ConfigDef.Importance.MEDIUM, "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_LOCATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, "The location of the trust store file.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password for the trust store file.");
        conf.define(CAMEL_SINK_KAFKA_ENDPOINT_SSL_TRUSTSTORE_TYPE_CONF, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the trust store file. Default value is JKS.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_ADDITIONAL_PROPERTIES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_ADDITIONAL_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets additional properties for either kafka consumer or kafka producer in case they can't be set directly on the camel configurations (e.g: new Kafka properties that are not reflected yet in Camel configurations), the properties have to be prefixed with additionalProperties.. E.g: additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_BROKERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_BROKERS_DEFAULT, ConfigDef.Importance.MEDIUM, "URL of the Kafka brokers to use. The format is host1:port1,host2:port2, and the list can be a subset of brokers or a VIP pointing to a subset of brokers. This option is known as bootstrap.servers in the Kafka documentation.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_CLIENT_ID_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_CLIENT_ID_DEFAULT, ConfigDef.Importance.MEDIUM, "The client id is a user-specified string sent in each request to help trace calls. It should logically identify the application making the request.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_KAFKA_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_HEADER_FILTER_STRATEGY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_HEADER_FILTER_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom HeaderFilterStrategy to filter header to and from Camel message.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MAX_MS_CONF, ConfigDef.Type.STRING, (Object)"1000", ConfigDef.Importance.MEDIUM, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SHUTDOWN_TIMEOUT_CONF, ConfigDef.Type.INT, (Object)CAMEL_SINK_KAFKA_COMPONENT_SHUTDOWN_TIMEOUT_DEFAULT, ConfigDef.Importance.MEDIUM, "Timeout in milli seconds to wait gracefully for the consumer or producer to shutdown and terminate its worker threads.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_BUFFER_MEMORY_SIZE_CONF, ConfigDef.Type.STRING, (Object)"33554432", ConfigDef.Importance.MEDIUM, "The total bytes of memory the producer can use to buffer records waiting to be sent to the server. If records are sent faster than they can be delivered to the server the producer will either block or throw an exception based on the preference specified by block.on.buffer.full.This setting should correspond roughly to the total memory the producer will use, but is not a hard bound since not all memory the producer uses is used for buffering. Some additional memory will be used for compression (if compression is enabled) as well as for maintaining in-flight requests.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_COMPRESSION_CODEC_CONF, ConfigDef.Type.STRING, (Object)"none", ConfigDef.Importance.MEDIUM, "This parameter allows you to specify the compression codec for all data generated by this producer. Valid values are none, gzip and snappy. One of: [none] [gzip] [snappy] [lz4]");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_CONNECTION_MAX_IDLE_MS_CONF, ConfigDef.Type.STRING, (Object)"540000", ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_ENABLE_IDEMPOTENCE_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_ENABLE_IDEMPOTENCE_DEFAULT, ConfigDef.Importance.MEDIUM, "If set to 'true' the producer will ensure that exactly one copy of each message is written in the stream. If 'false', producer retries may write duplicates of the retried message in the stream. If set to true this option will require max.in.flight.requests.per.connection to be set to 1 and retries cannot be zero and additionally acks must be set to 'all'.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_HEADER_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_HEADER_SERIALIZER_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom KafkaHeaderSerializer to serialize kafka headers values");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KEY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, "The record key (or null if no key is specified). If this option has been configured then it take precedence over header KafkaConstants#KEY");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KEY_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.common.serialization.StringSerializer", ConfigDef.Importance.MEDIUM, "The serializer class for keys (defaults to the same as for messages if nothing is given).");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_LAZY_START_PRODUCER_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_LAZY_START_PRODUCER_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should be started lazy (on the first message). By starting lazy you can use this to allow CamelContext and routes to startup in situations where a producer may otherwise fail during starting and cause the route to fail being started. By deferring this startup to be lazy then the startup failure can be handled during routing messages via Camel's routing error handlers. Beware that when the first message is processed then creating and starting the producer may take a little time and prolong the total processing time of the processing.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_LINGER_MS_CONF, ConfigDef.Type.STRING, (Object)"0", ConfigDef.Importance.MEDIUM, "The producer groups together any records that arrive in between request transmissions into a single batched request. Normally this occurs only under load when records arrive faster than they can be sent out. However in some circumstances the client may want to reduce the number of requests even under moderate load. This setting accomplishes this by adding a small amount of artificial delay that is, rather than immediately sending out a record the producer will wait for up to the given delay to allow other records to be sent so that the sends can be batched together. This can be thought of as analogous to Nagle's algorithm in TCP. This setting gives the upper bound on the delay for batching: once we get batch.size worth of records for a partition it will be sent immediately regardless of this setting, however if we have fewer than this many bytes accumulated for this partition we will 'linger' for the specified time waiting for more records to show up. This setting defaults to 0 (i.e. no delay). Setting linger.ms=5, for example, would have the effect of reducing the number of requests sent but would add up to 5ms of latency to records sent in the absense of load.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_MAX_BLOCK_MS_CONF, ConfigDef.Type.STRING, (Object)"60000", ConfigDef.Importance.MEDIUM, "The configuration controls how long sending to kafka will block. These methods can be blocked for multiple reasons. For e.g: buffer full, metadata unavailable.This configuration imposes maximum limit on the total time spent in fetching metadata, serialization of key and value, partitioning and allocation of buffer memory when doing a send(). In case of partitionsFor(), this configuration imposes a maximum time threshold on waiting for metadata");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_MAX_IN_FLIGHT_REQUEST_CONF, ConfigDef.Type.STRING, (Object)"5", ConfigDef.Importance.MEDIUM, "The maximum number of unacknowledged requests the client will send on a single connection before blocking. Note that if this setting is set to be greater than 1 and there are failed sends, there is a risk of message re-ordering due to retries (i.e., if retries are enabled).");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_MAX_REQUEST_SIZE_CONF, ConfigDef.Type.STRING, (Object)"1048576", ConfigDef.Importance.MEDIUM, "The maximum size of a request. This is also effectively a cap on the maximum record size. Note that the server has its own cap on record size which may be different from this. This setting will limit the number of record batches the producer will send in a single request to avoid sending huge requests.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_METADATA_MAX_AGE_MS_CONF, ConfigDef.Type.STRING, (Object)"300000", ConfigDef.Importance.MEDIUM, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_METRIC_REPORTERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_METRIC_REPORTERS_DEFAULT, ConfigDef.Importance.MEDIUM, "A list of classes to use as metrics reporters. Implementing the MetricReporter interface allows plugging in classes that will be notified of new metric creation. The JmxReporter is always included to register JMX statistics.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_METRICS_SAMPLE_WINDOW_MS_CONF, ConfigDef.Type.STRING, (Object)"30000", ConfigDef.Importance.MEDIUM, "The number of samples maintained to compute metrics.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_NO_OF_METRICS_SAMPLE_CONF, ConfigDef.Type.STRING, (Object)"2", ConfigDef.Importance.MEDIUM, "The number of samples maintained to compute metrics.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_PARTITIONER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.clients.producer.internals.DefaultPartitioner", ConfigDef.Importance.MEDIUM, "The partitioner class for partitioning messages amongst sub-topics. The default partitioner is based on the hash of the key.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_PARTITION_KEY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_PARTITION_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, "The partition to which the record will be sent (or null if no partition was specified). If this option has been configured then it take precedence over header KafkaConstants#PARTITION_KEY");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_PRODUCER_BATCH_SIZE_CONF, ConfigDef.Type.STRING, (Object)"16384", ConfigDef.Importance.MEDIUM, "The producer will attempt to batch records together into fewer requests whenever multiple records are being sent to the same partition. This helps performance on both the client and the server. This configuration controls the default batch size in bytes. No attempt will be made to batch records larger than this size.Requests sent to brokers will contain multiple batches, one for each partition with data available to be sent.A small batch size will make batching less common and may reduce throughput (a batch size of zero will disable batching entirely). A very large batch size may use memory a bit more wastefully as we will always allocate a buffer of the specified batch size in anticipation of additional records.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_QUEUE_BUFFERING_MAX_MESSAGES_CONF, ConfigDef.Type.STRING, (Object)"10000", ConfigDef.Importance.MEDIUM, "The maximum number of unsent messages that can be queued up the producer when using async mode before either the producer must be blocked or data must be dropped.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RECEIVE_BUFFER_BYTES_CONF, ConfigDef.Type.STRING, (Object)"65536", ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RECONNECT_BACKOFF_MS_CONF, ConfigDef.Type.STRING, (Object)"50", ConfigDef.Importance.MEDIUM, "The amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all requests sent by the consumer to the broker.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RECORD_METADATA_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_RECORD_METADATA_DEFAULT, ConfigDef.Importance.MEDIUM, "Whether the producer should store the RecordMetadata results from sending to Kafka. The results are stored in a List containing the RecordMetadata metadata's. The list is stored on a header with the key KafkaConstants#KAFKA_RECORDMETA");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_REQUEST_REQUIRED_ACKS_CONF, ConfigDef.Type.STRING, (Object)"1", ConfigDef.Importance.MEDIUM, "The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the durability of records that are sent. The following settings are common: acks=0 If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the retries configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to -1. acks=1 This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. acks=all This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee. One of: [-1] [0] [1] [all]");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_REQUEST_TIMEOUT_MS_CONF, ConfigDef.Type.STRING, (Object)"30000", ConfigDef.Importance.MEDIUM, "The amount of time the broker will wait trying to meet the request.required.acks requirement before sending back an error to the client.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RETRIES_CONF, ConfigDef.Type.STRING, (Object)"0", ConfigDef.Importance.MEDIUM, "Setting a value greater than zero will cause the client to resend any record whose send fails with a potentially transient error. Note that this retry is no different than if the client resent the record upon receiving the error. Allowing retries will potentially change the ordering of records because if two records are sent to a single partition, and the first fails and is retried but the second succeeds, then the second record may appear first.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_RETRY_BACKOFF_MS_CONF, ConfigDef.Type.STRING, (Object)"100", ConfigDef.Importance.MEDIUM, "Before each retry, the producer refreshes the metadata of relevant topics to see if a new leader has been elected. Since leader election takes a bit of time, this property specifies the amount of time that the producer waits before refreshing the metadata.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SEND_BUFFER_BYTES_CONF, ConfigDef.Type.STRING, (Object)"131072", ConfigDef.Importance.MEDIUM, "Socket write buffer size");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_VALUE_SERIALIZER_CONF, ConfigDef.Type.STRING, (Object)"org.apache.kafka.common.serialization.StringSerializer", ConfigDef.Importance.MEDIUM, "The serializer class for messages.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_DEFAULT, ConfigDef.Importance.MEDIUM, "To use a custom worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing. If using this option then you must handle the lifecycle of the thread pool to shut the pool down when no longer needed.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_CORE_SIZE_CONF, ConfigDef.Type.STRING, (Object)"10", ConfigDef.Importance.MEDIUM, "Number of core threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_WORKER_POOL_MAX_SIZE_CONF, ConfigDef.Type.STRING, (Object)"20", ConfigDef.Importance.MEDIUM, "Maximum number of threads for the worker pool for continue routing Exchange after kafka server has acknowledge the message that was sent to it from KafkaProducer using asynchronous non-blocking processing.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_KAFKA_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_KAFKA_COMPONENT_KAFKA_CLIENT_FACTORY_DOC);
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets whether synchronous processing should be strictly used");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SCHEMA_REGISTRY_URLCONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SCHEMA_REGISTRY_URLDEFAULT, ConfigDef.Importance.MEDIUM, "URL of the Confluent Platform schema registry servers to use. The format is host1:port1,host2:port2. This is known as schema.registry.url in the Confluent Platform documentation. This option is only available in the Confluent Platform (not standard Apache Kafka)");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_INTERCEPTOR_CLASSES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_INTERCEPTOR_CLASSES_DEFAULT, ConfigDef.Importance.MEDIUM, "Sets interceptors for producer or consumers. Producer interceptors have to be classes implementing org.apache.kafka.clients.producer.ProducerInterceptor Consumer interceptors have to be classes implementing org.apache.kafka.clients.consumer.ConsumerInterceptor Note that if you use Producer interceptor on a consumer it will throw a class cast exception in runtime");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_BEFORE_RELOGIN_MIN_TIME_CONF, ConfigDef.Type.STRING, (Object)"60000", ConfigDef.Importance.MEDIUM, "Login thread sleep time between refresh attempts.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_INIT_CMD_CONF, ConfigDef.Type.STRING, (Object)"/usr/bin/kinit", ConfigDef.Importance.MEDIUM, "Kerberos kinit command path. Default is /usr/bin/kinit");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_PRINCIPAL_TO_LOCAL_RULES_CONF, ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.MEDIUM, "A list of rules for mapping from principal names to short names (typically operating system usernames). The rules are evaluated in order and the first rule that matches a principal name is used to map it to a short name. Any later rules in the list are ignored. By default, principal names of the form {username}/{hostname}{REALM} are mapped to {username}. For more details on the format please see the security authorization and acls documentation.. Multiple values can be separated by comma");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_JITTER_CONF, ConfigDef.Type.STRING, (Object)"0.05", ConfigDef.Importance.MEDIUM, "Percentage of random jitter added to the renewal time.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_KERBEROS_RENEW_WINDOW_FACTOR_CONF, ConfigDef.Type.STRING, (Object)"0.8", ConfigDef.Importance.MEDIUM, "Login thread will sleep until the specified window factor of time from last refresh to ticket's expiry has been reached, at which time it will try to renew the ticket.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SASL_JAAS_CONFIG_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_COMPONENT_SASL_JAAS_CONFIG_DEFAULT, ConfigDef.Importance.MEDIUM, "Expose the kafka sasl.jaas.config parameter Example: org.apache.kafka.common.security.plain.PlainLoginModule required username=USERNAME password=PASSWORD;");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SASL_KERBEROS_SERVICE_NAME_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SASL_KERBEROS_SERVICE_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, "The Kerberos principal name that Kafka runs as. This can be defined either in Kafka's JAAS config or in Kafka's config.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SASL_MECHANISM_CONF, ConfigDef.Type.STRING, (Object)"GSSAPI", ConfigDef.Importance.MEDIUM, "The Simple Authentication and Security Layer (SASL) Mechanism used. For the valid values see http://www.iana.org/assignments/sasl-mechanisms/sasl-mechanisms.xhtml");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SECURITY_PROTOCOL_CONF, ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, "Protocol used to communicate with brokers. SASL_PLAINTEXT, PLAINTEXT and SSL are supported");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_CIPHER_SUITES_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_CIPHER_SUITES_DEFAULT, ConfigDef.Importance.MEDIUM, "A list of cipher suites. This is a named combination of authentication, encryption, MAC and key exchange algorithm used to negotiate the security settings for a network connection using TLS or SSL network protocol.By default all the available cipher suites are supported.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, "SSL configuration using a Camel SSLContextParameters object. If configured it's applied before the other SSL endpoint parameters. NOTE: Kafka only supports loading keystore from file locations, so prefix the location with file: in the KeyStoreParameters.resource option.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_ENABLED_PROTOCOLS_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_ENABLED_PROTOCOLS_DEFAULT, ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. TLSv1.2, TLSv1.1 and TLSv1 are enabled by default.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_ENDPOINT_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"https", ConfigDef.Importance.MEDIUM, "The endpoint identification algorithm to validate server hostname using server certificate.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYMANAGER_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"SunX509", ConfigDef.Importance.MEDIUM, "The algorithm used by key manager factory for SSL connections. Default value is the key manager factory algorithm configured for the Java Virtual Machine.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_KEY_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_KEY_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password of the private key in the key store file. This is optional for client.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_LOCATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, "The location of the key store file. This is optional for client and can be used for two-way authentication for client.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The store password for the key store file.This is optional for client and only needed if ssl.keystore.location is configured.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_KEYSTORE_TYPE_CONF, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the key store file. This is optional for client. Default value is JKS");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_PROTOCOL_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_PROTOCOL_DEFAULT, ConfigDef.Importance.MEDIUM, "The SSL protocol used to generate the SSLContext. Default setting is TLS, which is fine for most cases. Allowed values in recent JVMs are TLS, TLSv1.1 and TLSv1.2. SSL, SSLv2 and SSLv3 may be supported in older JVMs, but their usage is discouraged due to known security vulnerabilities.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_PROVIDER_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_PROVIDER_DEFAULT, ConfigDef.Importance.MEDIUM, "The name of the security provider used for SSL connections. Default value is the default security provider of the JVM.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTMANAGER_ALGORITHM_CONF, ConfigDef.Type.STRING, (Object)"PKIX", ConfigDef.Importance.MEDIUM, "The algorithm used by trust manager factory for SSL connections. Default value is the trust manager factory algorithm configured for the Java Virtual Machine.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_LOCATION_CONF, ConfigDef.Type.STRING, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_LOCATION_DEFAULT, ConfigDef.Importance.MEDIUM, "The location of the trust store file.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_PASSWORD_CONF, ConfigDef.Type.PASSWORD, (Object)CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, "The password for the trust store file.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_SSL_TRUSTSTORE_TYPE_CONF, ConfigDef.Type.STRING, (Object)"JKS", ConfigDef.Importance.MEDIUM, "The file format of the trust store file. Default value is JKS.");
        conf.define(CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_CONF, ConfigDef.Type.BOOLEAN, (Object)CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SINK_KAFKA_COMPONENT_USE_GLOBAL_SSL_CONTEXT_PARAMETERS_DOC);
        return conf;
    }
}

