/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector.maven.docs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.camel.kafkaconnector.maven.docs.dto.CamelKafkaConnectorTableModel;
import org.apache.camel.kafkaconnector.maven.docs.dto.CamelKafkaConnectorTableOptionModel;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="update-doc-connectors-list", threadSafe=true)
public class UpdateDocComponentsListMojo
extends AbstractMojo {
    private static final String SINK_CONNECTOR_LINK_SUFFIX_ADOC = "kafka-sink-connector.adoc[Sink Docs]";
    private static final String SOURCE_CONNECTOR_LINK_SUFFIX_ADOC = "kafka-source-connector.adoc[Source Docs]";
    private static final String XREF_CONNECTOR_LINK_PREFIX = "xref:connectors/";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.directory}/../../connectors/")
    protected File connectorsDir;
    @Parameter(defaultValue="${basedir}/../")
    protected File projectBaseDir;
    @Parameter(defaultValue="https://repo.maven.apache.org/maven2/org/apache/camel/kafkaconnector/")
    protected String repositoryPath;
    @Parameter
    protected String lastReleasedVersion;
    @Parameter(property="connectors-project-name", defaultValue="connectors", readonly=true)
    protected String connectorsProjectName;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.project.getArtifactId().equals(this.connectorsProjectName)) {
            this.getLog().debug((CharSequence)("Skipping project " + this.project.getArtifactId() + " since it is not " + this.connectorsProjectName + " can be configured with <connectors-project-name> option."));
            return;
        }
        this.executeComponentsReadme();
    }

    protected void executeComponentsReadme() throws MojoExecutionException, MojoFailureException {
        String changed;
        File docFolderWebsite;
        File docFileWebsite;
        boolean updated;
        File[] files;
        CamelKafkaConnectorTableModel tableModel = new CamelKafkaConnectorTableModel();
        ArrayList<CamelKafkaConnectorTableOptionModel> options = new ArrayList<CamelKafkaConnectorTableOptionModel>();
        if (this.connectorsDir != null && this.connectorsDir.isDirectory() && (files = this.connectorsDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String connectorFinal;
                File file = files[i];
                if (!file.isDirectory()) continue;
                Collection sinkConnector = FileUtils.listFiles((File)file, (IOFileFilter)new RegexFileFilter(".*SinkTask.*"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                Collection sourceConnector = FileUtils.listFiles((File)file, (IOFileFilter)new RegexFileFilter(".*SourceTask.*"), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                if (sinkConnector.size() <= 0 && sourceConnector.size() <= 0) continue;
                CamelKafkaConnectorTableOptionModel singleConnector = new CamelKafkaConnectorTableOptionModel();
                singleConnector.setName(file.getName());
                if (sinkConnector.size() > 0) {
                    singleConnector.setSink(true);
                    connectorFinal = StringUtils.removeEnd((String)file.getName(), (String)"kafka-connector");
                    if (connectorFinal.equalsIgnoreCase("camel-coap-tcp-")) {
                        singleConnector.setDocsSink("xref:connectors/camel-coap+tcp-kafka-sink-connector.adoc[Sink Docs]");
                    } else if (connectorFinal.equalsIgnoreCase("camel-coaps-tcp-")) {
                        singleConnector.setDocsSink("xref:connectors/camel-coaps+tcp-kafka-sink-connector.adoc[Sink Docs]");
                    } else if (connectorFinal.equalsIgnoreCase("camel-solrcloud-")) {
                        singleConnector.setDocsSink("xref:connectors/camel-solrCloud-kafka-sink-connector.adoc[Sink Docs]");
                    } else {
                        singleConnector.setDocsSink(XREF_CONNECTOR_LINK_PREFIX + connectorFinal + SINK_CONNECTOR_LINK_SUFFIX_ADOC);
                    }
                }
                if (sourceConnector.size() > 0) {
                    singleConnector.setSource(true);
                    connectorFinal = StringUtils.removeEnd((String)file.getName(), (String)"kafka-connector");
                    if (connectorFinal.equalsIgnoreCase("camel-coap-tcp-")) {
                        singleConnector.setDocsSource("xref:connectors/camel-coap+tcp-kafka-source-connector.adoc[Source Docs]");
                    } else if (connectorFinal.equalsIgnoreCase("camel-coaps-tcp-")) {
                        singleConnector.setDocsSource("xref:connectors/camel-coaps+tcp-kafka-source-connector.adoc[Source Docs]");
                    } else if (connectorFinal.equalsIgnoreCase("camel-solrcloud-")) {
                        singleConnector.setDocsSource("xref:connectors/camel-solrCloud-kafka-source-connector.adoc[Source Docs]");
                    } else {
                        singleConnector.setDocsSource(XREF_CONNECTOR_LINK_PREFIX + connectorFinal + SOURCE_CONNECTOR_LINK_SUFFIX_ADOC);
                    }
                }
                String downloadLinkZip = this.repositoryPath + singleConnector.getName() + "/" + this.lastReleasedVersion + "/" + singleConnector.getName() + "-" + this.lastReleasedVersion + "-package.zip[Download Zip]";
                String downloadLinkTar = this.repositoryPath + singleConnector.getName() + "/" + this.lastReleasedVersion + "/" + singleConnector.getName() + "-" + this.lastReleasedVersion + "-package.tar.gz[Download Tar.gz]";
                singleConnector.setDownloadLinkZip(downloadLinkZip);
                singleConnector.setDownloadLinkTar(downloadLinkTar);
                options.add(singleConnector);
            }
            options.sort((model1, model2) -> {
                String name2;
                String name1 = model1.getName();
                int res = String.CASE_INSENSITIVE_ORDER.compare(name1, name2 = model2.getName());
                return res != 0 ? res : name1.compareTo(name2);
            });
            tableModel.setOptions(options);
        }
        if (updated = this.updateConnectorsTable(docFileWebsite = new File(docFolderWebsite = new File(this.projectBaseDir, "docs/modules/ROOT/pages/"), "connectors.adoc"), changed = this.templateConnnectorsTable(tableModel))) {
            this.getLog().info((CharSequence)("Updated connectors table file: " + docFileWebsite));
        } else {
            this.getLog().debug((CharSequence)("No changes to connectors table file: " + docFileWebsite));
        }
    }

    private String templateConnnectorsTable(CamelKafkaConnectorTableModel model) throws MojoExecutionException {
        try {
            String template = null;
            template = PackageHelper.loadText((InputStream)UpdateDocComponentsListMojo.class.getClassLoader().getResourceAsStream("connectors.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean updateConnectorsTable(File file, String changed) throws MojoExecutionException {
        try {
            if (!file.exists()) {
                changed = "// kafka-connectors list: START\n" + changed + "\n// kafka-connectors list: END\n";
                PackageHelper.writeText((File)file, (String)changed);
                return true;
            }
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// kafka-connectors list: START", (String)"// kafka-connectors list: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// kafka-connectors list: START");
                String after = Strings.after((String)text, (String)"// kafka-connectors list: END");
                text = before + "// kafka-connectors list: START\n" + changed + "\n// kafka-connectors list: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// kafka-connectors list: START");
            this.getLog().warn((CharSequence)"\t// kafka-connectors list: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }
}

