/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.consumer.errorhandler;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.support.ProcessingResult;
import org.apache.camel.resume.ConsumerListener;
import org.apache.kafka.clients.consumer.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerListener
implements ConsumerListener<Object, ProcessingResult> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsumerListener.class);
    private Consumer<?, ?> consumer;
    private SeekPolicy seekPolicy;
    private Predicate<?> afterConsumeEval;

    public Consumer<?, ?> getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer<?, ?> consumer) {
        this.consumer = consumer;
    }

    public SeekPolicy getSeekPolicy() {
        return this.seekPolicy;
    }

    public void setSeekPolicy(SeekPolicy seekPolicy) {
        this.seekPolicy = seekPolicy;
    }

    public void setResumableCheck(Predicate<?> afterConsumeEval) {
        this.afterConsumeEval = afterConsumeEval;
    }

    public boolean afterConsume(Object ignored) {
        if (this.afterConsumeEval.test(null)) {
            LOG.warn("State changed, therefore resuming the consumer");
            this.consumer.resume((Collection)this.consumer.assignment());
            return true;
        }
        LOG.warn("The consumer is not yet resumable");
        return false;
    }

    public boolean afterProcess(ProcessingResult result) {
        if (result.isFailed()) {
            LOG.warn("Pausing consumer due to error on the last processing");
            this.consumer.pause((Collection)this.consumer.assignment());
            if (this.seekPolicy == SeekPolicy.BEGINNING) {
                LOG.debug("Seeking from the beginning of topic");
                this.consumer.seekToBeginning((Collection)this.consumer.assignment());
            } else if (this.seekPolicy == SeekPolicy.END) {
                LOG.debug("Seeking from the end off the topic");
                this.consumer.seekToEnd((Collection)this.consumer.assignment());
            }
            return false;
        }
        return true;
    }
}

