/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.component.SendDynamicAwareSupport;
import org.apache.camel.util.URISupport;

public abstract class GenericFileSendDynamicAware
extends SendDynamicAwareSupport {
    public static final String PROP_FILE_NAME = "fileName";
    public static final String PROP_TEMP_FILE_NAME = "tempFileName";
    public static final String PROP_IDEMPOTENT_KEY = "idempotentKey";
    public static final String PROP_MOVE = "move";
    public static final String PROP_MOVE_FAILED = "moveFailed";
    public static final String PROP_PRE_MOVE = "preMove";
    public static final String PROP_MOVE_EXISTING = "moveExisting";

    public boolean isLenientProperties() {
        return false;
    }

    public SendDynamicAware.DynamicAwareEntry prepare(Exchange exchange, String uri, String originalUri) throws Exception {
        Map properties = this.endpointProperties(exchange, uri);
        return new SendDynamicAware.DynamicAwareEntry(uri, originalUri, properties, null);
    }

    public String resolveStaticUri(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        String uri = entry.getUri();
        uri = uri.replace("\t", "\\\\t");
        boolean fileName = entry.getProperties().containsKey(PROP_FILE_NAME);
        boolean tempFileName = entry.getProperties().containsKey(PROP_TEMP_FILE_NAME);
        boolean idempotentKey = entry.getProperties().containsKey(PROP_IDEMPOTENT_KEY);
        boolean move = entry.getProperties().containsKey(PROP_MOVE);
        boolean moveFailed = entry.getProperties().containsKey(PROP_MOVE_FAILED);
        boolean preMove = entry.getProperties().containsKey(PROP_PRE_MOVE);
        boolean moveExisting = entry.getProperties().containsKey(PROP_MOVE_EXISTING);
        if (fileName || tempFileName || idempotentKey || move || moveFailed || preMove || moveExisting) {
            Object val;
            Map params = entry.getProperties();
            Map originalParams = URISupport.parseQuery((String)URISupport.extractQuery((String)entry.getOriginalUri()));
            if (fileName && (val = originalParams.get(PROP_FILE_NAME)) != null) {
                params.put(PROP_FILE_NAME, val.toString());
            }
            if (tempFileName && (val = originalParams.get(PROP_TEMP_FILE_NAME)) != null) {
                params.put(PROP_TEMP_FILE_NAME, val.toString());
            }
            if (idempotentKey && (val = originalParams.get(PROP_IDEMPOTENT_KEY)) != null) {
                params.put(PROP_IDEMPOTENT_KEY, val.toString());
            }
            if (move && (val = originalParams.get(PROP_MOVE)) != null) {
                params.put(PROP_MOVE, val.toString());
            }
            if (moveFailed && (val = originalParams.get(PROP_MOVE_FAILED)) != null) {
                params.put(PROP_MOVE_FAILED, val.toString());
            }
            if (preMove && (val = originalParams.get(PROP_PRE_MOVE)) != null) {
                params.put(PROP_PRE_MOVE, val.toString());
            }
            if (moveExisting && (val = originalParams.get(PROP_MOVE_EXISTING)) != null) {
                params.put(PROP_MOVE_EXISTING, val.toString());
            }
            return this.asEndpointUri(exchange, uri, params);
        }
        return uri;
    }

    public Processor createPreProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }

    public Processor createPostProcessor(Exchange exchange, SendDynamicAware.DynamicAwareEntry entry) throws Exception {
        return null;
    }
}

