/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.avro.transform;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.jackson.SchemaType;
import org.apache.camel.component.jackson.avro.transform.Avro;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.component.jackson.transform.JsonPojoDataTypeTransformer;
import org.apache.camel.spi.DataTypeTransformer;

@DataTypeTransformer(name="avro-x-java-object")
public class AvroPojoDataTypeTransformer
extends JsonPojoDataTypeTransformer {
    protected Object getJavaObject(Message message, SchemaType schemaType, FormatSchema schema, Class<?> contentType) throws InvalidPayloadException, IOException {
        String jsonString;
        Object object = message.getBody();
        if (object instanceof String && Json.isJson((String)(jsonString = (String)object))) {
            return super.getJavaObject(message, SchemaType.JSON, schema, contentType);
        }
        if (schemaType == SchemaType.AVRO) {
            if (schema == null) {
                throw new CamelExecutionException("Missing proper Avro schema for Java object data type processing", message.getExchange());
            }
            if (message.getBody() instanceof JsonNode) {
                return Avro.mapper().reader().forType(contentType).with(schema).readValue((JsonNode)message.getBody(JsonNode.class));
            }
            return Avro.mapper().reader().forType(contentType).with(schema).readValue(this.getBodyAsStream(message));
        }
        return super.getJavaObject(message, schemaType, schema, contentType);
    }
}

