/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.IFSDeleteAction;
import com.ibm.as400.vaccess.IFSDirectoryCreateAction;
import com.ibm.as400.vaccess.IFSDirectoryFilter;
import com.ibm.as400.vaccess.IFSDirectoryPropertiesPane;
import com.ibm.as400.vaccess.IFSFileCreateAction;
import com.ibm.as400.vaccess.IFSRenameAction;
import com.ibm.as400.vaccess.PermissionAction;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.ResourceLoader;
import com.ibm.as400.vaccess.VAction;
import com.ibm.as400.vaccess.VEnumeration;
import com.ibm.as400.vaccess.VIFSConstants;
import com.ibm.as400.vaccess.VIFSFile;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectCellEditor;
import com.ibm.as400.vaccess.VObjectCellRenderer;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectEventSupport;
import com.ibm.as400.vaccess.VObjectHeaderRenderer;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VPropertiesPane;
import com.ibm.as400.vaccess.VTableColumn;
import com.ibm.as400.vaccess.VUtilities;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;

public class VIFSDirectory
implements VNode,
VIFSConstants,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    public static final int INCLUDE_FILES = 0;
    public static final int INCLUDE_DIRECTORIES = 1;
    public static final int INCLUDE_BOTH = 2;
    private static String attributesColumnHeader_ = ResourceLoader.getText("COLUMN_ATTRIBUTES");
    private static String description_ = ResourceLoader.getText("IFS_DIRECTORY_DESCRIPTION");
    private static Icon closedIcon16_ = ResourceLoader.getIcon("VIFSDirectory16.gif", description_);
    private static Icon closedIcon32_ = ResourceLoader.getIcon("VIFSDirectory32.gif", description_);
    private static String modifiedColumnHeader_ = ResourceLoader.getText("COLUMN_MODIFIED");
    private static String nameColumnHeader_ = ResourceLoader.getText("COLUMN_NAME");
    private static Icon openIcon16_ = ResourceLoader.getIcon("VIFSDirectoryOpen16.gif", description_);
    private static Icon openIcon32_ = ResourceLoader.getIcon("VIFSDirectoryOpen32.gif", description_);
    private static String sizeColumnHeader_ = ResourceLoader.getText("COLUMN_SIZE");
    private IFSDirectoryFilter actualFilter_ = new IFSDirectoryFilter(2, null);
    private IFSFile directory_ = null;
    private VNode parent_ = null;
    private String pattern_ = "*";
    private static TableColumnModel detailsColumnModel_ = null;
    private transient VAction[] actions_;
    private transient boolean actionsInitialized_;
    transient VNode[] children_;
    private transient boolean childrenLoaded_;
    transient boolean deleted_;
    transient Object detailsChildrenLock_ = new Object();
    transient VObject[] detailsChildren_;
    private transient Date modified_;
    private transient VPropertiesPane propertiesPane_;
    transient ErrorEventSupport errorEventSupport_;
    transient VObjectEventSupport objectEventSupport_;
    transient VObjectListener_ objectListener_;
    transient PropertyChangeSupport propertyChangeSupport_;
    transient VetoableChangeSupport vetoableChangeSupport_;
    transient WorkingEventSupport workingEventSupport_;

    public VIFSDirectory() {
        this.directory_ = new IFSFile();
        this.initializeTransient();
    }

    public VIFSDirectory(IFSFile iFSFile) {
        if (iFSFile == null) {
            throw new NullPointerException("directory");
        }
        this.directory_ = iFSFile;
        this.initializeTransient();
    }

    public VIFSDirectory(VNode vNode, IFSFile iFSFile) {
        if (vNode == null) {
            throw new NullPointerException("parent");
        }
        if (iFSFile == null) {
            throw new NullPointerException("directory");
        }
        this.parent_ = vNode;
        this.directory_ = iFSFile;
        this.initializeTransient();
    }

    public VIFSDirectory(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.directory_ = new IFSFile(aS400, string);
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.addVObjectListener(vObjectListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public synchronized Enumeration children() {
        return new VEnumeration(this);
    }

    public VAction[] getActions() {
        this.initializeCreationActions();
        return this.actions_;
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public TreeNode getChildAt(int n) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        if (n < 0 || n >= this.children_.length) {
            return null;
        }
        return this.children_[n];
    }

    public int getChildCount() {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        return this.children_.length;
    }

    public VAction getDefaultAction() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VObject getDetailsChildAt(int n) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        Object object = this.detailsChildrenLock_;
        synchronized (object) {
            if (n < 0 || n >= this.detailsChildren_.length) {
                return null;
            }
            return this.detailsChildren_[n];
        }
    }

    public int getDetailsChildCount() {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        return this.detailsChildren_.length;
    }

    public TableColumnModel getDetailsColumnModel() {
        return detailsColumnModel_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDetailsIndex(VObject vObject) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        Object object = this.detailsChildrenLock_;
        synchronized (object) {
            for (int i = 0; i < this.detailsChildren_.length; ++i) {
                if (this.detailsChildren_[i] != vObject) continue;
                return i;
            }
        }
        return -1;
    }

    int getDirectoryCount() {
        return this.getChildCount();
    }

    int getFileCount() {
        return this.getDetailsChildCount() - this.getChildCount();
    }

    public IFSFileFilter getFilter() {
        return this.actualFilter_.getOtherFilter();
    }

    public Icon getIcon(int n, boolean bl) {
        if (n == 32) {
            if (bl) {
                return openIcon32_;
            }
            return closedIcon32_;
        }
        if (bl) {
            return openIcon16_;
        }
        return closedIcon16_;
    }

    public int getInclude() {
        return this.actualFilter_.getInclude();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndex(TreeNode treeNode) {
        if (!this.childrenLoaded_) {
            this.loadChildren();
        }
        VNode[] vNodeArray = this.children_;
        synchronized (this.children_) {
            for (int i = 0; i < this.children_.length; ++i) {
                if (this.children_[i] != treeNode) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    Date getModified() {
        return this.modified_;
    }

    public String getName() {
        return this.directory_.getName();
    }

    public TreeNode getParent() {
        return this.parent_;
    }

    public String getParentDirectory() {
        return this.directory_.getParent();
    }

    public String getPattern() {
        return this.pattern_;
    }

    public String getPath() {
        return this.directory_.getPath();
    }

    public VPropertiesPane getPropertiesPane() {
        return this.propertiesPane_;
    }

    public Object getPropertyValue(Object object) {
        if (object == VObject.NAME_PROPERTY) {
            return this;
        }
        if (object == VObject.DESCRIPTION_PROPERTY) {
            return description_;
        }
        if (object == VIFSConstants.SIZE_PROPERTY) {
            return "";
        }
        if (object == VIFSConstants.MODIFIED_PROPERTY) {
            return this.modified_;
        }
        if (object == VIFSConstants.ATTRIBUTES_PROPERTY) {
            return "";
        }
        return null;
    }

    public AS400 getSystem() {
        return this.directory_.getSystem();
    }

    public String getText() {
        String string = this.directory_.getName();
        if (string.length() == 0) {
            string = "/";
        }
        return string;
    }

    private void initializeCreationActions() {
        if (this.actionsInitialized_) {
            return;
        }
        String string = this.directory_.getPath().toUpperCase();
        if (string.startsWith("/QSYS.LIB/") || string.startsWith("/QDLS/")) {
            for (int i = 0; i < 2; ++i) {
                this.actions_[i].setEnabled(false);
            }
        }
        this.actionsInitialized_ = true;
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.objectEventSupport_ = new VObjectEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        this.directory_.addPropertyChangeListener(this.propertyChangeSupport_);
        this.directory_.addVetoableChangeListener(this.vetoableChangeSupport_);
        this.actions_ = new VAction[5];
        this.actions_[0] = new IFSFileCreateAction(this, this.directory_);
        this.actions_[1] = new IFSDirectoryCreateAction(this, this.directory_);
        this.actions_[2] = new IFSRenameAction(this, this.directory_);
        this.actions_[3] = new IFSDeleteAction(this, this.directory_);
        this.actions_[4] = new PermissionAction(this.directory_);
        this.actionsInitialized_ = false;
        for (int i = 0; i < this.actions_.length; ++i) {
            this.actions_[i].addErrorListener(this.errorEventSupport_);
            this.actions_[i].addVObjectListener(this.objectListener_);
            this.actions_[i].addWorkingListener(this.workingEventSupport_);
        }
        this.propertiesPane_ = new IFSDirectoryPropertiesPane(this);
        this.propertiesPane_.addErrorListener(this.errorEventSupport_);
        this.propertiesPane_.addVObjectListener(this.objectListener_);
        this.propertiesPane_.addWorkingListener(this.workingEventSupport_);
        this.children_ = new VNode[0];
        this.detailsChildren_ = new VObject[0];
        this.modified_ = new Date();
        this.childrenLoaded_ = true;
        this.deleted_ = false;
    }

    public boolean isLeaf() {
        if (this.childrenLoaded_) {
            return this.getChildCount() == 0;
        }
        return false;
    }

    public boolean isSortable() {
        return true;
    }

    public void load() {
        this.workingEventSupport_.fireStartWorking();
        this.initializeCreationActions();
        try {
            this.modified_ = new Date(this.directory_.lastModified());
        }
        catch (Exception exception) {
            this.modified_ = new Date(0L);
            this.errorEventSupport_.fireError(exception);
        }
        this.childrenLoaded_ = false;
        this.workingEventSupport_.fireStopWorking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadChildren() {
        block19: {
            this.workingEventSupport_.fireStartWorking();
            try {
                Object object;
                Hashtable<String, VObject> hashtable = new Hashtable<String, VObject>();
                for (int i = 0; i < this.detailsChildren_.length; ++i) {
                    hashtable.put(this.detailsChildren_[i].getText(), this.detailsChildren_[i]);
                }
                if (Trace.isTraceOn()) {
                    Trace.log(3, "Loading IFS file list [" + this.directory_.getName() + "].");
                }
                Vector<VObject> vector = null;
                Enumeration enumeration = this.detailsChildrenLock_;
                synchronized (enumeration) {
                    if (this.directory_.getPath().length() > 0) {
                        object = this.directory_.listFiles(this.actualFilter_, this.pattern_);
                        if (object == null) {
                            Trace.log(1, "File list returned as null");
                            if (this.directory_.exists()) {
                                object = new IFSFile[]{};
                            } else {
                                throw new IOException(ResourceLoader.getText("EXC_FILE_NOT_FOUND"));
                            }
                        }
                        int n = ((IFSFile[])object).length;
                        this.detailsChildren_ = new VObject[n];
                        vector = new Vector<VObject>(n);
                        for (int i = 0; i < n; ++i) {
                            VObject vObject = null;
                            if (hashtable.containsKey(((IFSFile)object[i]).getName())) {
                                vObject = (VObject)hashtable.remove(((IFSFile)object[i]).getName());
                            } else {
                                Object object2 = object[i];
                                vObject = ((IFSFile)object2).isDirectory() ? new VIFSDirectory(this, (IFSFile)object2) : new VIFSFile((IFSFile)object2);
                                vObject.addErrorListener(this.errorEventSupport_);
                                vObject.addVObjectListener(this.objectEventSupport_);
                                vObject.addVObjectListener(this.objectListener_);
                                vObject.addWorkingListener(this.workingEventSupport_);
                            }
                            vObject.load();
                            this.detailsChildren_[i] = vObject;
                            if (!(vObject instanceof VIFSDirectory) || vector.contains(vObject)) continue;
                            vector.addElement(vObject);
                        }
                    }
                }
                if (vector != null) {
                    enumeration = this;
                    synchronized (enumeration) {
                        this.children_ = new VNode[vector.size()];
                        vector.copyInto(this.children_);
                    }
                }
                enumeration = hashtable.elements();
                while (enumeration.hasMoreElements()) {
                    object = (VObject)enumeration.nextElement();
                    object.removeErrorListener(this.errorEventSupport_);
                    object.removeVObjectListener(this.objectEventSupport_);
                    object.removeVObjectListener(this.objectListener_);
                    object.removeWorkingListener(this.workingEventSupport_);
                }
                this.childrenLoaded_ = true;
            }
            catch (Exception exception) {
                this.children_ = new VNode[0];
                this.detailsChildren_ = new VObject[0];
                this.childrenLoaded_ = true;
                if (this.deleted_) break block19;
                this.errorEventSupport_.fireError(exception);
            }
        }
        this.workingEventSupport_.fireStopWorking();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVObjectListener(VObjectListener vObjectListener) {
        this.objectEventSupport_.removeVObjectListener(vObjectListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setFilter(IFSFileFilter iFSFileFilter) throws PropertyVetoException {
        if (iFSFileFilter == null) {
            throw new NullPointerException("filter");
        }
        IFSFileFilter iFSFileFilter2 = this.actualFilter_.getOtherFilter();
        IFSFileFilter iFSFileFilter3 = iFSFileFilter;
        this.vetoableChangeSupport_.fireVetoableChange("filter", iFSFileFilter2, iFSFileFilter3);
        if (iFSFileFilter2 != iFSFileFilter3) {
            this.actualFilter_.setOtherFilter(iFSFileFilter3);
        }
        this.propertyChangeSupport_.firePropertyChange("filter", iFSFileFilter2, iFSFileFilter3);
    }

    public void setInclude(int n) throws PropertyVetoException {
        Integer n2 = new Integer(this.actualFilter_.getInclude());
        Integer n3 = new Integer(n);
        this.vetoableChangeSupport_.fireVetoableChange("includeFiles", n2, n3);
        if (!n2.equals(n3)) {
            this.actualFilter_.setInclude(n);
        }
        this.propertyChangeSupport_.firePropertyChange("includeFiles", n2, n3);
    }

    public void setPath(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("path");
        }
        this.directory_.setPath(string);
    }

    public void setPattern(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        String string2 = this.pattern_;
        String string3 = string;
        this.vetoableChangeSupport_.fireVetoableChange("pattern", string2, string3);
        if (!string2.equals(string3)) {
            this.pattern_ = string3;
        }
        this.propertyChangeSupport_.firePropertyChange("pattern", string2, string3);
    }

    public void setSystem(AS400 aS400) throws PropertyVetoException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.directory_.setSystem(aS400);
    }

    public synchronized void sortDetailsChildren(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
        VUtilities.sort(this.detailsChildren_, objectArray, blArray);
    }

    public String toString() {
        return this.directory_.getName();
    }

    static {
        detailsColumnModel_ = new DefaultTableColumnModel();
        int n = 0;
        VTableColumn vTableColumn = new VTableColumn(n++, VObject.NAME_PROPERTY);
        vTableColumn.setCellEditor(new VObjectCellEditor());
        vTableColumn.setCellRenderer(new VObjectCellRenderer());
        vTableColumn.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn.setHeaderValue(nameColumnHeader_);
        vTableColumn.setPreferredCharWidth(25);
        detailsColumnModel_.addColumn(vTableColumn);
        VTableColumn vTableColumn2 = new VTableColumn(n++, VIFSConstants.SIZE_PROPERTY);
        vTableColumn2.setCellRenderer(new VObjectCellRenderer(4));
        vTableColumn2.setHeaderRenderer(new VObjectHeaderRenderer(4));
        vTableColumn2.setHeaderValue(sizeColumnHeader_);
        vTableColumn2.setPreferredCharWidth(8);
        detailsColumnModel_.addColumn(vTableColumn2);
        VTableColumn vTableColumn3 = new VTableColumn(n++, VIFSConstants.MODIFIED_PROPERTY);
        vTableColumn3.setCellRenderer(new VObjectCellRenderer());
        vTableColumn3.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn3.setHeaderValue(modifiedColumnHeader_);
        vTableColumn3.setPreferredCharWidth(20);
        detailsColumnModel_.addColumn(vTableColumn3);
        VTableColumn vTableColumn4 = new VTableColumn(n++, VIFSConstants.ATTRIBUTES_PROPERTY);
        vTableColumn4.setCellRenderer(new VObjectCellRenderer());
        vTableColumn4.setHeaderRenderer(new VObjectHeaderRenderer());
        vTableColumn4.setHeaderValue(attributesColumnHeader_);
        vTableColumn4.setPreferredCharWidth(10);
        detailsColumnModel_.addColumn(vTableColumn4);
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent vObjectEvent) {
            VIFSDirectory.this.objectEventSupport_.objectChanged(vObjectEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void objectCreated(VObjectEvent vObjectEvent) {
            VObject vObject = vObjectEvent.getObject();
            VNode vNode = vObjectEvent.getParent();
            if (vNode == VIFSDirectory.this) {
                VNode[] vNodeArray = VIFSDirectory.this.detailsChildrenLock_;
                // MONITORENTER : VIFSDirectory.this.detailsChildrenLock_
                VObject[] vObjectArray = VIFSDirectory.this.detailsChildren_;
                int n = VIFSDirectory.this.detailsChildren_.length;
                VIFSDirectory.this.detailsChildren_ = new VObject[n + 1];
                System.arraycopy(vObjectArray, 0, VIFSDirectory.this.detailsChildren_, 0, n);
                VIFSDirectory.this.detailsChildren_[n] = vObject;
                // MONITOREXIT : vNodeArray
                if (vObject instanceof VIFSDirectory) {
                    vNodeArray = VIFSDirectory.this.children_;
                    // MONITORENTER : VIFSDirectory.this.children_
                    vObjectArray = VIFSDirectory.this.children_;
                    n = VIFSDirectory.this.children_.length;
                    VIFSDirectory.this.children_ = new VNode[n + 1];
                    System.arraycopy(vObjectArray, 0, VIFSDirectory.this.children_, 0, n);
                    VIFSDirectory.this.children_[n] = (VIFSDirectory)vObject;
                    // MONITOREXIT : vNodeArray
                }
            }
            vObject.addErrorListener(VIFSDirectory.this.errorEventSupport_);
            vObject.addVObjectListener(VIFSDirectory.this.objectListener_);
            vObject.addVObjectListener(VIFSDirectory.this.objectEventSupport_);
            vObject.addWorkingListener(VIFSDirectory.this.workingEventSupport_);
            VIFSDirectory.this.objectEventSupport_.objectCreated(vObjectEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void objectDeleted(VObjectEvent vObjectEvent) {
            int n;
            VObject[] vObjectArray;
            VNode[] vNodeArray;
            VObject vObject = vObjectEvent.getObject();
            if (vObject == VIFSDirectory.this) {
                VIFSDirectory.this.deleted_ = true;
                VIFSDirectory.this.objectEventSupport_.objectDeleted(vObjectEvent);
                return;
            }
            int n2 = VIFSDirectory.this.getDetailsIndex(vObject);
            if (n2 >= 0) {
                vNodeArray = VIFSDirectory.this.detailsChildrenLock_;
                // MONITORENTER : VIFSDirectory.this.detailsChildrenLock_
                vObjectArray = VIFSDirectory.this.detailsChildren_;
                n = VIFSDirectory.this.detailsChildren_.length;
                VIFSDirectory.this.detailsChildren_ = new VObject[n - 1];
                System.arraycopy(vObjectArray, 0, VIFSDirectory.this.detailsChildren_, 0, n2);
                System.arraycopy(vObjectArray, n2 + 1, VIFSDirectory.this.detailsChildren_, n2, n - n2 - 1);
                // MONITOREXIT : vNodeArray
            }
            if (vObject instanceof VIFSDirectory && (n2 = VIFSDirectory.this.getIndex((VIFSDirectory)vObject)) >= 0) {
                vNodeArray = VIFSDirectory.this.children_;
                // MONITORENTER : VIFSDirectory.this.children_
                vObjectArray = VIFSDirectory.this.children_;
                n = VIFSDirectory.this.children_.length;
                VIFSDirectory.this.children_ = new VNode[n - 1];
                System.arraycopy(vObjectArray, 0, VIFSDirectory.this.children_, 0, n2);
                System.arraycopy(vObjectArray, n2 + 1, VIFSDirectory.this.children_, 0, n - n2 - 1);
                // MONITOREXIT : vNodeArray
            }
            vObject.removeErrorListener(VIFSDirectory.this.errorEventSupport_);
            vObject.removeVObjectListener(VIFSDirectory.this.objectEventSupport_);
            vObject.removeVObjectListener(VIFSDirectory.this.objectListener_);
            vObject.removeWorkingListener(VIFSDirectory.this.workingEventSupport_);
        }
    }
}

