/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDSQLTokenizer;
import com.ibm.as400.access.JDUtilities;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;

class JDEscapeClause {
    private static final String CALL_ = "CALL";
    private static final String CALL1_ = "?=";
    private static final String CALL2_ = "?=CALL";
    private static final String CALL3_ = "?";
    private static final String DATE_ = "D";
    private static final String ESCAPE_ = "ESCAPE";
    private static final String FN_ = "FN";
    private static final String OJ_ = "OJ";
    private static final String TIME_ = "T";
    private static final String TIMESTAMP_ = "TS";
    private static JDScalarTable scalarFunctionTable_ = new JDScalarTable();

    JDEscapeClause() {
    }

    static String parse(String string, String string2, int n) throws SQLException {
        JDSQLTokenizer jDSQLTokenizer = new JDSQLTokenizer(string, "{}'\"");
        return JDEscapeClause.parse(jDSQLTokenizer, string2, true, n);
    }

    private static String parse(JDSQLTokenizer jDSQLTokenizer, String string, boolean bl, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c = ' ';
        while (jDSQLTokenizer.hasMoreTokens()) {
            String string2 = jDSQLTokenizer.nextToken();
            if (string2.equals("{")) {
                if (bl2) {
                    stringBuffer.append(string2);
                    continue;
                }
                stringBuffer.append(JDEscapeClause.parse(jDSQLTokenizer, string, false, n));
                continue;
            }
            if (string2.equals("}")) {
                if (bl2) {
                    stringBuffer.append(string2);
                    continue;
                }
                if (bl) {
                    JDError.throwSQLException("42601");
                    continue;
                }
                return JDEscapeClause.convert(stringBuffer.toString(), string, n);
            }
            if (string2.equals("'") || string2.equals("\"")) {
                if (bl2) {
                    if (c == string2.charAt(0)) {
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                    c = string2.charAt(0);
                }
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append(string2);
        }
        if (!bl) {
            JDError.throwSQLException("42601");
        }
        return stringBuffer.toString();
    }

    private static String convert(String string, String string2, int n) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = string.trim();
        int n2 = string3.indexOf(32);
        String string4 = null;
        String string5 = null;
        if (n2 == -1) {
            string4 = string3;
            string5 = "";
        } else {
            string4 = string3.substring(0, n2);
            string5 = string3.substring(n2 + 1);
        }
        if (string4.equalsIgnoreCase(CALL_) || string4.equalsIgnoreCase(CALL1_) || string4.equalsIgnoreCase(CALL2_) || string4.equalsIgnoreCase(CALL3_)) {
            stringBuffer.append(string4);
            stringBuffer.append(' ');
            stringBuffer.append(string5);
        } else if (string4.equalsIgnoreCase(DATE_)) {
            stringBuffer.append(string5);
        } else if (string4.equalsIgnoreCase(TIME_)) {
            stringBuffer.append(string5);
        } else if (string4.equalsIgnoreCase(TIMESTAMP_)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string5);
            if (stringTokenizer.countTokens() != 2) {
                JDError.throwSQLException("42601");
            }
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append('-');
            stringBuffer.append(stringTokenizer.nextToken().replace(':', '.'));
        } else if (string4.equalsIgnoreCase(FN_)) {
            stringBuffer.append(JDEscapeClause.convertScalarFunctionCall(string5, string2, n));
        } else if (string4.equalsIgnoreCase(ESCAPE_)) {
            if (string5.trim().length() == 0) {
                JDError.throwSQLException("42601");
            }
            stringBuffer.append(string4);
            stringBuffer.append(' ');
            stringBuffer.append(string5);
        } else if (string4.equalsIgnoreCase(OJ_)) {
            stringBuffer.append(string5);
        }
        if (stringBuffer.length() == 0) {
            JDError.throwSQLException("42601");
        }
        return stringBuffer.toString();
    }

    private static String convertScalarFunctionCall(String string, String string2, int n) throws SQLException {
        int n2;
        CharSequence charSequence;
        Object object;
        int n3 = string.indexOf(40);
        int n4 = string.lastIndexOf(41);
        String string3 = null;
        String string4 = null;
        if (n3 < n4 && n3 != -1 && n4 != -1) {
            string3 = string.substring(0, n3).trim().toLowerCase();
            string4 = string.substring(n3 + 1, n4).trim();
        } else {
            JDError.throwSQLException("42601");
        }
        if (!scalarFunctionTable_.contains(string3, n)) {
            return string;
        }
        if (n4 != -1 && n4 + 1 < string.length() && string.substring(n4 + 1).trim().length() > 0) {
            JDError.throwSQLException("42601");
        }
        Vector<String> vector = new Vector<String>();
        if (string4.length() > 0) {
            object = new StringTokenizer(string4, "(),", true);
            charSequence = new StringBuffer();
            n2 = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string5 = ((StringTokenizer)object).nextToken();
                if (string5.equals("(")) {
                    ++n2;
                    ((StringBuffer)charSequence).append("(");
                    continue;
                }
                if (string5.equals(")")) {
                    --n2;
                    ((StringBuffer)charSequence).append(")");
                    if (((StringTokenizer)object).hasMoreTokens()) continue;
                    vector.add(((StringBuffer)charSequence).toString());
                    continue;
                }
                if (string5.equals(",")) {
                    if (n2 == 0) {
                        vector.add(((StringBuffer)charSequence).toString());
                        charSequence = new StringBuffer();
                        continue;
                    }
                    ((StringBuffer)charSequence).append(",");
                    continue;
                }
                ((StringBuffer)charSequence).append(string5);
                if (((StringTokenizer)object).hasMoreTokens()) continue;
                vector.add(((StringBuffer)charSequence).toString());
            }
        }
        object = new StringBuffer();
        charSequence = scalarFunctionTable_.get(string3, n).toString();
        n2 = 0;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            if ((n5 = ((String)charSequence).indexOf(37, n2)) == -1 || n5 == ((String)charSequence).length() - 1) break;
            ((StringBuffer)object).append(((String)charSequence).substring(n2, n5));
            char c = ((String)charSequence).charAt(n5 + 1);
            if (Character.isDigit(c)) {
                int n7 = Character.digit(c, 10);
                if (n7 > vector.size()) {
                    JDError.throwSQLException("42601");
                }
                if (n7 > n6) {
                    n6 = n7;
                }
                ((StringBuffer)object).append(vector.elementAt(n7 - 1));
            } else if (c == 'd') {
                ((StringBuffer)object).append(string2);
            }
            n2 = n5 + 2;
        }
        ((StringBuffer)object).append(((String)charSequence).substring(n2));
        if (n6 != vector.size()) {
            JDError.throwSQLException("42601");
        }
        return ((StringBuffer)object).toString();
    }

    static String getNumericFunctions(int n) {
        if (n >= JDUtilities.vrm610) {
            return "abs,acos,asin,atan,atan2,ceiling,character_length,cos,cot,degrees,exp,floor,log,log10,mod,octet_length,pi,power,position,radians,rand,round,sign,sin,sqrt,tan,truncate";
        }
        if (n < JDUtilities.vrm510) {
            return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,round,sin,sign,sqrt,tan,truncate";
        }
        return "abs,acos,asin,atan,atan2,ceiling,cos,cot,degrees,exp,floor,log,log10,mod,pi,power,radians,rand,round,sin,sign,sqrt,tan,truncate";
    }

    static String getStringFunctions(int n) {
        if (n >= JDUtilities.vrm610) {
            return "ascii,char,char_length,character_length,concat,difference,insert,lcase,left,length,locate,ltrim,octet_length,position,repeat,replace,right,rtrim,soundex,space,substring,ucase";
        }
        if (n < JDUtilities.vrm510) {
            return "concat,insert,left,length,locate,ltrim,right,rtrim,substring,ucase";
        }
        if (n < JDUtilities.vrm520) {
            return "concat,difference,insert,left,length,locate,ltrim,right,rtrim,soundex,space,substring,ucase";
        }
        if (n < JDUtilities.vrm530) {
            return "char,concat,difference,insert,lcase,left,length,locate,ltrim,right,rtrim,soundex,space,substring,ucase";
        }
        return "ascii,char,concat,difference,insert,lcase,left,length,locate,ltrim,repeat,replace,right,rtrim,soundex,space,substring,ucase";
    }

    static String getSystemFunctions(int n) {
        return "database,ifnull,user";
    }

    static String getTimeDateFunctions(int n) {
        if (n >= JDUtilities.vrm610) {
            return "current_date,current_time,current_timestamp,curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,extract,hour,minute,month,monthname,now,quarter,second,timestampdiff,week,year";
        }
        if (n < JDUtilities.vrm510) {
            return "curdate,curtime,dayofmonth,dayofweek,dayofyear,hour,minute,month,now,quarter,second,week,year";
        }
        if (n < JDUtilities.vrm530) {
            return "curdate,curtime,dayofmonth,dayofweek,dayofyear,hour,minute,month,now,quarter,second,timestampdiff,week,year";
        }
        return "curdate,curtime,dayname,dayofmonth,dayofweek,dayofyear,hour,minute,month,monthname,now,quarter,second,timestampdiff,week,year";
    }

    static boolean supportsConvert() {
        return false;
    }

    static boolean supportsConvert(int n, int n2) {
        return false;
    }

    static {
        scalarFunctionTable_.put("pi", "3%d1415926E00", JDUtilities.vrm510);
        scalarFunctionTable_.put("log", "LN(%1)", 0);
        scalarFunctionTable_.put("length", "LENGTH(STRIP(%1,T))", 0);
        scalarFunctionTable_.put("database", "CURRENT SERVER", JDUtilities.vrm530);
        scalarFunctionTable_.put("user", "USER", 0);
        scalarFunctionTable_.put("jtopeninfo", "'Open Source Software, JTOpen 10.5 codebase 5770-SS1 V7R4M0.00 built=20201031 @ACA'", 0);
    }

    private static final class JDScalarTable {
        public static final int NOT_SUPPORTED = 0;
        private static final int HASH = 10;
        private String[][] keys = new String[10][];
        private String[][] data = new String[10][];
        private int[][] vrms = new int[10][];

        private JDScalarTable() {
        }

        final boolean contains(String string, int n) {
            if (string == null) {
                throw new NullPointerException("key");
            }
            int n2 = (string.hashCode() < 0 ? string.hashCode() * -1 : string.hashCode()) % 10;
            String[] stringArray = this.keys[n2];
            int[] nArray = this.vrms[n2];
            if (stringArray == null) {
                return false;
            }
            if (nArray == null) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || !stringArray[i].equals(string) || nArray[i] <= n && nArray[i] != 0) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final String get(String string, int n) {
            if (string == null) {
                throw new NullPointerException("key");
            }
            int n2 = (string.hashCode() < 0 ? string.hashCode() * -1 : string.hashCode()) % 10;
            String[][] stringArray = this.keys;
            synchronized (this.keys) {
                String[] stringArray2 = this.keys[n2];
                int[] nArray = this.vrms[n2];
                if (stringArray2 == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                if (nArray == null) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (stringArray2[i] == null || !stringArray2[i].equals(string) || nArray[i] <= n && nArray[i] != 0) continue;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.data[n2][i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void put(String string, String string2, int n) {
            if (string == null) {
                throw new NullPointerException("key");
            }
            if (n < 0) {
                throw new IllegalArgumentException("vrm");
            }
            int n2 = (string.hashCode() < 0 ? string.hashCode() * -1 : string.hashCode()) % 10;
            String[][] stringArray = this.keys;
            synchronized (this.keys) {
                String[] stringArray2 = this.data[n2];
                String[] stringArray3 = this.keys[n2];
                int[] nArray = this.vrms[n2];
                if (stringArray3 == null) {
                    stringArray3 = new String[]{string};
                    stringArray2 = new String[]{string2};
                    nArray = new int[]{n};
                    this.keys[n2] = stringArray3;
                    this.data[n2] = stringArray2;
                    this.vrms[n2] = nArray;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                int n3 = stringArray3.length;
                for (int i = 0; i < n3; ++i) {
                    if (stringArray3[i] != null && stringArray3[i].equals(string)) {
                        stringArray2[i] = string2;
                        nArray[i] = n;
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                    if (stringArray3[i] != null) continue;
                    stringArray3[i] = string;
                    stringArray2[i] = string2;
                    nArray[i] = n;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                String[] stringArray4 = new String[n3 * 2];
                System.arraycopy(stringArray3, 0, stringArray4, 0, n3);
                String[] stringArray5 = new String[n3 * 2];
                System.arraycopy(stringArray2, 0, stringArray5, 0, n3);
                int[] nArray2 = new int[n3 * 2];
                System.arraycopy(nArray, 0, nArray2, 0, n3);
                stringArray4[n3] = string;
                stringArray5[n3] = string2;
                nArray2[n3] = n;
                this.keys[n2] = stringArray4;
                this.data[n2] = stringArray5;
                this.vrms[n2] = nArray2;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }
}

