/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.IFSFileFilter;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class IFSJavaFile
extends File
implements Serializable {
    static final long serialVersionUID = 4L;
    private IFSFile ifsFile_ = new IFSFile();
    private static final char AS400_SEPARATOR = '/';
    private static final String URL_PROTOCOL = "file";
    private static final boolean replace_ = '/' != File.separatorChar;
    private boolean absolute_;

    public IFSJavaFile() {
        this(File.separator);
        this.absolute_ = false;
    }

    private IFSJavaFile(String string) {
        super(string);
        try {
            this.ifsFile_.setPath(replace_ ? string.replace(File.separatorChar, '/') : string);
            this.absolute_ = IFSJavaFile.isAbsolutePath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private IFSJavaFile(String string, String string2) {
        super(string, string2);
        try {
            String string3 = this.canonicalizeDirectory(string) + string2;
            this.ifsFile_.setPath(replace_ ? string3.replace(File.separatorChar, '/') : string3);
            this.absolute_ = IFSJavaFile.isAbsolutePath(string3);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public IFSJavaFile(AS400 aS400, String string) {
        this(string);
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
        this.absolute_ = IFSJavaFile.isAbsolutePath(string);
    }

    public IFSJavaFile(AS400 aS400, String string, String string2) {
        this(string, string2);
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
        this.absolute_ = IFSJavaFile.isAbsolutePath(string);
    }

    public IFSJavaFile(IFSJavaFile iFSJavaFile, String string) {
        this();
        Object object;
        if (iFSJavaFile == null) {
            throw new NullPointerException("directory");
        }
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = iFSJavaFile.getPath();
        try {
            object = this.canonicalizeDirectory(string2) + string;
            this.ifsFile_.setPath((String)(replace_ ? ((String)object).replace(File.separatorChar, '/') : object));
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        object = iFSJavaFile.getSystem();
        if (object != null) {
            this.setSystem((AS400)object);
        }
        this.absolute_ = iFSJavaFile.isAbsolute();
    }

    public IFSJavaFile(AS400 aS400, IFSJavaFile iFSJavaFile, String string) {
        this(iFSJavaFile, string);
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.setSystem(aS400);
        this.absolute_ = iFSJavaFile.isAbsolute();
    }

    public IFSJavaFile(IFSFile iFSFile) {
        super(iFSFile.getPath(), iFSFile.getName());
        this.ifsFile_ = iFSFile;
        this.absolute_ = true;
    }

    private String canonicalizeDirectory(String string) {
        int n = string.length() - File.separator.length();
        if (!string.substring(n).equals(File.separator)) {
            string = string + File.separator;
        }
        return string;
    }

    public boolean canExecute() throws SecurityException {
        try {
            return this.ifsFile_.canExecute();
        }
        catch (IOException iOException) {
            Trace.log(2, iOException);
            SecurityException securityException = new SecurityException(iOException.getMessage());
            try {
                securityException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
    }

    public boolean canRead() throws SecurityException {
        try {
            return this.ifsFile_.canRead();
        }
        catch (IOException iOException) {
            Trace.log(2, iOException);
            SecurityException securityException = new SecurityException(iOException.getMessage());
            try {
                securityException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
    }

    public boolean canWrite() throws SecurityException {
        try {
            return this.ifsFile_.canWrite();
        }
        catch (IOException iOException) {
            Trace.log(2, iOException);
            SecurityException securityException = new SecurityException(iOException.getMessage());
            try {
                securityException.initCause(iOException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
    }

    public int compareTo(IFSJavaFile iFSJavaFile) {
        return this.getPath().compareTo(iFSJavaFile.getPath());
    }

    public int compareTo(File file) {
        return this.getPath().compareTo(file.getPath());
    }

    public int compareTo(IFSFile iFSFile) {
        return this.getPath().compareTo(iFSFile.getPath());
    }

    public boolean createNewFile() throws IOException {
        return this.ifsFile_.createNewFile();
    }

    public boolean delete() throws SecurityException {
        try {
            int n = this.ifsFile_.delete0();
            if (n == 5 || n == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(n)));
            }
            return n == 0;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IFSJavaFile)) {
            return false;
        }
        IFSFile iFSFile = ((IFSJavaFile)object).getIfsFile();
        return this.ifsFile_.equals(iFSFile);
    }

    public boolean exists() throws SecurityException {
        int n = 2;
        try {
            n = this.ifsFile_.exists0();
            if (n == 5 || n == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(n)));
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public File getAbsoluteFile() {
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getAbsolutePath());
        }
        return new IFSJavaFile(this.getAbsolutePath());
    }

    public String getAbsolutePath() {
        String string = this.ifsFile_.getAbsolutePath();
        if (string != null && replace_) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public File getCanonicalFile() throws IOException {
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getCanonicalPath());
        }
        return new IFSJavaFile(this.getCanonicalPath());
    }

    public String getCanonicalPath() throws IOException {
        String string = this.ifsFile_.getCanonicalPath();
        if (string != null && replace_) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public long getFreeSpace() throws SecurityException {
        try {
            return this.ifsFile_.getAvailableSpace(false);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return 0L;
        }
    }

    public long getTotalSpace() throws SecurityException {
        try {
            return this.ifsFile_.getTotalSpace(false);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return 0L;
        }
    }

    public long getUsableSpace() throws SecurityException {
        try {
            return this.ifsFile_.getAvailableSpace(true);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return 0L;
        }
    }

    IFSFile getIfsFile() {
        return this.ifsFile_;
    }

    public String getName() {
        return this.ifsFile_.getName();
    }

    public String getParent() {
        String string = this.ifsFile_.getParent();
        if (string != null && replace_) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public File getParentFile() {
        if (this.getParent() == null) {
            return null;
        }
        if (this.getSystem() != null) {
            return new IFSJavaFile(this.getSystem(), this.getParent());
        }
        return new IFSJavaFile(this.getParent());
    }

    public String getPath() {
        String string = this.ifsFile_.getPath();
        if (string != null && replace_) {
            return string.replace('/', File.separatorChar);
        }
        return string;
    }

    public int getPatternMatching() throws IOException {
        return this.ifsFile_.getPatternMatching();
    }

    public AS400 getSystem() {
        return this.ifsFile_.getSystem();
    }

    public int hashCode() {
        return this.ifsFile_.hashCode();
    }

    public boolean isAbsolute() {
        return this.absolute_;
    }

    static boolean isAbsolutePath(String string) {
        return string != null && string.length() != 0 && string.charAt(0) == File.separatorChar;
    }

    public boolean isDirectory() throws SecurityException {
        int n = 2;
        try {
            n = this.ifsFile_.isDirectory0();
            if (n == 5 || n == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(n)));
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public boolean isFile() throws SecurityException {
        int n = 2;
        try {
            n = this.ifsFile_.isFile0();
            if (n == 5 || n == 13) {
                throw new SecurityException(ResourceBundleLoader.getText(this.mapRC(n)));
            }
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public boolean isHidden() throws SecurityException {
        try {
            return this.ifsFile_.isHidden();
        }
        catch (AS400SecurityException aS400SecurityException) {
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public long lastModified() throws SecurityException {
        try {
            return this.ifsFile_.lastModified0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return 0L;
        }
    }

    public long length() throws SecurityException {
        try {
            if (this.ifsFile_.isSymbolicLink()) {
                this.ifsFile_.clearCachedAttributes();
            }
            return this.ifsFile_.length0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return 0L;
        }
    }

    public String[] list() throws SecurityException {
        try {
            return this.ifsFile_.list0(null, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return new String[0];
        }
    }

    public String[] list(FilenameFilter filenameFilter) throws SecurityException {
        String[] stringArray = null;
        try {
            stringArray = this.ifsFile_.list0(null, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return null;
        }
        if (stringArray == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (filenameFilter != null && !filenameFilter.accept(this, stringArray[i])) continue;
            vector.addElement(stringArray[i]);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public String[] list(IFSFileFilter iFSFileFilter) throws SecurityException {
        try {
            return this.ifsFile_.list0(iFSFileFilter, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return new String[0];
        }
    }

    public String[] list(IFSFileFilter iFSFileFilter, String string) throws SecurityException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.ifsFile_.list0(iFSFileFilter, string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return new String[0];
        }
    }

    public String[] list(String string) throws SecurityException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            return this.ifsFile_.list0(null, string);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return new String[0];
        }
    }

    public File[] listFiles() throws SecurityException {
        return this.listFiles(null, "*");
    }

    public File[] listFiles(FilenameFilter filenameFilter) throws SecurityException {
        IFSFile[] iFSFileArray = null;
        try {
            iFSFileArray = this.ifsFile_.listFiles0(null, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return null;
        }
        if (iFSFileArray == null) {
            return null;
        }
        Vector<IFSJavaFile> vector = new Vector<IFSJavaFile>();
        for (int i = 0; i < iFSFileArray.length; ++i) {
            if (filenameFilter != null && !filenameFilter.accept(this, iFSFileArray[i].getName())) continue;
            vector.addElement(new IFSJavaFile(iFSFileArray[i]));
        }
        Object[] objectArray = new IFSJavaFile[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] listFiles(FileFilter fileFilter) throws SecurityException {
        IFSFile[] iFSFileArray = null;
        try {
            iFSFileArray = this.ifsFile_.listFiles0(null, "*");
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return null;
        }
        if (iFSFileArray == null) {
            return null;
        }
        Vector<IFSJavaFile> vector = new Vector<IFSJavaFile>();
        for (int i = 0; i < iFSFileArray.length; ++i) {
            IFSJavaFile iFSJavaFile = new IFSJavaFile(iFSFileArray[i]);
            if (fileFilter != null && !fileFilter.accept(iFSJavaFile)) continue;
            vector.addElement(iFSJavaFile);
        }
        Object[] objectArray = new IFSJavaFile[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] listFiles(IFSFileFilter iFSFileFilter) throws SecurityException {
        return this.listFiles(iFSFileFilter, "*");
    }

    public File[] listFiles(IFSFileFilter iFSFileFilter, String string) throws SecurityException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        try {
            IFSFile[] iFSFileArray = this.ifsFile_.listFiles0(iFSFileFilter, string);
            File[] fileArray = new IFSJavaFile[iFSFileArray.length];
            for (int i = 0; i < iFSFileArray.length; ++i) {
                fileArray[i] = new IFSJavaFile(iFSFileArray[i]);
            }
            return fileArray;
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return new IFSJavaFile[0];
        }
    }

    public File[] listFiles(String string) throws SecurityException {
        if (string == null) {
            throw new NullPointerException("pattern");
        }
        return this.listFiles(null, string);
    }

    public static File[] listRoots() {
        File[] fileArray = new IFSJavaFile[]{new IFSJavaFile(File.separator)};
        return fileArray;
    }

    private String mapRC(int n) {
        if (n == 5) {
            return "EXC_ACCESS_DENIED";
        }
        if (n == 13) {
            return "EXC_REQUEST_DENIED";
        }
        return "EXC_UNKNOWN";
    }

    public boolean mkdir() throws SecurityException {
        int n = 2;
        try {
            n = this.ifsFile_.mkdir0(this.ifsFile_.getAbsolutePath());
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public boolean mkdirs() throws SecurityException {
        int n = 2;
        try {
            n = this.ifsFile_.mkdirs0();
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public boolean renameTo(IFSJavaFile iFSJavaFile) throws SecurityException {
        if (iFSJavaFile == null) {
            throw new NullPointerException("dest");
        }
        int n = 2;
        IFSFile iFSFile = new IFSFile();
        try {
            iFSFile.setSystem(iFSJavaFile.getSystem());
            String string = iFSJavaFile.getPath();
            iFSFile.setPath(replace_ ? string.replace(File.separatorChar, '/') : string);
            n = this.ifsFile_.renameTo0(iFSFile);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (PropertyVetoException propertyVetoException) {
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
        return n == 0;
    }

    public boolean renameTo(File file) throws SecurityException {
        try {
            return this.renameTo((IFSJavaFile)file);
        }
        catch (ClassCastException classCastException) {
            Trace.log(2, classCastException);
            return false;
        }
    }

    public boolean setLastModified(long l) throws SecurityException {
        try {
            return this.ifsFile_.setLastModified0(l);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean setLength(int n) throws SecurityException {
        try {
            return this.ifsFile_.setLength0(n);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        try {
            this.ifsFile_.setPath(replace_ ? string.replace(File.separatorChar, '/') : string);
            this.absolute_ = IFSJavaFile.isAbsolutePath(string);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return true;
    }

    public void setPatternMatching(int n) throws IOException {
        this.ifsFile_.setPatternMatching(n);
    }

    public boolean setReadOnly() throws SecurityException {
        try {
            return this.ifsFile_.setReadOnly0(true);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        try {
            this.ifsFile_.setSystem(aS400);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return true;
    }

    public boolean setExecutable(boolean bl) throws SecurityException {
        return this.setExecutable(bl, true);
    }

    public boolean setExecutable(boolean bl, boolean bl2) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(1, bl, bl2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean setReadable(boolean bl) throws SecurityException {
        return this.setReadable(bl, true);
    }

    public boolean setReadable(boolean bl, boolean bl2) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(4, bl, bl2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public boolean setWritable(boolean bl) throws SecurityException {
        return this.setWritable(bl, true);
    }

    public boolean setWritable(boolean bl, boolean bl2) throws SecurityException {
        try {
            return this.ifsFile_.setAccess(2, bl, bl2);
        }
        catch (AS400SecurityException aS400SecurityException) {
            Trace.log(2, aS400SecurityException);
            SecurityException securityException = new SecurityException(aS400SecurityException.getMessage());
            try {
                securityException.initCause(aS400SecurityException);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw securityException;
        }
        catch (IOException iOException) {
            if (Trace.traceOn_) {
                Trace.log(2, iOException);
            }
            return false;
        }
    }

    public String toString() {
        if (replace_) {
            return this.ifsFile_.toString().replace('/', File.separatorChar);
        }
        return this.ifsFile_.toString();
    }

    public URL toURL() throws MalformedURLException {
        String string = null;
        string = this.isDirectory() ? this.getAbsolutePath() + File.separatorChar : this.getAbsolutePath();
        return new URL(URL_PROTOCOL, this.getSystem().getSystemName(), string);
    }
}

