/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableDoubleMap;
import com.ibm.as400.access.ConvTableSingleMap;
import com.ibm.as400.access.Trace;
import java.io.UnsupportedEncodingException;

public abstract class ConvTableMixedMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public ConvTableSingleMap sbTable_ = null;
    public ConvTableDoubleMap dbTable_ = null;
    static final byte shiftOut_ = 14;
    static final byte shiftIn_ = 15;
    static final byte ebcdicSpace_ = 64;

    ConvTableMixedMap(int n, int n2, int n3) throws UnsupportedEncodingException {
        super(n);
        this.sbTable_ = (ConvTableSingleMap)ConvTable.getTable(n2, null);
        this.dbTable_ = (ConvTableDoubleMap)ConvTable.getTable(n3, null);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded mixed-byte map for ccsid: " + this.ccsid_);
        }
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        boolean bl = true;
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            if (bl) {
                if (by == 14) {
                    bl = false;
                    continue;
                }
                cArray[n3++] = this.sbTable_.toUnicode_[0xFF & by];
                continue;
            }
            if (by == 15) {
                bl = true;
                continue;
            }
            try {
                if (i + 1 < n + n2) {
                    int n4 = this.dbTable_.toUnicode(cArray, n3, ((0xFF & by) << 8) + (0xFF & byArray[++i]));
                    n3 += n4;
                    continue;
                }
                if (CharConverter.isFaultTolerantConversion()) continue;
                cArray[n3++] = 65533;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_ + ": 0," + n3, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        byte[] byArray = new byte[(cArray.length * 5 + 3) / 2];
        boolean bl = true;
        byte by = 0;
        char c = '\u0000';
        int[] nArray = new int[1];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = cArray[i];
            if ((c2 & 0xFF00) == 0 || c2 == '\u20ac' || c2 == '\u203e' && (this.ccsid_ == 935 || this.ccsid_ == 1388)) {
                by = this.sbTable_.fromUnicode_[c2];
                if (by == 63 && c2 != '\u001a') {
                    c = this.dbTable_.fromUnicode(cArray, i, nArray);
                    if (nArray[0] == 2) {
                        ++i;
                    }
                    if (c == '\ufefe') {
                        if (!bl) {
                            bl = true;
                            byArray[n++] = 15;
                        }
                        byArray[n++] = 63;
                        continue;
                    }
                    if (bl) {
                        bl = false;
                        byArray[n++] = 14;
                    }
                    byArray[n++] = (byte)((0xFFFF & c) >>> 8);
                    byArray[n++] = (byte)(0xFF & c);
                    continue;
                }
                if (!bl) {
                    bl = true;
                    byArray[n++] = 15;
                }
                byArray[n++] = by;
                continue;
            }
            c = this.dbTable_.fromUnicode(cArray, i, nArray);
            if (nArray[0] >= 2) {
                i = i + nArray[0] - 1;
            }
            if (c == '\ufefe' && c2 != '\ufffd') {
                by = this.sbTable_.fromUnicode_[c2];
                if (by == 63) {
                    if (bl) {
                        byArray[n++] = 63;
                        continue;
                    }
                    byArray[n++] = -2;
                    byArray[n++] = -2;
                    continue;
                }
                if (!bl) {
                    bl = true;
                    byArray[n++] = 15;
                }
                byArray[n++] = by;
                continue;
            }
            if (bl) {
                bl = false;
                byArray[n++] = 14;
            }
            byArray[n++] = (byte)((0xFFFF & c) >>> 8);
            byArray[n++] = (byte)(0xFF & c);
        }
        if (!bl) {
            byArray[n++] = 15;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray2);
        }
        return byArray2;
    }

    public int validateData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = -1;
        boolean bl = false;
        for (int i = n; i < n3; ++i) {
            if (n4 == -1) {
                if (byArray[i] != 14) continue;
                n4 = i + 1;
                continue;
            }
            if (byArray[i] == 15) {
                n4 = -1;
                continue;
            }
            ++i;
        }
        if (n4 >= 0) {
            if ((n3 - n4) % 2 == 1) {
                if (byArray[n3 - 2] == 14) {
                    n2 -= 2;
                    byArray[n3 - 2] = 64;
                    byArray[n3 - 1] = 64;
                } else {
                    byArray[n3 - 1] = 15;
                }
            } else if (n4 == n3) {
                byArray[n3 - 1] = 64;
                --n2;
            } else if (byArray[n3 - 3] == 14) {
                n2 -= 3;
                byArray[n3 - 3] = 64;
                byArray[n3 - 2] = 64;
                byArray[n3 - 1] = 64;
            } else {
                byArray[n3 - 2] = 15;
                byArray[n3 - 1] = 64;
                --n2;
            }
        }
        return n2;
    }
}

