/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.Trace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConvTableDoubleMap
extends ConvTable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    private char[] toUnicode_ = null;
    protected char[] fromUnicode_ = null;
    char[][] toUnicodeSurrogate_ = null;
    char[][] toUnicodeTriple_ = null;
    public static final int LEADING_SURROGATE_BASE = 55296;
    public static final int TRAILING_SURROGATE_BASE = 56320;
    public static final int FROM_UNICODE_SURROGATE_DIMENSION_LENGTH = 1024;
    char[][] fromUnicodeSurrogate_ = null;
    char[][][] fromUnicodeTriple_ = null;
    int firstTripleMin_;
    int secondTripleMin_;
    int thirdTripleMin_;
    char[] combiningCharacters_;
    char[][] combiningCombinations_;

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4) {
        this(n, cArray, cArray2);
        int n2;
        int n3;
        char c;
        int n4;
        this.toUnicodeSurrogate_ = new char[65535][];
        this.fromUnicodeSurrogate_ = new char[1024][];
        ArrayList<char[]> arrayList = new ArrayList<char[]>();
        Hashtable<Integer, char[]> hashtable = new Hashtable<Integer, char[]>();
        for (n4 = 0; n4 < cArray3.length; ++n4) {
            char[] cArray5;
            c = cArray3[n4][0];
            char c2 = cArray3[n4][1];
            char c3 = cArray3[n4][2];
            char[] cArray6 = new char[]{c2, c3};
            this.toUnicodeSurrogate_[0xFFFF & c] = cArray6;
            n3 = c2 - 55296;
            n2 = c3 - 56320;
            if (n3 >= 0 && n3 < 1024) {
                if (this.fromUnicodeSurrogate_[n3] == null) {
                    this.fromUnicodeSurrogate_[n3] = new char[1024];
                }
                cArray5 = this.fromUnicodeSurrogate_[n3];
                if (n2 < 0 || n2 >= 1024) continue;
                cArray5[n2] = c;
                continue;
            }
            cArray5 = new char[]{c2, c3, c};
            arrayList.add(cArray5);
            hashtable.put(new Integer(c3), cArray6);
        }
        n4 = hashtable.size();
        this.combiningCharacters_ = new char[n4];
        c = '\u0000';
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n5 = (Integer)enumeration.nextElement();
            this.combiningCharacters_[c] = (char)n5.intValue();
            ++c;
        }
        int n6 = arrayList.size();
        this.combiningCombinations_ = new char[n6][];
        for (c = '\u0000'; c < n6; ++c) {
            this.combiningCombinations_[c] = (char[])arrayList.get(c);
        }
        if (cArray4 != null) {
            int n7;
            int n8;
            int n9;
            char[] cArray7;
            int n10;
            this.firstTripleMin_ = 65535;
            this.secondTripleMin_ = 65535;
            this.thirdTripleMin_ = 65535;
            int n11 = 0;
            n3 = 0;
            n2 = 0;
            for (n10 = 0; n10 < cArray4.length; ++n10) {
                cArray7 = cArray4[n10];
                n9 = 0xFFFF & cArray7[1];
                n8 = 0xFFFF & cArray7[2];
                n7 = 0xFFFF & cArray7[3];
                if (n9 < this.firstTripleMin_) {
                    this.firstTripleMin_ = n9;
                }
                if (n9 > n11) {
                    n11 = n9;
                }
                if (n8 < this.secondTripleMin_) {
                    this.secondTripleMin_ = n8;
                }
                if (n8 > n3) {
                    n3 = n8;
                }
                if (n7 < this.thirdTripleMin_) {
                    this.thirdTripleMin_ = n7;
                }
                if (n7 <= n2) continue;
                n2 = n7;
            }
            this.fromUnicodeTriple_ = new char[n11 - this.firstTripleMin_ + 1][][];
            this.toUnicodeTriple_ = new char[65535][];
            for (n10 = 0; n10 < cArray4.length; ++n10) {
                char[] cArray8;
                cArray7 = cArray4[n10];
                n9 = 0xFFFF & cArray7[0];
                n8 = (0xFFFF & cArray7[1]) - this.firstTripleMin_;
                n7 = (0xFFFF & cArray7[2]) - this.secondTripleMin_;
                int n12 = (0xFFFF & cArray7[3]) - this.thirdTripleMin_;
                this.toUnicodeTriple_[n9] = new char[3];
                this.toUnicodeTriple_[n9][0] = cArray7[1];
                this.toUnicodeTriple_[n9][1] = cArray7[2];
                this.toUnicodeTriple_[n9][2] = cArray7[3];
                Object object = this.fromUnicodeTriple_[n8];
                if (object == null) {
                    object = new char[n3 - this.secondTripleMin_ + 1][];
                    this.fromUnicodeTriple_[n8] = object;
                }
                if ((cArray8 = object[n7]) == null) {
                    cArray8 = new char[n2 - this.thirdTripleMin_ + 1];
                    object[n7] = cArray8;
                }
                cArray8[n12] = (char)n9;
            }
        }
    }

    ConvTableDoubleMap(int n, char[] cArray, char[] cArray2) {
        super(n);
        this.toUnicode_ = this.decompress(cArray);
        this.fromUnicode_ = this.decompress(cArray2);
        if (Trace.traceConversion_) {
            Trace.log(5, "Successfully loaded double-byte map for ccsid: " + this.ccsid_);
        }
    }

    ConvTableDoubleMap(ConvTableDoubleMap convTableDoubleMap) {
        super(convTableDoubleMap.ccsid_);
        this.toUnicode_ = convTableDoubleMap.toUnicode_;
        this.fromUnicode_ = convTableDoubleMap.fromUnicode_;
        this.toUnicodeSurrogate_ = convTableDoubleMap.toUnicodeSurrogate_;
        this.fromUnicodeSurrogate_ = convTableDoubleMap.fromUnicodeSurrogate_;
        this.combiningCharacters_ = convTableDoubleMap.combiningCharacters_;
        this.combiningCombinations_ = convTableDoubleMap.combiningCombinations_;
    }

    char[] decompress(char[] cArray) {
        return ConvTableDoubleMap.decompress(cArray, this.ccsid_);
    }

    static char[] decompress(char[] cArray, int n) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Decompressing double-byte conversion table for ccsid: " + n, cArray.length);
        }
        char[] cArray2 = new char[65536];
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4;
            if (cArray[i] == '\uffff') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                long l = (0xFFFF & cArray[i + 1]) + (0xFFFF & n2);
                n4 = cArray[i + 2];
                while ((long)n2 < l) {
                    cArray2[n2++] = n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\ufffe') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n5 = 0xFFFF & cArray[i + 2];
                n3 = 0xFFFF & cArray[i + 1];
                for (n4 = n5; n4 < n3 + n5; ++n4) {
                    cArray2[n2++] = (char)n4;
                }
                i += 2;
                continue;
            }
            if (cArray[i] == '\u0000') {
                if (cArray[i + 1] == '\u0000') {
                    cArray2[n2++] = cArray[i++];
                    continue;
                }
                int n6 = 0xFFFF & cArray[++i];
                n3 = cArray[++i];
                n4 = (char)(0xFF00 & n3);
                cArray2[n2++] = n3;
                ++i;
                for (int j = 0; j < n6; ++j) {
                    char c = cArray[i + j];
                    cArray2[n2++] = (char)(n4 + ((0xFF00 & c) >>> 8));
                    cArray2[n2++] = (char)(n4 + (0xFF & c));
                }
                i = i + n6 - 1;
                continue;
            }
            cArray2[n2++] = cArray[i];
        }
        return cArray2;
    }

    final String byteArrayToString(byte[] byArray, int n, int n2, BidiConversionProperties bidiConversionProperties) {
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting byte array to string for ccsid: " + this.ccsid_, byArray, n, n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i = 0; i < n2 / 2; ++i) {
            try {
                int n4 = ((0xFF & byArray[i * 2 + n]) << 8) + (0xFF & byArray[i * 2 + 1 + n]);
                int n5 = this.toUnicode(cArray, n3, n4);
                n3 += n5;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (CharConverter.isFaultTolerantConversion()) continue;
                throw arrayIndexOutOfBoundsException;
            }
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination string for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        return String.copyValueOf(cArray, 0, n3);
    }

    public int toUnicode(char[] cArray, int n, int n2) {
        int n3 = 0;
        cArray[n] = this.toUnicode_[n2];
        if (cArray[n] == '\ud800') {
            if (this.toUnicodeSurrogate_ != null) {
                char[] cArray2 = this.toUnicodeSurrogate_[n2];
                if (cArray2 != null) {
                    cArray[n] = cArray2[0];
                    ++n3;
                    cArray[++n] = cArray2[1];
                    ++n;
                    ++n3;
                } else {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else if (cArray[n] == '\ud801') {
            if (this.toUnicodeTriple_ != null) {
                char[] cArray3 = this.toUnicodeTriple_[n2];
                if (cArray3 != null) {
                    cArray[n] = cArray3[0];
                    ++n3;
                    cArray[++n] = cArray3[1];
                    ++n3;
                    cArray[++n] = cArray3[2];
                    ++n;
                    ++n3;
                } else if (this.ccsid_ != 61952) {
                    cArray[n] = 65533;
                    ++n;
                    ++n3;
                }
            } else {
                cArray[n] = 65533;
                ++n;
                ++n3;
            }
        } else {
            ++n;
            ++n3;
        }
        return n3;
    }

    final byte[] stringToByteArray(String string, BidiConversionProperties bidiConversionProperties) {
        char[] cArray = string.toCharArray();
        if (Trace.traceConversion_) {
            Trace.log(5, "Converting string to byte array for ccsid: " + this.ccsid_, ConvTable.dumpCharArray(cArray));
        }
        byte[] byArray = new byte[cArray.length * 2];
        int n = 0;
        int[] nArray = new int[1];
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = this.fromUnicode(cArray, n2, nArray);
            byArray[n * 2] = (byte)(c >>> 8);
            byArray[n * 2 + 1] = (byte)(0xFF & c);
            if (nArray[0] > 1) {
                ++n2;
            }
            ++n2;
            ++n;
        }
        if (n * 2 != byArray.length) {
            byte[] byArray2 = new byte[n * 2];
            System.arraycopy(byArray, 0, byArray2, 0, n * 2);
            byArray = byArray2;
        }
        if (Trace.traceConversion_) {
            Trace.log(5, "Destination byte array for ccsid: " + this.ccsid_, byArray);
        }
        return byArray;
    }

    public char fromUnicode(char[] cArray, int n, int[] nArray) {
        int n2 = 1;
        int n3 = 0;
        char c = cArray[n];
        if (c < '\ud800' || c >= '\udc00') {
            char[][] cArray2;
            int n4;
            int n5;
            int n6 = n + 1;
            boolean bl = false;
            if (this.combiningCharacters_ != null && n6 < cArray.length) {
                n5 = cArray[n6];
                for (int i = 0; !bl && i < this.combiningCharacters_.length; ++i) {
                    if (n5 != this.combiningCharacters_[i]) continue;
                    for (n4 = 0; !bl && n4 < this.combiningCombinations_.length; ++n4) {
                        if (c != this.combiningCombinations_[n4][0] || n5 != this.combiningCombinations_[n4][1]) continue;
                        bl = true;
                        n3 = this.combiningCombinations_[n4][2];
                        ++n;
                        ++n2;
                    }
                }
            }
            if (!bl && this.fromUnicodeTriple_ != null && n + 2 < cArray.length && (n5 = (0xFFFF & cArray[n]) - this.firstTripleMin_) >= 0 && n5 < this.fromUnicodeTriple_.length && (cArray2 = this.fromUnicodeTriple_[n5]) != null && (n4 = (0xFFFF & cArray[n + 1]) - this.secondTripleMin_) >= 0 && n4 < cArray2.length) {
                char[] cArray3 = cArray2[n4];
                int n7 = (0xFFFF & cArray[n + 2]) - this.thirdTripleMin_;
                if (n7 >= 0 && n7 < cArray3.length && (n3 = cArray3[n7]) != 0) {
                    bl = true;
                    n2 += 2;
                }
            }
            if (!bl) {
                n3 = this.fromUnicode_[cArray[n]];
            }
        } else {
            int n8;
            char[] cArray4;
            int n9 = cArray[n] - 55296;
            ++n2;
            n3 = this.fromUnicodeSurrogate_ != null ? ((cArray4 = this.fromUnicodeSurrogate_[n9]) != null ? ((n8 = cArray[++n] - 56320) >= 0 && n8 < 1024 && cArray4[n8] != '\u0000' ? cArray4[n8] : 65278) : 65278) : 65278;
        }
        nArray[0] = n2;
        return (char)n3;
    }

    public char[] getFromUnicode() {
        return this.fromUnicode_;
    }

    void setFromUnicode(char[] cArray) {
        this.fromUnicode_ = cArray;
    }

    public char[] getToUnicode() {
        return this.toUnicode_;
    }

    void setToUnicode(char[] cArray) {
        this.toUnicode_ = cArray;
    }
}

