/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jt400;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Jt400EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":userID:password/systemName/objectPath.type";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "jt400".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "userID", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "password", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "systemName", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "objectPath", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "type", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(37);
        props.add("backoffMultiplier");
        props.add("initialDelay");
        props.add("type");
        props.add("userID");
        props.add("ccsid");
        props.add("objectPath");
        props.add("scheduler");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("systemName");
        props.add("runLoggingLevel");
        props.add("messageAction");
        props.add("backoffErrorThreshold");
        props.add("outputFieldsLengthArray");
        props.add("procedureName");
        props.add("greedy");
        props.add("guiAvailable");
        props.add("scheduledExecutorService");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("searchType");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("format");
        props.add("exchangePattern");
        props.add("searchKey");
        props.add("keyed");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("outputFieldsIdxArray");
        props.add("startScheduler");
        props.add("readTimeout");
        props.add("exceptionHandler");
        props.add("secured");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userID");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

