/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.access.Trace;
import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

class ConnectionHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private JdbcMeService service_;
    private MicroDataInputStream in_;
    private MicroDataOutputStream out_;

    public ConnectionHandler(JdbcMeService jdbcMeService, MicroDataInputStream microDataInputStream, MicroDataOutputStream microDataOutputStream) {
        this.service_ = jdbcMeService;
        this.in_ = microDataInputStream;
        this.out_ = microDataOutputStream;
    }

    public void process(Connection connection, int n) throws IOException {
        switch (n) {
            case 4689: {
                this.close(connection);
                break;
            }
            case 4690: {
                this.createStatement(connection);
                break;
            }
            case 4691: {
                this.createStatement2(connection);
                break;
            }
            case 4692: {
                this.prepareStatement(connection);
                break;
            }
            case 4693: {
                this.setAutoCommit(connection);
                break;
            }
            case 4694: {
                this.setTransactionIsolation(connection);
                break;
            }
            case 4695: {
                this.commit(connection);
                break;
            }
            case 4696: {
                this.rollback(connection);
                break;
            }
            default: {
                if (!Trace.isTraceOn()) break;
                Trace.log(2, "Connection Function ID not recognized - function code: " + n);
            }
        }
    }

    public void close(Connection connection) throws IOException {
        block2: {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Exception caught trying to close connection object " + connection, (Throwable)sQLException);
            }
        }
        this.service_.removeConnection(connection);
    }

    public void createStatement(Connection connection) throws IOException {
        try {
            Statement statement = connection.createStatement();
            this.service_.addStatement(statement);
            int n = this.service_.mapObject(statement);
            this.out_.writeInt(n);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void createStatement2(Connection connection) throws IOException {
        try {
            int n = this.in_.readInt();
            int n2 = this.in_.readInt();
            Statement statement = connection.createStatement(n, n2);
            this.service_.addStatement(statement);
            int n3 = this.service_.mapObject(statement);
            this.out_.writeInt(n3);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void prepareStatement(Connection connection) throws IOException {
        try {
            String string = this.in_.readUTF();
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            this.service_.addStatement(preparedStatement);
            int n = this.service_.mapObject(preparedStatement);
            this.out_.writeInt(n);
            this.out_.flush();
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            if (resultSetMetaData == null) {
                this.out_.writeInt(0);
            } else {
                this.out_.writeInt(1);
                int n2 = resultSetMetaData.getColumnCount();
                this.out_.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    this.out_.writeInt(resultSetMetaData.getColumnType(i + 1));
                }
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void prepareStatement2(Connection connection) throws IOException {
        try {
            String string = this.in_.readUTF();
            PreparedStatement preparedStatement = connection.prepareStatement(string, 1005, 1008);
            this.service_.addStatement(preparedStatement);
            int n = this.service_.mapObject(preparedStatement);
            this.out_.writeInt(n);
            this.out_.flush();
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            if (resultSetMetaData == null) {
                this.out_.writeInt(0);
            } else {
                this.out_.writeInt(1);
                int n2 = resultSetMetaData.getColumnCount();
                this.out_.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    this.out_.writeInt(resultSetMetaData.getColumnType(i + 1));
                }
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void setAutoCommit(Connection connection) throws IOException {
        try {
            boolean bl = this.in_.readBoolean();
            connection.setAutoCommit(bl);
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void setTransactionIsolation(Connection connection) throws IOException {
        try {
            int n = this.in_.readInt();
            connection.setTransactionIsolation(n);
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void commit(Connection connection) throws IOException {
        try {
            connection.commit();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void rollback(Connection connection) throws IOException {
        try {
            connection.rollback();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }
}

