/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DLOPermission;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.IFSFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PermissionAccess;
import com.ibm.as400.access.PermissionAccessDLO;
import com.ibm.as400.access.PermissionAccessQSYS;
import com.ibm.as400.access.PermissionAccessRoot;
import com.ibm.as400.access.QSYSPermission;
import com.ibm.as400.access.RootPermission;
import com.ibm.as400.access.ServerStartupException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserPermission;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;

public class Permission
implements Serializable {
    static final long serialVersionUID = 4L;
    public static final int TYPE_DLO = 0;
    public static final int TYPE_QSYS = 1;
    public static final int TYPE_ROOT = 2;
    private AS400 as400_;
    private String authorizationList_;
    private String autListBackup_;
    private boolean autListChanged_;
    private String name_;
    private String owner_;
    private boolean ownerChanged_;
    private boolean revokeOldAuthority_;
    private boolean revokeOldGroupAuthority_;
    private boolean followSymbolicLinks_ = true;
    private String path_;
    private String asp_ = null;
    private String primaryGroup_;
    private boolean primaryGroupChanged_;
    private boolean sensitivityChanged_;
    private int sensitivityLevel_;
    private int type_;
    private transient Vector userPermissionsBuffer_;
    private transient Vector userPermissions_;
    private transient Object userPermissionsLock_ = new Object();
    private transient PermissionAccess access_;
    private transient PropertyChangeSupport changes_;

    public Permission(IFSFile iFSFile) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(iFSFile.getSystem(), iFSFile.getPath(), false, true);
    }

    public Permission(IFSFile iFSFile, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(iFSFile.getSystem(), iFSFile.getPath(), bl, true);
    }

    public Permission(IFSFile iFSFile, boolean bl, boolean bl2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(iFSFile.getSystem(), iFSFile.getPath(), bl, bl2);
    }

    public Permission(AS400 aS400, String string) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(aS400, string, false, true);
    }

    public Permission(AS400 aS400, String string, boolean bl) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        this(aS400, string, bl, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permission(AS400 aS400, String string, boolean bl, boolean bl2) throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, UnsupportedEncodingException {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("fileName");
        }
        this.as400_ = aS400;
        this.path_ = string;
        int n = this.path_.lastIndexOf(47);
        this.name_ = this.path_.substring(n + 1);
        this.type_ = this.parseType(this.path_, bl);
        if (!bl2 && this.as400_.getVRM() < 328704) {
            if (Trace.traceOn_) {
                Trace.log(4, "followLinks(false): Parameter is ignored because system is not V5R4 or higher.");
            }
        } else {
            this.followSymbolicLinks_ = bl2;
        }
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
        Vector vector = null;
        try {
            vector = this.access_.getAuthority(this.path_);
            this.changes_ = new PropertyChangeSupport(this);
            Object object = this.userPermissionsLock_;
            synchronized (object) {
                this.owner_ = (String)vector.elementAt(0);
                this.primaryGroup_ = (String)vector.elementAt(1);
                this.authorizationList_ = (String)vector.elementAt(2);
                this.sensitivityLevel_ = (Integer)vector.elementAt(3);
                this.userPermissionsBuffer_ = new Vector();
                this.userPermissions_ = new Vector();
                int n2 = vector.size();
                for (int i = 4; i < n2; ++i) {
                    UserPermission userPermission = (UserPermission)vector.elementAt(i);
                    if (userPermission == null) continue;
                    userPermission.setCommitted(-1);
                    this.userPermissionsBuffer_.addElement(userPermission);
                    this.userPermissions_.addElement(userPermission);
                }
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            Trace.log(2, propertyVetoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorizedUser(String string) {
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        String string2 = string.trim().toUpperCase();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.getUserIndex(string2, this.userPermissions_) != -1) {
                Trace.log(2, "Permission already exists for user " + string);
                throw new ExtendedIllegalArgumentException("userProfileName (" + string2 + ")", 2);
            }
            int n = this.getUserIndex(string2, this.userPermissionsBuffer_);
            if (n != -1) {
                UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(n);
                userPermission.setCommitted(2);
                this.userPermissions_.addElement(userPermission);
            } else {
                UserPermission userPermission;
                switch (this.type_) {
                    case 0: {
                        userPermission = new DLOPermission(string2);
                        break;
                    }
                    case 1: {
                        userPermission = new QSYSPermission(string2);
                        break;
                    }
                    default: {
                        userPermission = new RootPermission(string2);
                    }
                }
                userPermission.setGroupIndicator(1);
                userPermission.setCommitted(0);
                this.userPermissionsBuffer_.addElement(userPermission);
                this.userPermissions_.addElement(userPermission);
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserPermission(UserPermission userPermission) {
        if (userPermission == null) {
            throw new NullPointerException("userPermission");
        }
        switch (this.type_) {
            case 0: {
                if (userPermission instanceof DLOPermission) break;
            }
            case 1: {
                if (userPermission instanceof QSYSPermission) break;
            }
            case 2: {
                if (userPermission instanceof RootPermission) break;
            }
            default: {
                throw new ExtendedIllegalArgumentException("userPermission", 2);
            }
        }
        String string = userPermission.getUserID();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.getUserIndex(string, this.userPermissions_) != -1) {
                Trace.log(2, "Permission already exists for user " + string);
                throw new ExtendedIllegalArgumentException("userProfileName (" + string + ")", 2);
            }
            int n = this.getUserIndex(string, this.userPermissionsBuffer_);
            if (n != -1) {
                userPermission.setCommitted(2);
                this.userPermissionsBuffer_.setElementAt(userPermission, n);
                this.userPermissions_.addElement(userPermission);
            } else {
                userPermission.setCommitted(0);
                this.userPermissionsBuffer_.addElement(userPermission);
                this.userPermissions_.addElement(userPermission);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() throws AS400Exception, AS400SecurityException, ConnectionDroppedException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ServerStartupException {
        if (this.isCommitted()) {
            return;
        }
        for (int i = 1; i <= 2; ++i) {
            try {
                block20: {
                    try {
                        if (this.autListChanged_) {
                            this.access_.setAuthorizationList(this.path_, this.authorizationList_, this.autListBackup_);
                            this.autListChanged_ = false;
                        }
                        if (this.sensitivityChanged_) {
                            this.access_.setSensitivity(this.path_, this.sensitivityLevel_);
                            this.sensitivityChanged_ = false;
                        }
                        if (this.ownerChanged_) {
                            this.access_.setOwner(this.path_, this.owner_, this.revokeOldAuthority_);
                            this.ownerChanged_ = false;
                        }
                        if (this.primaryGroupChanged_) {
                            this.access_.setPrimaryGroup(this.path_, this.primaryGroup_, this.revokeOldGroupAuthority_);
                            this.primaryGroupChanged_ = false;
                        }
                    }
                    catch (AS400Exception aS400Exception) {
                        Trace.log(2, aS400Exception);
                        if (i != 2) break block20;
                        throw aS400Exception;
                    }
                }
                Object object = this.userPermissionsLock_;
                synchronized (object) {
                    int n = this.userPermissionsBuffer_.size();
                    block14: for (int j = n - 1; j >= 0; --j) {
                        UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(j);
                        switch (userPermission.getCommitted()) {
                            case 3: {
                                this.access_.setFromAuthorizationList(this.path_, userPermission.isFromAuthorizationList());
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 0: {
                                this.access_.addUser(this.path_, userPermission);
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 2: {
                                this.access_.setAuthority(this.path_, userPermission);
                                userPermission.setCommitted(-1);
                                continue block14;
                            }
                            case 1: {
                                this.access_.removeUser(this.path_, userPermission.getUserID());
                                userPermission.setCommitted(-1);
                                this.userPermissionsBuffer_.removeElement(userPermission);
                                continue block14;
                            }
                        }
                    }
                    continue;
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                Trace.log(2, propertyVetoException);
            }
        }
        this.changes_.firePropertyChange("permission", null, this);
    }

    public String getAuthorizationList() {
        return this.authorizationList_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAuthorizedUsers() {
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int n = this.userPermissions_.size();
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(i);
                vector.addElement(userPermission.getUserID());
            }
            return vector.elements();
        }
    }

    public String getObjectPath() {
        return this.path_;
    }

    public String getName() {
        return this.name_;
    }

    public String getOwner() {
        return this.owner_;
    }

    public String getPrimaryGroup() {
        return this.primaryGroup_;
    }

    public int getSensitivityLevel() {
        return this.sensitivityLevel_;
    }

    public AS400 getSystem() {
        return this.as400_;
    }

    public int getType() {
        return this.type_;
    }

    private int getUserIndex(String string, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            UserPermission userPermission = (UserPermission)vector.elementAt(i);
            if (!userPermission.getUserID().equals(string)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserPermission getUserPermission(String string) {
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        String string2 = string.toUpperCase();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int n = this.getUserIndex(string2, this.userPermissions_);
            if (n != -1) {
                return (UserPermission)this.userPermissions_.elementAt(n);
            }
            n = this.getUserIndex("*PUBLIC", this.userPermissions_);
            UserPermission userPermission = (UserPermission)this.userPermissions_.elementAt(n);
            if (userPermission instanceof QSYSPermission && n != -1 && !((QSYSPermission)userPermission).getObjectAuthority().equalsIgnoreCase("*EXCLUDE")) {
                return (UserPermission)this.userPermissions_.elementAt(n);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getUserPermissions() {
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            return this.userPermissions_.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommitted() {
        boolean bl = true;
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int n = this.userPermissionsBuffer_.size();
            if (this.sensitivityChanged_) {
                return false;
            }
            if (this.autListChanged_) {
                return false;
            }
            if (this.ownerChanged_) {
                return false;
            }
            if (this.primaryGroupChanged_) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                UserPermission userPermission = (UserPermission)this.userPermissionsBuffer_.elementAt(i);
                if (userPermission.getCommitted() == -1) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    public boolean isFollowSymbolicLinks() {
        return this.followSymbolicLinks_;
    }

    private int parseType(String string, boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(3, "IASP flag is: " + bl + ", object name: " + string);
        }
        if (bl) {
            int n;
            String string2 = string.toUpperCase();
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if ((n = string2.indexOf("/QSYS.LIB/")) >= 0) {
                if (n > 0) {
                    String string3 = string2.substring(1, n);
                    if (string3.indexOf(47) < 0) {
                        this.asp_ = string.substring(0, n);
                        return 1;
                    }
                } else {
                    return 1;
                }
            }
            if (string2.startsWith("/QDLS/")) {
                return 0;
            }
            return 2;
        }
        String string4 = string.toUpperCase();
        if (string4.startsWith("/QSYS.LIB/") || string4.equals("/QSYS.LIB")) {
            return 1;
        }
        if (string4.startsWith("/QDLS/") || string4.equals("/QDLS")) {
            return 0;
        }
        return 2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        int n;
        objectInputStream.defaultReadObject();
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
        this.userPermissionsLock_ = new Object();
        this.userPermissionsBuffer_ = new Vector();
        this.userPermissions_ = new Vector();
        int n2 = (Integer)objectInputStream.readObject();
        for (n = 0; n < n2; ++n) {
            this.userPermissionsBuffer_.addElement(objectInputStream.readObject());
        }
        n2 = (Integer)objectInputStream.readObject();
        for (n = 0; n < n2; ++n) {
            this.userPermissions_.addElement(objectInputStream.readObject());
        }
        this.changes_ = new PropertyChangeSupport(this);
        objectInputStream.readObject();
    }

    public void removeAuthorizedUser(String string) {
        if (string == null) {
            throw new NullPointerException("userProfileName");
        }
        String string2 = string.trim().toUpperCase();
        UserPermission userPermission = this.getUserPermission(string2);
        if (userPermission == null || userPermission.getUserID().equalsIgnoreCase("*PUBLIC")) {
            Trace.log(2, "Permission does not exist for user " + string);
            throw new ExtendedIllegalArgumentException("userProfileName (" + string2 + ")", 2);
        }
        this.removeUserPermission(userPermission);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        this.changes_.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserPermission(UserPermission userPermission) {
        if (userPermission == null) {
            throw new NullPointerException("permission");
        }
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            if (this.userPermissions_.indexOf(userPermission) == -1) {
                Trace.log(2, "Permission does not exist for user " + userPermission.getUserID());
                throw new ExtendedIllegalArgumentException("permission", 2);
            }
            switch (userPermission.getCommitted()) {
                case 0: {
                    this.userPermissions_.removeElement(userPermission);
                    this.userPermissionsBuffer_.removeElement(userPermission);
                    userPermission.setCommitted(-1);
                    break;
                }
                default: {
                    userPermission.setCommitted(1);
                    this.userPermissions_.removeElement(userPermission);
                }
            }
        }
    }

    public synchronized void setAuthorizationList(String string) {
        if (string == null) {
            throw new NullPointerException("autList");
        }
        if (string.trim().equalsIgnoreCase(this.authorizationList_)) {
            return;
        }
        if (!this.autListChanged_) {
            this.autListBackup_ = this.authorizationList_;
        }
        this.authorizationList_ = string.trim().toUpperCase();
        this.autListChanged_ = true;
    }

    public synchronized void setOwner(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("owner");
        }
        this.owner_ = string;
        this.revokeOldAuthority_ = bl;
        this.ownerChanged_ = true;
    }

    public void setPrimaryGroup(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("primaryGroup");
        }
        this.primaryGroup_ = string;
        this.revokeOldGroupAuthority_ = bl;
        this.primaryGroupChanged_ = true;
    }

    public synchronized void setSensitivityLevel(int n) {
        if (n < 0 || n > 4) {
            throw new ExtendedIllegalArgumentException("sensitivityLevel (" + n + ")", 2);
        }
        this.sensitivityLevel_ = n;
        this.sensitivityChanged_ = true;
    }

    public synchronized void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (this.as400_ == null) {
            this.as400_ = aS400;
        } else {
            if (this.as400_.isConnected()) {
                throw new ExtendedIllegalStateException("system", 5);
            }
            if (this.as400_.equals(aS400)) {
                return;
            }
        }
        switch (this.type_) {
            case 1: {
                this.access_ = new PermissionAccessQSYS(this.as400_);
                break;
            }
            case 0: {
                this.access_ = new PermissionAccessDLO(this.as400_);
                break;
            }
            default: {
                this.access_ = new PermissionAccessRoot(this.as400_);
            }
        }
        this.access_.setFollowSymbolicLinks(this.followSymbolicLinks_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object object = this.userPermissionsLock_;
        synchronized (object) {
            int n;
            objectOutputStream.writeObject(new Integer(this.userPermissionsBuffer_.size()));
            for (n = 0; n < this.userPermissionsBuffer_.size(); ++n) {
                objectOutputStream.writeObject(this.userPermissionsBuffer_.elementAt(n));
            }
            objectOutputStream.writeObject(new Integer(this.userPermissions_.size()));
            for (n = 0; n < this.userPermissions_.size(); ++n) {
                objectOutputStream.writeObject(this.userPermissions_.elementAt(n));
            }
            objectOutputStream.writeObject(null);
        }
    }
}

