/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.NativeException;
import com.ibm.as400.access.NativeMethods;
import com.ibm.as400.access.SignonConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UnixSocketUser;
import java.io.IOException;

class CurrentUser {
    CurrentUser() {
    }

    static String getUserID(int n) {
        Object object;
        byte[] byArray = null;
        try {
            if (n >= 328704) {
                byArray = NativeMethods.getUserId();
            } else if (n >= 328192) {
                if (NativeMethods.loadSCK()) {
                    byArray = CurrentUser.getUserIdNative();
                }
            } else {
                object = new UnixSocketUser();
                byArray = object.getUserId();
            }
        }
        catch (NativeException nativeException) {
            Trace.log(2, "Error retrieving current userID:", (Throwable)nativeException);
        }
        catch (Throwable throwable) {
            Trace.log(2, "Error retrieving current userID:", throwable);
        }
        if (byArray != null) {
            try {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID in EBCDIC: ", byArray);
                }
                object = SignonConverter.byteArrayToString(byArray);
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID: '" + (String)object + "'");
                }
                return object;
            }
            catch (AS400SecurityException aS400SecurityException) {
                if (Trace.isTraceOn()) {
                    Trace.log(1, "Current userID convert failed, user id characters are not valid");
                }
                return null;
            }
        }
        return null;
    }

    static byte[] getUserInfo(int n, byte[] byArray, byte[] byArray2, String string) throws AS400SecurityException, IOException {
        try {
            if (n >= 328704) {
                return NativeMethods.getUserInfo(byArray, byArray2);
            }
            if (n >= 328192) {
                return CurrentUser.getUserInfoNative(byArray, byArray2);
            }
            UnixSocketUser unixSocketUser = new UnixSocketUser();
            return unixSocketUser.getSubstitutePassword(byArray, byArray2);
        }
        catch (NativeException nativeException) {
            throw AS400ImplRemote.returnSecurityException(BinaryConverter.byteArrayToInt(nativeException.data, 0), null, string);
        }
    }

    private static native byte[] getUserIdNative() throws NativeException;

    private static native byte[] getUserInfoNative(byte[] var0, byte[] var1) throws NativeException;
}

