/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCBlobLocator;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCClobLocator;
import com.ibm.as400.access.AS400JDBCConnection;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCInputStream;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTableReader;
import com.ibm.as400.access.DBLobData;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLobLocator;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ReaderInputStream;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import com.ibm.as400.access.SQLLocatorBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

final class SQLXMLLocator
extends SQLLocatorBase {
    static final String copyright = "Copyright (C) 1997-2006 International Business Machines Corporation and others.";
    private AS400JDBCConnection connection_;
    private ConvTable converter_;
    private ConvTable unicodeConverter_;
    private ConvTable unicodeUtf8Converter_;
    private int id_;
    private JDLobLocator locator_;
    private int maxLength_;
    private SQLConversionSettings settings_;
    private int truncated_;
    private boolean outOfBounds_;
    private int columnIndex_;
    private byte[] valueBlob_;
    private String valueClob_;
    private Object savedValue_;
    private Object savedObject_;
    private int scale_;
    private boolean savedObjectWrittenToServer_ = false;
    private int xmlType_;
    private boolean inputStreamRead_ = false;

    SQLXMLLocator(AS400JDBCConnection aS400JDBCConnection, int n, int n2, SQLConversionSettings sQLConversionSettings, ConvTable convTable, int n3, int n4) {
        this.connection_ = aS400JDBCConnection;
        n2 = 0x7FFFFFFE;
        this.id_ = n;
        this.locator_ = n4 == 1 ? new JDLobLocator(aS400JDBCConnection, n, n2, false) : new JDLobLocator(aS400JDBCConnection, n, n2, false);
        this.maxLength_ = n2;
        this.settings_ = sQLConversionSettings;
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        this.converter_ = convTable;
        this.columnIndex_ = n3;
        this.xmlType_ = n4;
        try {
            this.unicodeConverter_ = aS400JDBCConnection.getConverter(1200);
            this.unicodeUtf8Converter_ = aS400JDBCConnection.getConverter(1208);
        }
        catch (SQLException sQLException) {
            this.unicodeConverter_ = aS400JDBCConnection.getConverter();
        }
    }

    public Object clone() {
        return new SQLXMLLocator(this.connection_, this.id_, this.maxLength_, this.settings_, this.converter_, this.columnIndex_, this.xmlType_);
    }

    public void setHandle(int n) {
        this.locator_.setHandle(n);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public int getHandle() {
        return this.locator_.getHandle();
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        this.convertFromRawBytes(byArray, n, convTable, false);
    }

    public void convertFromRawBytes(byte[] byArray, int n, ConvTable convTable, boolean bl) throws SQLException {
        int n2 = BinaryConverter.byteArrayToInt(byArray, n);
        this.locator_.setHandle(n2);
        this.locator_.setColumnIndex(this.columnIndex_);
        this.savedObject_ = null;
        this.savedObjectWrittenToServer_ = false;
    }

    public void convertToRawBytes(byte[] byArray, int n, ConvTable convTable) throws SQLException {
        BinaryConverter.intToByteArray(this.locator_.getHandle(), byArray, n);
        if (!this.savedObjectWrittenToServer_ && this.savedObject_ != null) {
            this.writeToServer();
        }
    }

    public void validateRawTruncatedData(byte[] byArray, int n, ConvTable convTable) {
    }

    public void set(Object object, Calendar calendar, int n) throws SQLException {
        this.savedObject_ = object;
        if (object instanceof ConvTableReader) {
            ((ConvTableReader)this.savedObject_).isXML_ = true;
            this.scale_ = -2;
        } else if (n != -1) {
            this.scale_ = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConversion() throws SQLException {
        block29: {
            this.valueClob_ = null;
            this.valueBlob_ = null;
            int n = this.scale_;
            if (n == -1) {
                try {
                    n = (int)this.locator_.getLength();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.savedObject_ instanceof String) {
                this.valueClob_ = (String)this.savedObject_;
                break block29;
            }
            if (this.savedObject_ instanceof Reader) {
                this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, n, this);
                this.savedObject_ = this.valueClob_;
                break block29;
            }
            if (this.savedObject_ instanceof Clob) {
                Clob clob;
                if (this.savedObject_ instanceof AS400JDBCClobLocator) {
                    Clob clob2 = clob = (AS400JDBCClobLocator)this.savedObject_;
                    synchronized (clob2) {
                        if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                            this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                            this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                            ((AS400JDBCClobLocator)clob).savedObject_ = null;
                            if (this.savedObject_ != null && !(this.savedObject_ instanceof AS400JDBCClobLocator)) {
                                this.doConversion();
                                return;
                            }
                        }
                    }
                }
                clob = (Clob)this.savedObject_;
                this.valueClob_ = clob.getSubString(1L, (int)clob.length());
                break block29;
            }
            if (this.savedObject_ instanceof byte[]) {
                this.valueBlob_ = (byte[])this.savedObject_;
                int n2 = this.valueBlob_.length;
                if (n2 > this.maxLength_) {
                    byte[] byArray = new byte[this.maxLength_];
                    System.arraycopy(this.valueBlob_, 0, byArray, 0, this.maxLength_);
                    this.valueBlob_ = byArray;
                }
            } else if (this.savedObject_ instanceof Blob) {
                int n3;
                Blob blob = (Blob)this.savedObject_;
                int n4 = (int)blob.length();
                int n5 = n3 = n4 < 0 ? Integer.MAX_VALUE : n4;
                if (n3 > this.maxLength_) {
                    n3 = this.maxLength_;
                }
                this.valueBlob_ = blob.getBytes(1L, n3);
            } else if (this.savedObject_ instanceof InputStream) {
                n = this.scale_;
                if (n >= 0) {
                    int n6;
                    InputStream inputStream = (InputStream)this.savedObject_;
                    this.valueBlob_ = SQLLocatorBase.readInputStream(inputStream, n, null, false);
                    this.inputStreamRead_ = true;
                    if (this.valueBlob_.length < n) {
                        JDError.throwSQLException((Object)this, "07006");
                    }
                    if ((n6 = this.valueBlob_.length) > this.maxLength_) {
                        byte[] byArray = new byte[this.maxLength_];
                        System.arraycopy(this.valueBlob_, 0, byArray, 0, this.maxLength_);
                        this.valueBlob_ = byArray;
                    }
                    this.savedObject_ = this.valueBlob_;
                } else if (n == -2) {
                    InputStream inputStream = (InputStream)this.savedObject_;
                    this.valueBlob_ = SQLLocatorBase.readInputStream(inputStream, n, null, false);
                    this.inputStreamRead_ = true;
                    int n7 = this.valueBlob_.length;
                    if (n7 > this.maxLength_) {
                        byte[] byArray = new byte[this.maxLength_];
                        System.arraycopy(this.valueBlob_, 0, byArray, 0, this.maxLength_);
                        this.valueBlob_ = byArray;
                    }
                    this.savedObject_ = this.valueBlob_;
                } else {
                    JDError.throwSQLException("07006");
                }
            } else {
                JDError.throwSQLException("07006");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToServer() throws SQLException {
        if (this.inputStreamRead_) {
            this.locator_.writeData(0L, this.valueBlob_, true);
        } else if (this.savedObject_ instanceof byte[]) {
            byte[] byArray = (byte[])this.savedObject_;
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof InputStream) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                InputStream inputStream = (InputStream)this.savedObject_;
                this.valueBlob_ = SQLLocatorBase.readInputStream(inputStream, n, this.locator_, false);
                this.inputStreamRead_ = true;
                if (this.valueBlob_.length < n) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (n == -2) {
                InputStream inputStream = (InputStream)this.savedObject_;
                boolean bl = false;
                if (this.xmlType_ == 1) {
                    bl = true;
                }
                this.valueBlob_ = SQLLocatorBase.readInputStream(inputStream, n, this.locator_, bl);
                this.inputStreamRead_ = true;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else if (this.savedObject_ instanceof Blob) {
            Blob blob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCBlobLocator) {
                blob = (AS400JDBCBlobLocator)this.savedObject_;
                AS400JDBCBlobLocator aS400JDBCBlobLocator = blob;
                synchronized (aS400JDBCBlobLocator) {
                    if (((AS400JDBCBlobLocator)blob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCBlobLocator)blob).savedObject_;
                        this.scale_ = ((AS400JDBCBlobLocator)blob).savedScale_;
                        ((AS400JDBCBlobLocator)blob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                blob = (Blob)this.savedObject_;
                int n = (int)blob.length();
                byte[] byArray = blob.getBytes(1L, n);
                this.locator_.writeData(0L, byArray, 0, n, true);
            }
        } else if (this.savedObject_ instanceof String) {
            byte[] byArray;
            String string = (String)this.savedObject_;
            if (JDUtilities.hasXMLDeclaration(string)) {
                string = JDUtilities.handleXMLDeclarationEncoding(string);
                byArray = this.unicodeConverter_.stringToByteArray(string);
            } else {
                byArray = this.unicodeUtf8Converter_.stringToByteArray(string);
            }
            this.locator_.writeData(0L, byArray, true);
        } else if (this.savedObject_ instanceof Reader) {
            int n = this.scale_;
            if (n == 0) {
                this.locator_.writeData(0L, new byte[0], 0, 0, true);
            } else if (n > 0) {
                byte[] byArray;
                String string = this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, n, this);
                this.savedObject_ = this.valueClob_;
                if (JDUtilities.hasXMLDeclaration(this.valueClob_)) {
                    string = JDUtilities.handleXMLDeclarationEncoding(string);
                    byArray = this.unicodeConverter_.stringToByteArray(string);
                } else {
                    byArray = this.unicodeUtf8Converter_.stringToByteArray(string);
                }
                this.locator_.writeData(0L, byArray, true);
                if (byArray.length < n) {
                    JDError.throwSQLException((Object)this, "07006");
                }
            } else if (n == -2) {
                byte[] byArray;
                String string = this.valueClob_ = SQLDataBase.getStringFromReader((Reader)this.savedObject_, n, this);
                this.savedObject_ = this.valueClob_;
                if (JDUtilities.hasXMLDeclaration(this.valueClob_)) {
                    string = JDUtilities.handleXMLDeclarationEncoding(string);
                    byArray = this.unicodeConverter_.stringToByteArray(string);
                } else {
                    byArray = this.unicodeUtf8Converter_.stringToByteArray(string);
                }
                this.locator_.writeData(0L, byArray, true);
            }
        } else if (this.savedObject_ instanceof Clob) {
            Clob clob;
            boolean bl = false;
            if (this.savedObject_ instanceof AS400JDBCClobLocator) {
                clob = (AS400JDBCClobLocator)this.savedObject_;
                AS400JDBCClobLocator aS400JDBCClobLocator = clob;
                synchronized (aS400JDBCClobLocator) {
                    if (((AS400JDBCClobLocator)clob).savedObject_ != null) {
                        this.savedObject_ = ((AS400JDBCClobLocator)clob).savedObject_;
                        this.scale_ = ((AS400JDBCClobLocator)clob).savedScale_;
                        ((AS400JDBCClobLocator)clob).savedObject_ = null;
                        this.writeToServer();
                        return;
                    }
                }
            }
            if (!bl) {
                clob = (Clob)this.savedObject_;
                int n = (int)clob.length();
                String string = clob.getSubString(1L, n);
                byte[] byArray = JDUtilities.hasXMLDeclaration(string) ? this.unicodeConverter_.stringToByteArray(JDUtilities.handleXMLDeclarationEncoding(string)) : this.unicodeUtf8Converter_.stringToByteArray(string);
                this.locator_.writeData(0L, byArray, 0, byArray.length, true);
                bl = true;
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        } else {
            JDError.throwSQLException((Object)this, "07006");
        }
        this.savedObjectWrittenToServer_ = true;
    }

    public int getSQLType() {
        return 40;
    }

    public String getCreateParameters() {
        return AS400JDBCDriver.getResource("MAXLENGTH", null);
    }

    public int getDisplaySize() {
        return this.maxLength_;
    }

    public String getJavaClassName() {
        return "com.ibm.as400.access.AS400JDBCSQLXML";
    }

    public String getLiteralPrefix() {
        return null;
    }

    public String getLiteralSuffix() {
        return null;
    }

    public String getLocalName() {
        return "XML";
    }

    public int getMaximumPrecision() {
        return 0x7FFFFFFE;
    }

    public int getMaximumScale() {
        return 0;
    }

    public int getMinimumScale() {
        return 0;
    }

    public int getNativeType() {
        return 2452;
    }

    public int getPrecision() {
        return this.maxLength_;
    }

    public int getRadix() {
        return 0;
    }

    public int getScale() {
        return 0;
    }

    public int getType() {
        return 2005;
    }

    public String getTypeName() {
        return "XML";
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isText() {
        return true;
    }

    public int getActualSize() {
        return this.maxLength_;
    }

    public int getTruncated() {
        return this.truncated_;
    }

    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    public void clearTruncated() {
        this.truncated_ = 0;
    }

    public void clearOutOfBounds() {
        this.outOfBounds_ = false;
    }

    public InputStream getAsciiStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ByteArrayInputStream(ConvTable.getTable(819, null).stringToByteArray(this.valueClob_));
            }
            ConvTableReader convTableReader = new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
            return new ReaderInputStream((Reader)convTableReader, 819);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getBinaryStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCInputStream(new JDLobLocator(this.locator_));
    }

    public Blob getBlob() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (this.valueBlob_ != null) {
                return new AS400JDBCBlob(this.valueBlob_, this.maxLength_);
            }
            try {
                return new AS400JDBCBlob(this.valueClob_.getBytes("UTF-8"), this.maxLength_);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return new AS400JDBCBlobLocator(new JDLobLocator(this.locator_), this.savedObject_, this.scale_);
    }

    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public byte[] getBytes() throws SQLException {
        int n;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            if (this.valueBlob_ != null) {
                return this.valueBlob_;
            }
        }
        if ((n = (int)this.locator_.getLength()) == 0) {
            return new byte[0];
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, n);
        int n2 = dBLobData.getLength();
        byte[] byArray = new byte[n2];
        System.arraycopy(dBLobData.getRawBytes(), dBLobData.getOffset(), byArray, 0, n2);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return byArray;
    }

    public Reader getCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new StringReader(this.valueClob_);
            }
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Clob getClob() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new AS400JDBCClob(this.valueClob_, this.maxLength_);
        }
        return new AS400JDBCClobLocator(new JDLobLocator(this.locator_), this.converter_, this.savedObject_, this.scale_, true);
    }

    public Date getDate(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getClob();
    }

    public Object getBatchableObject() throws SQLException {
        return this.getObject();
    }

    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    public String getString() throws SQLException {
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.valueClob_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        string = JDUtilities.stripXMLDeclaration(string);
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return string;
    }

    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public InputStream getUnicodeStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        try {
            if (this.savedObject_ != null) {
                this.doConversion();
                this.truncated_ = 0;
                this.outOfBounds_ = false;
                return new ReaderInputStream((Reader)new StringReader(this.valueClob_), 13488);
            }
            return new ReaderInputStream((Reader)new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true), 13488);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException("HY000", unsupportedEncodingException);
            return null;
        }
    }

    public Reader getNCharacterStream() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return new StringReader(this.valueClob_);
        }
        try {
            return new ConvTableReader((InputStream)new AS400JDBCInputStream(new JDLobLocator(this.locator_)), this.converter_.getCcsid(), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        if (this.savedObject_ != null) {
            this.doConversion();
            this.truncated_ = 0;
            this.outOfBounds_ = false;
            return this.valueClob_;
        }
        DBLobData dBLobData = this.locator_.retrieveData(0L, this.locator_.getMaxLength());
        String string = this.converter_.byteArrayToString(dBLobData.getRawBytes(), dBLobData.getOffset(), dBLobData.getLength());
        string = JDUtilities.stripXMLDeclaration(string);
        return string;
    }

    public Array getArray() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    public void updateSettings(SQLConversionSettings sQLConversionSettings) {
        this.settings_ = sQLConversionSettings;
    }

    public void saveValue() throws SQLException {
        if (this.valueClob_ == null && this.valueBlob_ == null && this.savedObject_ != null) {
            this.doConversion();
        }
        this.savedValue_ = this.valueClob_ != null ? this.valueClob_ : (Object)this.valueBlob_;
    }

    public Object getSavedValue() {
        return this.savedValue_;
    }
}

