/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.CommandHelpHandler;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.MessageFile;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PanelGroup;
import com.ibm.as400.access.PanelGroupHelpIdentifier;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Command
implements Serializable {
    static final long serialVersionUID = 6L;
    public static final byte ACTION_ESCAPE_MESSAGE = -13;
    public static final byte ACTION_INFO_MESSAGE = -14;
    public static final byte ACTION_NO_MESSAGE = -15;
    public static final byte ACTION_SYSTEM_VALUE = -16;
    public static final int ALLOW_ALL = 7;
    public static final int ALLOW_BATCH_JOB = 4;
    public static final int ALLOW_BATCH_PROGRAM = 0;
    public static final int ALLOW_BATCH_REXX_PROCEDURE = 5;
    public static final int ALLOW_EXEC = 2;
    public static final int ALLOW_INTERACTIVE_JOB = 3;
    public static final int ALLOW_INTERACTIVE_PROGRAM = 1;
    public static final int ALLOW_INTERACTIVE_REXX_PROCEDURE = 6;
    public static final int MODE_ALL = 13;
    public static final int MODE_DEBUG = 11;
    public static final int MODE_PRODUCTION = 10;
    public static final int MODE_SERVICE = 12;
    public static final String SYSTEM_STATE = "*S";
    public static final byte THREADSAFE_CONDITIONAL = -14;
    public static final byte THREADSAFE_NO = -16;
    public static final byte THREADSAFE_YES = -15;
    public static final String USER_STATE = "*U";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String path_;
    private String commandProcessingProgram_;
    private String sourceFile_;
    private String validityCheckProgram_;
    private String mode_;
    private String whereAllowedToRun_;
    private boolean allowLimitedUser_;
    private int maxPosParms_;
    private String promptMessageFile_;
    private String messageFile_;
    private String helpPanelGroup_;
    private String helpIdentifier_;
    private String searchIndex_;
    private String currentLibrary_;
    private String productLibrary_;
    private String promptOverrideProgram_;
    private String restricted_;
    private String description_;
    private String cppState_;
    private String vcState_;
    private String poState_;
    private int ccsid_;
    private boolean guiEnabled_;
    private byte threadsafe_;
    private byte multithreadedJobAction_;
    private String xml_;
    private String xml2_;
    private transient PanelGroupHelpIdentifier[] helpIDs_;
    private String xmlProductLibrary_;
    private String xmlPanelGroup_;
    private String xmlHelpText_;
    private boolean refreshed_ = false;
    private boolean refreshedXML_ = false;
    private boolean refreshedXML2_ = false;
    private boolean refreshedHelpIDs_ = false;
    private boolean refreshedHelpText_ = false;
    private boolean refreshedParsedXML_ = false;
    private boolean loadedDescription_ = false;
    private boolean detectedMissingPTF_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_;

    public Command() {
    }

    public Command(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(string, "CMD");
        this.system_ = aS400;
        this.path_ = string;
    }

    Command(AS400 aS400, String string, String string2) {
        this.system_ = aS400;
        this.path_ = string;
        this.description_ = string2;
        this.loadedDescription_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        Command command = this;
        synchronized (command) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
        }
        this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public boolean allowsLimitedUser() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.allowLimitedUser_;
    }

    public int getCCSID() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.ccsid_;
    }

    public String getCommandProcessingProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.commandProcessingProgram_;
    }

    public String getCommandProcessingState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.cppState_;
    }

    public String getCurrentLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.currentLibrary_;
    }

    public String getDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_ && !this.loadedDescription_) {
            this.refreshCommandInfo();
        }
        return this.description_;
    }

    public String getHelpIdentifier() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.helpIdentifier_;
    }

    public PanelGroup getHelpPanelGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        if (this.helpPanelGroup_.equals("*NONE")) {
            return null;
        }
        return new PanelGroup(this.system_, this.helpPanelGroup_);
    }

    public String getHelpSearchIndex() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.searchIndex_;
    }

    public int getMaximumPositionalParameters() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.maxPosParms_;
    }

    public MessageFile getMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return new MessageFile(this.system_, this.messageFile_);
    }

    public byte getMultithreadedJobAction() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.multithreadedJobAction_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getProductLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.productLibrary_;
    }

    public MessageFile getPromptMessageFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        if (this.promptMessageFile_ != null) {
            return new MessageFile(this.system_, this.promptMessageFile_);
        }
        return null;
    }

    public String getPromptOverrideProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.promptOverrideProgram_;
    }

    public String getPromptOverrideState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.poState_;
    }

    public String getRestrictedRelease() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.restricted_;
    }

    public String getSourceFile() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.sourceFile_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public byte getThreadSafety() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.threadsafe_;
    }

    public String getValidityCheckProgram() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.validityCheckProgram_;
    }

    public String getValidityCheckState() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.vcState_;
    }

    public String getWhereAllowedToRun() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_;
    }

    public String getXML() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshedXML_) {
            this.refreshXML(true);
        }
        return this.xml_;
    }

    public String getXMLExtended() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshedXML2_) {
            this.refreshXML(false);
        }
        return this.xml2_;
    }

    public PanelGroupHelpIdentifier[] getXMLHelpIdentifiers() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedHelpIDs_) {
            this.refreshHelpIDs();
        }
        return this.helpIDs_;
    }

    public String getXMLProductLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedParsedXML_) {
            this.refreshParsedXML();
        }
        return this.xmlProductLibrary_;
    }

    public String getXMLPanelGroup() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedParsedXML_) {
            this.refreshParsedXML();
        }
        return this.xmlPanelGroup_;
    }

    public String getXMLHelpText() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (!this.refreshedHelpText_) {
            this.refreshHelpText(null);
        }
        return this.xmlHelpText_;
    }

    public synchronized String getXMLHelpText(PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (panelGroup == null) {
            throw new NullPointerException("panelGroup");
        }
        String string = this.xmlHelpText_;
        this.refreshHelpText(panelGroup);
        String string2 = this.xmlHelpText_;
        this.xmlHelpText_ = string;
        return string2;
    }

    private synchronized void refreshHelpText(PanelGroup panelGroup) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshHelpText(" + panelGroup + ").");
        }
        this.xmlHelpText_ = null;
        String string = panelGroup == null ? this.getXMLPanelGroup() : panelGroup.getPath();
        String string2 = this.getXMLProductLibrary();
        boolean bl = false;
        if (string != null) {
            String string3;
            String[] stringArray;
            Object object;
            if (string2 != null) {
                int n;
                string2 = string2.trim().toUpperCase();
                object = new Job(this.system_);
                stringArray = ((Job)object).getUserLibraryList();
                String[] stringArray2 = ((Job)object).getSystemLibraryList();
                string3 = ((Job)object).getCurrentLibrary();
                boolean bl2 = false;
                if (string3.trim().equalsIgnoreCase(string2)) {
                    bl2 = true;
                }
                for (n = 0; n < stringArray.length && !bl2; ++n) {
                    if (!stringArray[n].trim().equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                }
                for (n = 0; n < stringArray2.length && !bl2; ++n) {
                    if (!stringArray2[n].trim().equalsIgnoreCase(string2)) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    if (Trace.traceOn_) {
                        Trace.log(1, "Command.refreshHelpText: Adding " + string2 + " to library list.");
                    }
                    String string4 = "ADDLIBLE LIB(" + string2 + ")";
                    CommandCall commandCall = new CommandCall(this.system_, string4);
                    bl = commandCall.run();
                }
            }
            object = this.getXMLHelpIdentifiers();
            stringArray = new String[((PanelGroupHelpIdentifier[])object).length];
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringArray[i] = ((PanelGroupHelpIdentifier)object[i]).getName();
            }
            PanelGroup panelGroup2 = new PanelGroup(this.system_, string);
            this.xmlHelpText_ = string3 = panelGroup2.getHelpText(stringArray);
            if (bl) {
                if (Trace.traceOn_) {
                    Trace.log(1, "CommandHelpRetriever: Removing " + string2 + " from library list.");
                }
                String string5 = "RMVLIBLE LIB(" + string2 + ")";
                CommandCall commandCall = new CommandCall(this.system_, string5);
                commandCall.run();
            }
        }
        this.refreshedHelpText_ = true;
    }

    private synchronized void refreshParsedXML() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshParsedXML().");
        }
        this.xmlPanelGroup_ = null;
        this.xmlProductLibrary_ = null;
        String string = null;
        try {
            string = this.getXML();
            CommandHelpHandler commandHelpHandler = new CommandHelpHandler();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)commandHelpHandler);
            String string2 = commandHelpHandler.getPanelGroup();
            String string3 = commandHelpHandler.getProductLibrary();
            boolean bl = false;
            if (string2 != null) {
                this.xmlPanelGroup_ = string2.trim();
            }
            if (string3 != null && !string3.equalsIgnoreCase("__NONE")) {
                this.xmlProductLibrary_ = string3.trim();
            }
            this.refreshedParsedXML_ = true;
        }
        catch (SAXException sAXException) {
            if (Trace.traceOn_) {
                Trace.log(1, "Exception in Command.refreshParsedXML().");
                Trace.log(1, sAXException);
                Trace.log(1, "path is " + this.path_);
                Trace.log(1, "XML is " + string);
            }
            throw sAXException;
        }
    }

    private synchronized void refreshHelpIDs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        CommandCall commandCall;
        String[] stringArray;
        String[] stringArray2;
        Serializable serializable;
        if (Trace.traceOn_) {
            Trace.log(1, "Command.refreshHelpIDs().");
        }
        this.helpIDs_ = null;
        String string = this.getXML();
        CommandHelpHandler commandHelpHandler = new CommandHelpHandler();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new InputSource(new StringReader(string)), (DefaultHandler)commandHelpHandler);
        boolean bl = false;
        String string2 = this.getXMLProductLibrary();
        if (string2 != null) {
            int n;
            serializable = new Job(this.system_);
            stringArray2 = ((Job)serializable).getUserLibraryList();
            stringArray = ((Job)serializable).getSystemLibraryList();
            String string3 = ((Job)serializable).getCurrentLibrary();
            boolean bl2 = false;
            if (string3.trim().equalsIgnoreCase(string2)) {
                bl2 = true;
            }
            for (n = 0; n < stringArray2.length && !bl2; ++n) {
                if (!stringArray2[n].trim().equalsIgnoreCase(string2)) continue;
                bl2 = true;
            }
            for (n = 0; n < stringArray.length && !bl2; ++n) {
                if (!stringArray[n].trim().equalsIgnoreCase(string2)) continue;
                bl2 = true;
            }
            if (!bl2) {
                if (Trace.traceOn_) {
                    Trace.log(1, "Command.refreshHelpIDs: Adding " + string2 + " to library list.");
                }
                String string4 = "ADDLIBLE LIB(" + string2 + ")";
                commandCall = new CommandCall(this.system_, string4);
                bl = commandCall.run();
            }
        }
        serializable = commandHelpHandler.getKeywords();
        stringArray2 = commandHelpHandler.getHelpID();
        stringArray = new String[((Vector)serializable).size() + 3];
        stringArray[0] = stringArray2;
        stringArray[1] = (String)stringArray2 + "/ERROR/MESSAGES";
        stringArray[2] = (String)stringArray2 + "/COMMAND/EXAMPLES";
        for (int i = 3; i < stringArray.length; ++i) {
            stringArray[i] = (String)stringArray2 + "/" + ((Vector)serializable).elementAt(i - 3);
        }
        String string5 = this.getXMLPanelGroup();
        PanelGroup panelGroup = new PanelGroup(this.system_, string5);
        this.helpIDs_ = panelGroup.getHelpIdentifiers(stringArray);
        if (bl) {
            if (Trace.traceOn_) {
                Trace.log(1, "CommandHelpRetriever: Removing " + string2 + " from library list.");
            }
            String string6 = "RMVLIBLE LIB(" + this.xmlProductLibrary_ + ")";
            commandCall = new CommandCall(this.system_, string6);
            commandCall.run();
        }
        this.refreshedHelpIDs_ = true;
    }

    public boolean isAllowedToRun(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        switch (n) {
            case 0: {
                return this.whereAllowedToRun_.charAt(0) == '1';
            }
            case 1: {
                return this.whereAllowedToRun_.charAt(1) == '1';
            }
            case 2: {
                return this.whereAllowedToRun_.charAt(2) == '1';
            }
            case 3: {
                return this.whereAllowedToRun_.charAt(3) == '1';
            }
            case 4: {
                return this.whereAllowedToRun_.charAt(4) == '1';
            }
            case 5: {
                return this.whereAllowedToRun_.charAt(5) == '1';
            }
            case 6: {
                return this.whereAllowedToRun_.charAt(6) == '1';
            }
            case 7: {
                return this.whereAllowedToRun_.startsWith("1111111");
            }
        }
        throw new ExtendedIllegalArgumentException("environment", 2);
    }

    public boolean isAllowedToRunBatch() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_.charAt(0) == '1' || this.whereAllowedToRun_.charAt(4) == '1' || this.whereAllowedToRun_.charAt(5) == '1';
    }

    public boolean isAllowedToRunInteractive() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.whereAllowedToRun_.charAt(1) == '1' || this.whereAllowedToRun_.charAt(3) == '1' || this.whereAllowedToRun_.charAt(6) == '1';
    }

    public boolean isEnabledForGUI() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        return this.guiEnabled_;
    }

    public boolean isOperatingMode(int n) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        if (!this.refreshed_) {
            this.refreshCommandInfo();
        }
        switch (n) {
            case 10: {
                return this.mode_.charAt(0) == '1';
            }
            case 11: {
                return this.mode_.charAt(1) == '1';
            }
            case 12: {
                return this.mode_.charAt(2) == '1';
            }
            case 13: {
                return this.mode_.startsWith("111");
            }
        }
        throw new ExtendedIllegalArgumentException("mode", 2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }

    public synchronized void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException, SAXException, ParserConfigurationException {
        this.refreshCommandInfo();
        this.refreshXML(true);
        this.refreshParsedXML();
        this.refreshHelpIDs();
    }

    private synchronized void refreshCommandInfo() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        ProgramParameter[] programParameterArray;
        Object[] objectArray;
        ProgramCall programCall;
        boolean bl;
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing command information for " + this.path_ + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        int n = this.system_.getVRM();
        int n2 = n >= 393472 || n >= 328704 && !this.detectedMissingPTF_ ? 6 : 5;
        ProgramParameter[] programParameterArray2 = new ProgramParameter[n2];
        programParameterArray2[0] = new ProgramParameter(335);
        programParameterArray2[1] = new ProgramParameter(BinaryConverter.intToByteArray(335));
        programParameterArray2[2] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, "CMDI0100"));
        byte[] byArray = new byte[20];
        AS400Text aS400Text = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
        String string6 = qSYSObjectPathName.getObjectName();
        String string7 = qSYSObjectPathName.getLibraryName();
        aS400Text.toBytes(string6, byArray, 0);
        aS400Text.toBytes(string7, byArray, 10);
        programParameterArray2[3] = new ProgramParameter(byArray);
        programParameterArray2[4] = errorCode_;
        if (n2 > 5) {
            programParameterArray2[5] = new ProgramParameter(new byte[]{-15});
        }
        if (!(bl = (programCall = new ProgramCall(this.system_, "/QSYS.LIB/QCDRCMDI.PGM", programParameterArray2)).run())) {
            objectArray = programCall.getMessageList();
            if (n2 > 5 && n < 393472 && n >= 328704 && objectArray[objectArray.length - 1].getID().equals("MCH0802")) {
                if (Trace.traceOn_) {
                    Trace.log(4, "PTF SI29629 is not installed: (MCH0802) " + objectArray[objectArray.length - 1].getText());
                }
                this.detectedMissingPTF_ = true;
                programParameterArray = new ProgramParameter[5];
                System.arraycopy(programParameterArray2, 0, programParameterArray, 0, 5);
                try {
                    programCall.setParameterList(programParameterArray);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                bl = programCall.run();
            }
            if (!bl) {
                throw new AS400Exception(programCall.getMessageList());
            }
        }
        objectArray = programParameterArray2[0].getOutputData();
        programParameterArray = new CharConverter(this.system_.getCcsid());
        String string8 = programParameterArray.byteArrayToString((byte[])objectArray, 28, 10).trim();
        if (string8.equals("*REXX")) {
            this.commandProcessingProgram_ = string8;
        } else {
            string5 = programParameterArray.byteArrayToString((byte[])objectArray, 38, 10).trim();
            this.commandProcessingProgram_ = QSYSObjectPathName.toPath(string5, string8, "PGM");
        }
        string5 = programParameterArray.byteArrayToString((byte[])objectArray, 48, 10).trim();
        String string9 = programParameterArray.byteArrayToString((byte[])objectArray, 58, 10).trim();
        String string10 = programParameterArray.byteArrayToString((byte[])objectArray, 68, 10).trim();
        try {
            this.sourceFile_ = QSYSObjectPathName.toPath(string9, string5, string10, "MBR");
        }
        catch (ExtendedIllegalArgumentException extendedIllegalArgumentException) {
            if (Trace.traceOn_) {
                Trace.log(4, "Unable to process source file: '" + string5 + "," + string9 + "," + string10 + "'.", (Throwable)extendedIllegalArgumentException);
            }
            this.sourceFile_ = null;
        }
        String string11 = programParameterArray.byteArrayToString((byte[])objectArray, 78, 10).trim();
        if (string11.equals("*NONE")) {
            this.validityCheckProgram_ = string11;
        } else {
            string4 = programParameterArray.byteArrayToString((byte[])objectArray, 88, 10).trim();
            this.validityCheckProgram_ = QSYSObjectPathName.toPath(string4, string11, "PGM");
        }
        this.mode_ = programParameterArray.byteArrayToString((byte[])objectArray, 98, 10);
        this.whereAllowedToRun_ = programParameterArray.byteArrayToString((byte[])objectArray, 108, 15);
        this.allowLimitedUser_ = objectArray[123] == -15;
        this.maxPosParms_ = BinaryConverter.byteArrayToInt((byte[])objectArray, 124);
        string4 = programParameterArray.byteArrayToString((byte[])objectArray, 128, 10).trim();
        if (string4.equals("*NONE")) {
            this.promptMessageFile_ = null;
        } else {
            string3 = programParameterArray.byteArrayToString((byte[])objectArray, 138, 10).trim();
            this.promptMessageFile_ = QSYSObjectPathName.toPath(string3, string4, "MSGF");
        }
        string3 = programParameterArray.byteArrayToString((byte[])objectArray, 148, 10).trim();
        String string12 = programParameterArray.byteArrayToString((byte[])objectArray, 158, 10).trim();
        this.messageFile_ = QSYSObjectPathName.toPath(string12, string3, "MSGF");
        String string13 = programParameterArray.byteArrayToString((byte[])objectArray, 168, 10).trim();
        if (string13.equals("*NONE")) {
            this.helpPanelGroup_ = string13;
        } else {
            string2 = programParameterArray.byteArrayToString((byte[])objectArray, 178, 10).trim();
            this.helpPanelGroup_ = QSYSObjectPathName.toPath(string2, string13, "PNLGRP");
        }
        this.helpIdentifier_ = programParameterArray.byteArrayToString((byte[])objectArray, 188, 10).trim();
        string2 = programParameterArray.byteArrayToString((byte[])objectArray, 198, 10).trim();
        if (string2.equals("*NONE")) {
            this.searchIndex_ = string2;
        } else {
            string = programParameterArray.byteArrayToString((byte[])objectArray, 208, 10).trim();
            this.searchIndex_ = QSYSObjectPathName.toPath(string, string2, "SCHIDX");
        }
        this.currentLibrary_ = programParameterArray.byteArrayToString((byte[])objectArray, 218, 10).trim();
        this.productLibrary_ = programParameterArray.byteArrayToString((byte[])objectArray, 228, 10).trim();
        string = programParameterArray.byteArrayToString((byte[])objectArray, 238, 10).trim();
        if (string.equals("*NONE")) {
            this.promptOverrideProgram_ = string;
        } else {
            String string14 = programParameterArray.byteArrayToString((byte[])objectArray, 248, 10).trim();
            this.promptOverrideProgram_ = QSYSObjectPathName.toPath(string14, string, "PGM");
        }
        this.restricted_ = programParameterArray.byteArrayToString((byte[])objectArray, 258, 6).trim();
        this.description_ = programParameterArray.byteArrayToString((byte[])objectArray, 264, 50).trim();
        this.cppState_ = programParameterArray.byteArrayToString((byte[])objectArray, 314, 2);
        this.vcState_ = programParameterArray.byteArrayToString((byte[])objectArray, 316, 2);
        this.poState_ = programParameterArray.byteArrayToString((byte[])objectArray, 318, 2);
        this.ccsid_ = BinaryConverter.byteArrayToInt((byte[])objectArray, 328);
        this.guiEnabled_ = objectArray[332] == -15;
        this.threadsafe_ = (byte)objectArray[333];
        this.multithreadedJobAction_ = (byte)objectArray[334];
        this.refreshed_ = true;
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully refreshed command information for " + this.path_ + ".");
        }
    }

    private synchronized void refreshXML(boolean bl) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        String string;
        String string2 = string = bl ? "CMDD0100" : "CMDD0200";
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing XML (format " + string + ") information for " + this.path_ + ".");
        }
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.path_ == null) {
            throw new ExtendedIllegalStateException("path", 4);
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[6];
        byte[] byArray = new byte[20];
        AS400Text aS400Text = new AS400Text(10, this.system_.getCcsid());
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(this.path_);
        String string3 = qSYSObjectPathName.getObjectName().trim().toUpperCase();
        String string4 = qSYSObjectPathName.getLibraryName().trim().toUpperCase();
        aS400Text.toBytes(string3, byArray, 0);
        aS400Text.toBytes(string4, byArray, 10);
        programParameterArray[0] = new ProgramParameter(byArray);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(8));
        programParameterArray[2] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, "DEST0100"));
        programParameterArray[3] = new ProgramParameter(8);
        programParameterArray[4] = new ProgramParameter(CharConverter.stringToByteArray(37, this.system_, string));
        programParameterArray[5] = errorCode_;
        ProgramCall programCall = new ProgramCall(this.system_, "/QSYS.LIB/QCDRCMDD.PGM", programParameterArray);
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byte[] byArray2 = programParameterArray[3].getOutputData();
        int n = BinaryConverter.byteArrayToInt(byArray2, 0);
        int n2 = BinaryConverter.byteArrayToInt(byArray2, 4);
        if (Trace.traceOn_) {
            Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned bytesAvailable=" + n2);
        }
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2 + 8));
        try {
            programParameterArray[3].setOutputDataLength(n2 + 8);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        if (!programCall.run()) {
            throw new AS400Exception(programCall.getMessageList());
        }
        byArray2 = programParameterArray[3].getOutputData();
        n = BinaryConverter.byteArrayToInt(byArray2, 0);
        ConvTable convTable = ConvTable.getTable(1208, null);
        if (bl) {
            this.xml_ = convTable.byteArrayToString(byArray2, 8, n, 0);
            this.refreshedXML_ = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned data=" + this.xml_);
            }
        } else {
            this.xml2_ = convTable.byteArrayToString(byArray2, 8, n, 0);
            this.refreshedXML2_ = true;
            if (Trace.traceOn_) {
                Trace.log(1, "Refreshing XML /QSYS.LIB/QCDRCMDD.PGM returned data=" + this.xml2_);
            }
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Successfully refreshed XML (format " + string + ") information for " + this.path_ + ".");
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String string) {
        if (string == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName.validatePath(string, "CMD");
        Command command = this;
        synchronized (command) {
            String string2 = this.path_;
            this.path_ = string;
            this.refreshed_ = false;
            this.refreshedXML_ = false;
            this.refreshedXML2_ = false;
            this.refreshedHelpIDs_ = false;
            this.refreshedHelpText_ = false;
            this.refreshedParsedXML_ = false;
            this.loadedDescription_ = false;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("path", string2, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystem(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        Command command = this;
        synchronized (command) {
            AS400 aS4002 = this.system_;
            this.system_ = aS400;
            this.refreshed_ = false;
            this.refreshedXML_ = false;
            this.refreshedXML2_ = false;
            this.refreshedHelpIDs_ = false;
            this.refreshedHelpText_ = false;
            this.refreshedParsedXML_ = false;
            this.loadedDescription_ = false;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("system", aS4002, aS400);
            }
        }
    }

    public String toString() {
        return super.toString() + "[" + this.path_ + "]";
    }
}

