/*
 * Decompiled with CFR 0.152.
 */
package com.api.jsonata4java.expressions.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public class BooleanUtils {
    public static boolean convertJsonNodeToBoolean(JsonNode node) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case BOOLEAN: {
                return node.asBoolean();
            }
            case STRING: {
                return !node.asText().isEmpty();
            }
            case NUMBER: {
                Double number = node.doubleValue();
                if (!number.isNaN() && !number.isInfinite()) {
                    if (number - (double)number.longValue() == 0.0) {
                        return node.asLong() != 0L;
                    }
                    return node.asDouble() != 0.0;
                }
                return false;
            }
            case NULL: {
                return false;
            }
            case BINARY: {
                return node.asBoolean();
            }
            case ARRAY: {
                for (JsonNode e : node) {
                    if (!BooleanUtils.convertJsonNodeToBoolean(e)) continue;
                    return true;
                }
                return false;
            }
            case OBJECT: {
                return ((ObjectNode)node).elements().hasNext();
            }
            case MISSING: {
                return false;
            }
            case POJO: {
                return false;
            }
        }
        return false;
    }
}

