/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jsonata;

import com.api.jsonata4java.expressions.Expressions;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.ResourceEndpoint;
import org.apache.camel.component.jsonata.JsonataComponent;
import org.apache.camel.component.jsonata.JsonataInputOutputType;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.5.0", scheme="jsonata", title="JSONata", syntax="jsonata:resourceUri", producerOnly=true, category={Category.TRANSFORMATION})
public class JsonataEndpoint
extends ResourceEndpoint {
    private Expressions expressions;
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType outputType;
    @UriParam(defaultValue="Jackson")
    private JsonataInputOutputType inputType;

    public JsonataEndpoint() {
    }

    public JsonataEndpoint(String uri, JsonataComponent component, String resourceUri) {
        super(uri, (Component)component, resourceUri);
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOut;
    }

    protected String createEndpointUri() {
        return "Jsonata:" + this.getResourceUri();
    }

    public JsonataInputOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(JsonataInputOutputType outputType) {
        this.outputType = outputType;
    }

    public JsonataInputOutputType getInputType() {
        return this.inputType;
    }

    public void setInputType(JsonataInputOutputType inputType) {
        this.inputType = inputType;
    }

    protected void onExchange(Exchange exchange) throws Exception {
        String path = this.getResourceUri();
        ObjectHelper.notNull((Object)path, (String)"resourceUri");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode input = this.getInputType() == JsonataInputOutputType.JsonString ? mapper.readTree((InputStream)exchange.getIn().getBody(InputStream.class)) : (JsonNode)exchange.getIn().getBody();
        JsonNode output = null;
        if (this.expressions == null) {
            String spec = new BufferedReader(new InputStreamReader(this.getResourceAsInputStream(), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            this.expressions = Expressions.parse((String)spec);
        }
        output = this.expressions.evaluate(input);
        Message out = exchange.getMessage();
        if (this.getOutputType() == JsonataInputOutputType.JsonString) {
            out.setBody((Object)output.toString());
        } else {
            out.setBody((Object)output);
        }
        out.setHeaders(exchange.getIn().getHeaders());
    }
}

