/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.impl.health.HealthCheckRegistryRepository;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="health-check-registry")
@DeferredContextBinding
public class DefaultHealthCheckRegistry
extends ServiceSupport
implements HealthCheckRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHealthCheckRegistry.class);
    private String id = "camel-health";
    private final Set<HealthCheck> checks = new CopyOnWriteArraySet<HealthCheck>();
    private final Set<HealthCheckRepository> repositories = new CopyOnWriteArraySet<HealthCheckRepository>();
    private CamelContext camelContext;
    private boolean enabled = true;

    public DefaultHealthCheckRegistry() {
        this(null);
    }

    public DefaultHealthCheckRegistry(CamelContext camelContext) {
        this.repositories.add(new HealthCheckRegistryRepository());
        this.setCamelContext(camelContext);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected void doInit() throws Exception {
        super.doInit();
        for (HealthCheck check : this.checks) {
            if (!(check instanceof CamelContextAware)) continue;
            ((CamelContextAware)check).setCamelContext(this.camelContext);
        }
        for (HealthCheckRepository repository : this.repositories) {
            if (!(repository instanceof CamelContextAware)) continue;
            ((CamelContextAware)repository).setCamelContext(this.camelContext);
        }
    }

    public final void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public final CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object resolveById(String id) {
        HealthCheck answer = this.resolveHealthCheckById(id);
        if (answer == null) {
            answer = this.resolveHealthCheckRepositoryById(id);
        }
        if (answer instanceof CamelContextAware) {
            ((CamelContextAware)answer).setCamelContext(this.camelContext);
        }
        return answer;
    }

    private HealthCheck resolveHealthCheckById(String id) {
        HealthCheck answer = this.checks.stream().filter(h -> h.getId().equals(id)).findFirst().orElse((HealthCheck)this.camelContext.getRegistry().findByTypeWithName(HealthCheck.class).get(id));
        if (answer == null) {
            FactoryFinder ff = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDefaultFactoryFinder();
            Class clazz = ff.findOptionalClass(id + "-health-check").orElse(null);
            if (clazz == null) {
                clazz = ff.findOptionalClass(id).orElse(null);
            }
            if (clazz != null) {
                answer = (HealthCheck)this.camelContext.getInjector().newInstance(clazz);
            }
        }
        return answer;
    }

    private HealthCheckRepository resolveHealthCheckRepositoryById(String id) {
        HealthCheckRepository answer = this.repositories.stream().filter(h -> h.getId().equals(id)).findFirst().orElse((HealthCheckRepository)this.camelContext.getRegistry().findByTypeWithName(HealthCheckRepository.class).get(id));
        if (answer == null) {
            FactoryFinder ff = ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getDefaultFactoryFinder();
            Class clazz = ff.findOptionalClass(id + "-health-check-repository").orElse(null);
            if (clazz == null) {
                clazz = ff.findOptionalClass(id).orElse(null);
            }
            if (clazz != null) {
                answer = (HealthCheckRepository)this.camelContext.getInjector().newInstance(clazz);
            }
        }
        return answer;
    }

    public boolean register(Object obj) {
        boolean accept;
        boolean bl = accept = obj instanceof HealthCheck || obj instanceof HealthCheckRepository;
        if (!accept) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof HealthCheck) {
            HealthCheck healthCheck = (HealthCheck)obj;
            if (this.getCheck(healthCheck.getId()).isPresent()) {
                return false;
            }
            boolean result = this.checks.add(healthCheck);
            if (result) {
                if (obj instanceof CamelContextAware) {
                    ((CamelContextAware)obj).setCamelContext(this.camelContext);
                }
                LOG.debug("HealthCheck with id {} successfully registered", (Object)healthCheck.getId());
            }
            return result;
        }
        HealthCheckRepository repository = (HealthCheckRepository)obj;
        if (this.getRepository(repository.getId()).isPresent()) {
            return false;
        }
        boolean result = this.repositories.add(repository);
        if (result) {
            if (repository instanceof CamelContextAware) {
                ((CamelContextAware)repository).setCamelContext(this.camelContext);
            }
            LOG.debug("HealthCheckRepository with id {} successfully registered", (Object)repository.getId());
        }
        return result;
    }

    public boolean unregister(Object obj) {
        boolean accept;
        boolean bl = accept = obj instanceof HealthCheck || obj instanceof HealthCheckRepository;
        if (!accept) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof HealthCheck) {
            HealthCheck healthCheck = (HealthCheck)obj;
            boolean result = this.checks.remove(healthCheck);
            if (result) {
                LOG.debug("HealthCheck with id {} successfully un-registered", (Object)healthCheck.getId());
            }
            return result;
        }
        HealthCheckRepository repository = (HealthCheckRepository)obj;
        boolean result = this.repositories.remove(repository);
        if (result) {
            LOG.debug("HealthCheckRepository with id {} successfully un-registered", (Object)repository.getId());
        }
        return result;
    }

    public Optional<HealthCheckRepository> getRepository(String id) {
        return this.repositories.stream().filter(r -> ObjectHelper.equal((Object)r.getId(), (Object)id) || ObjectHelper.equal((Object)r.getId().replace("-health-check-repository", ""), (Object)id)).findFirst();
    }

    public Stream<HealthCheck> stream() {
        if (this.enabled) {
            return Stream.concat(this.checks.stream(), this.repositories.stream().flatMap(HealthCheckRepository::stream)).distinct();
        }
        return Stream.empty();
    }
}

