/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Collection;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.XML;
import org.jooq.XMLAttributes;
import org.jooq.impl.AbstractField;
import org.jooq.impl.Keywords;
import org.jooq.impl.Names;
import org.jooq.impl.QueryPartList;
import org.jooq.impl.SQLDataType;
import org.jooq.impl.Tools;
import org.jooq.impl.XMLAttributesImpl;

final class XMLElement
extends AbstractField<XML> {
    private static final long serialVersionUID = 4505809303211506197L;
    private final Name elementName;
    private final XMLAttributes attributes;
    private final QueryPartList<Field<?>> content;

    XMLElement(Name elementName, XMLAttributes attributes, Collection<? extends Field<?>> content) {
        super(Names.N_XMLCONCAT, SQLDataType.XML);
        this.elementName = elementName;
        this.attributes = attributes;
        this.content = new QueryPartList((Iterable<Field<?>>)content);
    }

    @Override
    public final void accept(Context<?> ctx) {
        boolean hasAttributes = this.attributes != null && !((XMLAttributesImpl)this.attributes).attributes.isEmpty();
        boolean hasContent = !this.content.isEmpty();
        boolean format = hasAttributes || hasContent;
        Object previous = ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED);
        ctx.visit(Names.N_XMLELEMENT).sql('(');
        if (format) {
            ctx.formatIndentStart().formatNewLine();
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, true);
        }
        ctx.visit(Keywords.K_NAME).sql(' ').visit(this.elementName);
        if (hasAttributes) {
            if (format) {
                ctx.sql(',').formatSeparator().visit(this.attributes);
            } else {
                ctx.sql(", ").visit(this.attributes);
            }
        }
        if (hasContent) {
            if (format) {
                ctx.sql(',').formatSeparator().visit(this.content);
            } else {
                ctx.sql(", ").visit(this.content);
            }
        }
        if (format) {
            ctx.formatIndentEnd().formatNewLine();
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, previous);
        }
        ctx.sql(')');
    }
}

