/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Clause;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.DropTableStep;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.Cascade;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class DropTableImpl
extends AbstractRowCountQuery
implements DropTableStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_TABLE};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> TEMPORARY_SEMANTIC = SQLDialect.supportedBy(SQLDialect.MYSQL);
    private final Table<?> table;
    private final boolean temporary;
    private final boolean ifExists;
    private Cascade cascade;

    DropTableImpl(Configuration configuration, Table<?> table) {
        this(configuration, table, false, false);
    }

    DropTableImpl(Configuration configuration, Table<?> table, boolean ifExists) {
        this(configuration, table, ifExists, false);
    }

    DropTableImpl(Configuration configuration, Table<?> table, boolean ifExists, boolean temporary) {
        super(configuration);
        this.table = table;
        this.ifExists = ifExists;
        this.temporary = temporary;
    }

    final Table<?> $table() {
        return this.table;
    }

    final boolean $temporary() {
        return this.temporary;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final DropTableImpl cascade() {
        this.cascade = Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropTableImpl restrict() {
        this.cascade = Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.DROP_TABLE);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.DROP_TABLE);
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_TABLE_TABLE);
        if (this.temporary && TEMPORARY_SEMANTIC.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_TEMPORARY).sql(' ').visit(Keywords.K_TABLE).sql(' ');
        } else {
            ctx.visit(Keywords.K_DROP_TABLE).sql(' ');
        }
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.table);
        if (this.cascade == Cascade.CASCADE) {
            ctx.sql(' ').visit(Keywords.K_CASCADE);
        } else if (this.cascade == Cascade.RESTRICT) {
            ctx.sql(' ').visit(Keywords.K_RESTRICT);
        }
        ctx.end(Clause.DROP_TABLE_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

