/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.jmx;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelJmxSourceConnectorConfig extends CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_JMX_PATH_SERVER_URLCONF = "camel.source.path.serverURL";
    public static final String CAMEL_SOURCE_JMX_PATH_SERVER_URLDOC = "Server url comes from the remaining endpoint. Use platform to connect to local JVM.";
    public static final String CAMEL_SOURCE_JMX_PATH_SERVER_URLDEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_CONF = "camel.source.endpoint.format";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_DOC = "Format for the message body. Either xml or raw. If xml, the notification is serialized to xml. If raw, then the raw java object is set as the body. One of: [xml] [raw]";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_DEFAULT = "xml";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_CONF = "camel.source.endpoint.granularityPeriod";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_DOC = "The frequency to poll the bean to check the monitor (monitor types only).";
    public static final Long CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_DEFAULT = 10000L;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_CONF = "camel.source.endpoint.monitorType";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_DOC = "The type of monitor to create. One of string, gauge, counter (monitor types only). One of: [counter] [gauge] [string]";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_CONF = "camel.source.endpoint.objectDomain";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_DOC = "The domain for the mbean you're connecting to";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_CONF = "camel.source.endpoint.objectName";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_DOC = "The name key for the mbean you're connecting to. This value is mutually exclusive with the object properties that get passed.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_CONF = "camel.source.endpoint.observedAttribute";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_DOC = "The attribute to observe for the monitor bean or consumer.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_CONF = "camel.source.endpoint.executorService";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_DOC = "To use a custom shared thread pool for the consumers. By default each consume has their own thread-pool to process and route notifications.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_CONF = "camel.source.endpoint.handback";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_DOC = "Value to handback to the listener when a notification is received. This value will be put in the message header with the key jmx.handback";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_CONF = "camel.source.endpoint.notificationFilter";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_DOC = "Reference to a bean that implements the NotificationFilter.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_CONF = "camel.source.endpoint.objectProperties";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_DOC = "Properties for the object name. These values will be used if the objectName param is not set";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_CONF = "camel.source.endpoint.reconnectDelay";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_DOC = "The number of seconds to wait before attempting to retry establishment of the initial connection or attempt to reconnect a lost connection";
    public static final Integer CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_DEFAULT = 10;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_CONF = "camel.source.endpoint.reconnectOnConnectionFailure";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_DOC = "If true the consumer will attempt to reconnect to the JMX server when any connection failure occurs. The consumer will attempt to re-establish the JMX connection every 'x' seconds until the connection is made-- where 'x' is the configured reconnectionDelay";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF = "camel.source.endpoint.testConnectionOnStartup";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC = "If true the consumer will throw an exception if unable to establish the JMX connection upon startup. If false, the consumer will attempt to establish the JMX connection every 'x' seconds until the connection is made -- where 'x' is the configured reconnectionDelay";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT = true;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_CONF = "camel.source.endpoint.initThreshold";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_DOC = "Initial threshold for the monitor. The value must exceed this before notifications are fired (counter monitor only).";
    public static final Integer CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_CONF = "camel.source.endpoint.modulus";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_DOC = "The value at which the counter is reset to zero (counter monitor only).";
    public static final Integer CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_CONF = "camel.source.endpoint.offset";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_DOC = "The amount to increment the threshold after it's been exceeded (counter monitor only).";
    public static final Integer CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_CONF = "camel.source.endpoint.differenceMode";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_DOC = "If true, then the value reported in the notification is the difference from the threshold as opposed to the value itself (counter and gauge monitor only).";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_CONF = "camel.source.endpoint.notifyHigh";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_DOC = "If true, the gauge will fire a notification when the high threshold is exceeded (gauge monitor only).";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_CONF = "camel.source.endpoint.notifyLow";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_DOC = "If true, the gauge will fire a notification when the low threshold is exceeded (gauge monitor only).";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_CONF = "camel.source.endpoint.thresholdHigh";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_DOC = "Value for the gauge's high threshold (gauge monitor only).";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_CONF = "camel.source.endpoint.thresholdLow";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_DOC = "Value for the gauge's low threshold (gauge monitor only).";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_DOC = "Credentials for making a remote connection";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_USER_CONF = "camel.source.endpoint.user";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_USER_DOC = "Credentials for making a remote connection";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_USER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_CONF = "camel.source.endpoint.notifyDiffer";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_DOC = "If true, will fire a notification when the string attribute differs from the string to compare (string monitor or consumer). By default the consumer will notify match if observed attribute and string to compare has been configured.";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_CONF = "camel.source.endpoint.notifyMatch";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_DOC = "If true, will fire a notification when the string attribute matches the string to compare (string monitor or consumer). By default the consumer will notify match if observed attribute and string to compare has been configured.";
    public static final Boolean CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_CONF = "camel.source.endpoint.stringToCompare";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_DOC = "Value for attribute to compare (string monitor or consumer). By default the consumer will notify match if observed attribute and string to compare has been configured.";
    public static final String CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.jmx.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.jmx.autowiredEnabled";
    public static final String CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;

    public CamelJmxSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelJmxSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_JMX_PATH_SERVER_URLCONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_PATH_SERVER_URLDEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_PATH_SERVER_URLDOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_FORMAT_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_CONF, ConfigDef.Type.LONG, CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_GRANULARITY_PERIOD_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_MONITOR_TYPE_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_DOMAIN_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_NAME_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_OBSERVED_ATTRIBUTE_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_EXECUTOR_SERVICE_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_HANDBACK_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFICATION_FILTER_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_OBJECT_PROPERTIES_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_RECONNECT_ON_CONNECTION_FAILURE_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_TEST_CONNECTION_ON_STARTUP_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_INIT_THRESHOLD_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_MODULUS_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_OFFSET_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_DIFFERENCE_MODE_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_HIGH_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_LOW_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_HIGH_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_THRESHOLD_LOW_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_USER_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JMX_ENDPOINT_USER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_USER_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_DIFFER_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_NOTIFY_MATCH_DOC);
        conf.define(CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_ENDPOINT_STRING_TO_COMPARE_DOC);
        conf.define(CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JMX_COMPONENT_AUTOWIRED_ENABLED_DOC);
        return conf;
    }
}