/*
 * Decompiled with CFR 0.152.
 */
package com.github.luben.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDictDecompress;
import com.github.luben.zstd.util.Native;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ZstdDirectBufferDecompressingStream
implements Closeable {
    private ByteBuffer source;
    private final long stream;
    private boolean finishedFrame = false;
    private boolean closed = false;
    private boolean streamEnd = false;
    private boolean finalize = true;
    private int consumed;
    private int produced;

    protected ByteBuffer refill(ByteBuffer byteBuffer) {
        return byteBuffer;
    }

    private static native int recommendedDOutSize();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private native int initDStream(long var1);

    private native long decompressStream(long var1, ByteBuffer var3, int var4, int var5, ByteBuffer var6, int var7, int var8);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZstdDirectBufferDecompressingStream(ByteBuffer byteBuffer) {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Source buffer should be a direct buffer");
        }
        ZstdDirectBufferDecompressingStream zstdDirectBufferDecompressingStream = this;
        synchronized (zstdDirectBufferDecompressingStream) {
            this.source = byteBuffer;
            this.stream = ZstdDirectBufferDecompressingStream.createDStream();
            this.initDStream(this.stream);
        }
    }

    public void setFinalize(boolean bl) {
        this.finalize = bl;
    }

    public synchronized boolean hasRemaining() {
        return !this.streamEnd && (this.source.hasRemaining() || !this.finishedFrame);
    }

    public static int recommendedTargetBufferSize() {
        return ZstdDirectBufferDecompressingStream.recommendedDOutSize();
    }

    public synchronized ZstdDirectBufferDecompressingStream setDict(byte[] byArray) throws IOException {
        int n = Zstd.loadDictDecompress(this.stream, byArray, byArray.length);
        if (Zstd.isError(n)) {
            throw new IOException("Decompression error: " + Zstd.getErrorName(n));
        }
        return this;
    }

    public synchronized ZstdDirectBufferDecompressingStream setDict(ZstdDictDecompress zstdDictDecompress) throws IOException {
        zstdDictDecompress.acquireSharedLock();
        try {
            int n = Zstd.loadFastDictDecompress(this.stream, zstdDictDecompress);
            if (Zstd.isError(n)) {
                throw new IOException("Decompression error: " + Zstd.getErrorName(n));
            }
        }
        finally {
            zstdDictDecompress.releaseSharedLock();
        }
        return this;
    }

    public synchronized int read(ByteBuffer byteBuffer) throws IOException {
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("Target buffer should be a direct buffer");
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        if (this.streamEnd) {
            return 0;
        }
        long l = this.decompressStream(this.stream, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), this.source, this.source.position(), this.source.remaining());
        if (Zstd.isError(l)) {
            throw new IOException(Zstd.getErrorName(l));
        }
        this.source.position(this.source.position() + this.consumed);
        byteBuffer.position(byteBuffer.position() + this.produced);
        if (!this.source.hasRemaining()) {
            this.source = this.refill(this.source);
            if (!this.source.isDirect()) {
                throw new IllegalArgumentException("Source buffer should be a direct buffer");
            }
        }
        boolean bl = this.finishedFrame = l == 0L;
        if (this.finishedFrame) {
            this.streamEnd = !this.source.hasRemaining();
        }
        return this.produced;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.closed) {
            try {
                ZstdDirectBufferDecompressingStream.freeDStream(this.stream);
            }
            finally {
                this.closed = true;
                this.source = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.finalize) {
            this.close();
        }
    }

    static {
        Native.load();
    }
}

