/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.schema.validation;

import com.worldturner.medeia.parser.JsonTokenData;
import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/worldturner/medeia/schema/validation/MultiNumber;", "", "bigDecimalValue", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getBigDecimalValue", "()Ljava/math/BigDecimal;", "bigIntegerValue", "Ljava/math/BigInteger;", "getBigIntegerValue", "()Ljava/math/BigInteger;", "longValue", "", "getLongValue", "()Ljava/lang/Long;", "Ljava/lang/Long;", "compareTo", "", "token", "Lcom/worldturner/medeia/parser/JsonTokenData;", "isMultiple", "", "toString", "", "medeia-validator-core"})
public final class MultiNumber {
    @Nullable
    private final Long longValue;
    @Nullable
    private final BigInteger bigIntegerValue;
    @NotNull
    private final BigDecimal bigDecimalValue;

    @Nullable
    public final Long getLongValue() {
        return this.longValue;
    }

    @Nullable
    public final BigInteger getBigIntegerValue() {
        return this.bigIntegerValue;
    }

    public final boolean isMultiple(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        if (token.hasLongValue() && this.longValue != null) {
            return token.getLongValue() % this.longValue == 0L;
        }
        if (token.getInteger() != null && this.bigIntegerValue != null) {
            BigInteger bigInteger = token.getInteger();
            BigInteger bigInteger2 = this.bigIntegerValue;
            BigInteger bigInteger3 = bigInteger.remainder(bigInteger2);
            Intrinsics.checkExpressionValueIsNotNull((Object)bigInteger3, (String)"this.remainder(other)");
            return Intrinsics.areEqual((Object)bigInteger3, (Object)BigInteger.ZERO);
        }
        BigDecimal bigDecimal = token.toDecimal();
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal, (String)"token.toDecimal()");
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = this.bigDecimalValue;
        BigDecimal bigDecimal4 = bigDecimal2.remainder(bigDecimal3);
        Intrinsics.checkExpressionValueIsNotNull((Object)bigDecimal4, (String)"this.remainder(other)");
        return bigDecimal4.compareTo(BigDecimal.ZERO) == 0;
    }

    public final int compareTo(@NotNull JsonTokenData token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        if (token.hasLongValue() && this.longValue != null) {
            long l = this.longValue - token.getLongValue();
            return l == 0L ? 0 : (l < 0L ? -1 : 1);
        }
        if (token.getInteger() != null && this.bigIntegerValue != null) {
            return this.bigIntegerValue.compareTo(token.getInteger());
        }
        return this.bigDecimalValue.compareTo(token.toDecimal());
    }

    @NotNull
    public String toString() {
        String string = this.bigDecimalValue.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bigDecimalValue.toString()");
        return string;
    }

    @NotNull
    public final BigDecimal getBigDecimalValue() {
        return this.bigDecimalValue;
    }

    public MultiNumber(@NotNull BigDecimal bigDecimalValue) {
        MultiNumber multiNumber;
        Number number;
        MultiNumber multiNumber2;
        Intrinsics.checkParameterIsNotNull((Object)bigDecimalValue, (String)"bigDecimalValue");
        this.bigDecimalValue = bigDecimalValue;
        MultiNumber multiNumber3 = this;
        try {
            multiNumber2 = multiNumber3;
            number = this.bigDecimalValue.longValueExact();
        }
        catch (ArithmeticException arithmeticException) {
            multiNumber2 = multiNumber3;
            number = null;
        }
        multiNumber2.longValue = number;
        multiNumber3 = this;
        try {
            multiNumber = multiNumber3;
            number = this.bigDecimalValue.toBigIntegerExact();
        }
        catch (ArithmeticException e) {
            multiNumber = multiNumber3;
            number = null;
        }
        multiNumber.bigIntegerValue = number;
    }
}

