/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.ObjectHelper;

public final class FilePathResolver {
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env:(.*?)\\}", 32);
    private static final Pattern SYS_PATTERN = Pattern.compile("\\$\\{(.*?)\\}", 32);

    private FilePathResolver() {
    }

    public static String resolvePath(String path) throws IllegalArgumentException {
        String value;
        String key;
        Matcher matcher = ENV_PATTERN.matcher(path);
        while (matcher.find()) {
            key = matcher.group(1);
            value = System.getenv(key);
            if (ObjectHelper.isEmpty(value)) {
                throw new IllegalArgumentException("Cannot find system environment with key: " + key);
            }
            value = Matcher.quoteReplacement(value);
            path = matcher.replaceFirst(value);
            matcher = ENV_PATTERN.matcher(path);
        }
        matcher = SYS_PATTERN.matcher(path);
        while (matcher.find()) {
            key = matcher.group(1);
            value = System.getProperty(key);
            if (ObjectHelper.isEmpty(value)) {
                throw new IllegalArgumentException("Cannot find JVM system property with key: " + key);
            }
            value = Matcher.quoteReplacement(value);
            path = matcher.replaceFirst(value);
            matcher = SYS_PATTERN.matcher(path);
        }
        return path;
    }
}

