/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.kafkaconnector.CamelSourceConnector;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.camel.kafkaconnector.utils.CamelKafkaConnectDataformat;
import org.apache.camel.kafkaconnector.utils.CamelMainSupport;
import org.apache.camel.kafkaconnector.utils.SchemaHelper;
import org.apache.camel.kafkaconnector.utils.TaskHelper;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSourceTask
extends SourceTask {
    public static final String HEADER_CAMEL_PREFIX = "CamelHeader.";
    public static final String PROPERTY_CAMEL_PREFIX = "CamelProperty.";
    private static final Logger LOG = LoggerFactory.getLogger(CamelSourceTask.class);
    private static final String CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX = "camel.source.endpoint.";
    private static final String CAMEL_SOURCE_PATH_PROPERTIES_PREFIX = "camel.source.path.";
    private static final String LOCAL_URL = "direct:end";
    private CamelMainSupport cms;
    private CamelSourceConnectorConfig config;
    private PollingConsumer consumer;
    private String topic;
    private Long maxBatchPollSize;
    private Long maxPollDuration;
    private String camelMessageHeaderKey;

    public String version() {
        return new CamelSourceConnector().version();
    }

    public void start(Map<String, String> props) {
        try {
            LOG.info("Starting CamelSourceTask connector task");
            Map<String, String> actualProps = TaskHelper.mergeProperties(this.getDefaultConfig(), props);
            this.config = this.getCamelSourceConnectorConfig(actualProps);
            this.maxBatchPollSize = this.config.getLong("camel.source.maxBatchPollSize");
            this.maxPollDuration = this.config.getLong("camel.source.maxPollDuration");
            this.camelMessageHeaderKey = this.config.getString("camel.source.camelMessageHeaderKey");
            String remoteUrl = this.config.getString("camel.source.url");
            String unmarshaller = this.config.getString("camel.source.unmarshal");
            String marshaller = this.config.getString("camel.source.marshal");
            LinkedList<CamelKafkaConnectDataformat> dataformats = new LinkedList<CamelKafkaConnectDataformat>();
            if (unmarshaller != null) {
                dataformats.add(new CamelKafkaConnectDataformat(unmarshaller, CamelKafkaConnectDataformat.CamelKafkaConnectDataformatKind.UNMARSHALL));
            }
            if (marshaller != null) {
                dataformats.add(new CamelKafkaConnectDataformat(marshaller, CamelKafkaConnectDataformat.CamelKafkaConnectDataformatKind.MARSHALL));
            }
            this.topic = this.config.getString("topics");
            String localUrl = this.getLocalUrlWithPollingOptions(this.config);
            DefaultCamelContext camelContext = new DefaultCamelContext();
            if (remoteUrl == null) {
                remoteUrl = TaskHelper.buildUrl(((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getRuntimeCamelCatalog(), actualProps, this.config.getString("camel.source.component"), CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX, CAMEL_SOURCE_PATH_PROPERTIES_PREFIX);
            }
            this.cms = new CamelMainSupport(actualProps, remoteUrl, localUrl, dataformats, 10, 500L, (CamelContext)camelContext);
            Endpoint endpoint = this.cms.getEndpoint(localUrl);
            this.consumer = endpoint.createPollingConsumer();
            this.consumer.start();
            this.cms.start();
            LOG.info("CamelSourceTask connector task started");
        }
        catch (Exception e) {
            throw new ConnectException("Failed to create and start Camel context", (Throwable)e);
        }
    }

    public synchronized List<SourceRecord> poll() {
        Exchange exchange;
        long startPollEpochMilli = Instant.now().toEpochMilli();
        ArrayList<SourceRecord> records = new ArrayList<SourceRecord>();
        for (long collectedRecords = 0L; collectedRecords < this.maxBatchPollSize && Instant.now().toEpochMilli() - startPollEpochMilli < this.maxPollDuration && (exchange = this.consumer.receiveNoWait()) != null; ++collectedRecords) {
            LOG.debug("Received Exchange {} with Message {} from Endpoint {}", new Object[]{exchange.getExchangeId(), exchange.getMessage().getMessageId(), exchange.getFromEndpoint()});
            Map<String, String> sourcePartition = Collections.singletonMap("filename", exchange.getFromEndpoint().toString());
            Map<String, String> sourceOffset = Collections.singletonMap("position", exchange.getExchangeId());
            Object messageHeaderKey = this.camelMessageHeaderKey != null ? exchange.getMessage().getHeader(this.camelMessageHeaderKey) : null;
            Object messageBodyValue = exchange.getMessage().getBody();
            SchemaBuilder messageKeySchema = messageHeaderKey != null ? SchemaHelper.buildSchemaBuilderForType(messageHeaderKey) : null;
            SchemaBuilder messageBodySchema = messageBodyValue != null ? SchemaHelper.buildSchemaBuilderForType(messageBodyValue) : null;
            SourceRecord record = new SourceRecord(sourcePartition, sourceOffset, this.topic, (Schema)messageKeySchema, messageHeaderKey, (Schema)messageBodySchema, messageBodyValue);
            if (exchange.getMessage().hasHeaders()) {
                this.setAdditionalHeaders(record, exchange.getMessage().getHeaders(), HEADER_CAMEL_PREFIX);
            }
            if (exchange.hasProperties()) {
                this.setAdditionalHeaders(record, exchange.getProperties(), PROPERTY_CAMEL_PREFIX);
            }
            TaskHelper.logRecordContent(LOG, record, this.config);
            records.add(record);
        }
        if (records.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return records;
    }

    public void stop() {
        LOG.info("Stopping CamelSourceTask connector task");
        try {
            this.consumer.stop();
        }
        catch (Exception e) {
            LOG.error("Error stopping camel consumer: {}", (Object)e.getMessage());
        }
        try {
            this.cms.stop();
        }
        catch (Exception e) {
            throw new ConnectException("Failed to stop Camel context", (Throwable)e);
        }
        finally {
            LOG.info("CamelSourceTask connector task stopped");
        }
    }

    protected CamelSourceConnectorConfig getCamelSourceConnectorConfig(Map<String, String> props) {
        return new CamelSourceConnectorConfig(props);
    }

    protected Map<String, String> getDefaultConfig() {
        return Collections.EMPTY_MAP;
    }

    protected static String getCamelSourceEndpointConfigPrefix() {
        return CAMEL_SOURCE_ENDPOINT_PROPERTIES_PREFIX;
    }

    protected static String getCamelSourcePathConfigPrefix() {
        return CAMEL_SOURCE_PATH_PROPERTIES_PREFIX;
    }

    private void setAdditionalHeaders(SourceRecord record, Map<String, Object> map, String prefix) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String keyCamelHeader = prefix + key;
            if (value instanceof String) {
                record.headers().addString(keyCamelHeader, (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                record.headers().addBoolean(keyCamelHeader, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Byte) {
                record.headers().addByte(keyCamelHeader, ((Byte)value).byteValue());
                continue;
            }
            if (value instanceof Byte[]) {
                record.headers().addBytes(keyCamelHeader, (byte[])value);
                continue;
            }
            if (value instanceof Time) {
                record.headers().addTime(keyCamelHeader, (Date)((Time)value));
                continue;
            }
            if (value instanceof Timestamp) {
                record.headers().addTimestamp(keyCamelHeader, (Date)((Timestamp)value));
                continue;
            }
            if (value instanceof Date) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                String convertedDate = sdf.format(value);
                record.headers().addString(keyCamelHeader, convertedDate);
                continue;
            }
            if (value instanceof BigDecimal) {
                Schema schema = Decimal.schema((int)((BigDecimal)value).scale());
                record.headers().add(keyCamelHeader, (Object)Decimal.fromLogical((Schema)schema, (BigDecimal)((BigDecimal)value)), schema);
                continue;
            }
            if (value instanceof Double) {
                record.headers().addDouble(keyCamelHeader, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                record.headers().addFloat(keyCamelHeader, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Integer) {
                record.headers().addInt(keyCamelHeader, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                record.headers().addLong(keyCamelHeader, ((Long)value).longValue());
                continue;
            }
            if (!(value instanceof Short)) continue;
            record.headers().addShort(keyCamelHeader, ((Short)value).shortValue());
        }
    }

    private String getLocalUrlWithPollingOptions(CamelSourceConnectorConfig config) {
        long pollingConsumerQueueSize = config.getLong("camel.source.pollingConsumerQueueSize");
        long pollingConsumerBlockTimeout = config.getLong("camel.source.pollingConsumerBlockTimeout");
        boolean pollingConsumerBlockWhenFull = config.getBoolean("camel.source.pollingConsumerBlockWhenFull");
        return "direct:end?pollingConsumerQueueSize=" + pollingConsumerQueueSize + "&pollingConsumerBlockTimeout=" + pollingConsumerBlockTimeout + "&pollingConsumerBlockWhenFull=" + pollingConsumerBlockWhenFull;
    }

    public CamelMainSupport getCms() {
        return this.cms;
    }
}

