/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.LinkedHashMap;
import java.util.Map;

public class JMXUriBuilder {
    private Map<String, String> mQueryProps = new LinkedHashMap<String, String>();
    private String mServerName = "platform";

    public JMXUriBuilder() {
    }

    public JMXUriBuilder(String aServerName) {
        this.setServerName(aServerName);
    }

    public JMXUriBuilder withFormat(String aFormat) {
        this.addProperty("format", aFormat);
        return this;
    }

    public JMXUriBuilder withUser(String aFormat) {
        this.addProperty("user", aFormat);
        return this;
    }

    public JMXUriBuilder withPassword(String aFormat) {
        this.addProperty("password", aFormat);
        return this;
    }

    public JMXUriBuilder withObjectDomain(String aFormat) {
        this.addProperty("objectDomain", aFormat);
        return this;
    }

    public JMXUriBuilder withObjectName(String aFormat) {
        this.addProperty("objectName", aFormat);
        return this;
    }

    public JMXUriBuilder withNotificationFilter(String aFilter) {
        this.addProperty("notificationFilter", aFilter);
        return this;
    }

    public JMXUriBuilder withHandback(String aHandback) {
        this.addProperty("handback", aHandback);
        return this;
    }

    public JMXUriBuilder withMonitorType(String aMonitorType) {
        this.addProperty("monitorType", aMonitorType);
        return this;
    }

    public JMXUriBuilder withInitThreshold(int aInitThreshold) {
        this.addProperty("initThreshold", String.valueOf(aInitThreshold));
        return this;
    }

    public JMXUriBuilder withOffset(int aOffset) {
        this.addProperty("offset", String.valueOf(aOffset));
        return this;
    }

    public JMXUriBuilder withModulus(int aModulus) {
        this.addProperty("modulus", String.valueOf(aModulus));
        return this;
    }

    public JMXUriBuilder withDifferenceMode(boolean aDifferenceMode) {
        this.addProperty("differenceMode", String.valueOf(aDifferenceMode));
        return this;
    }

    public JMXUriBuilder withGranularityPeriod(long aPeriod) {
        this.addProperty("granularityPeriod", String.valueOf(aPeriod));
        return this;
    }

    public JMXUriBuilder withObservedAttribute(String aObservedAttribute) {
        this.addProperty("observedAttribute", aObservedAttribute);
        return this;
    }

    public JMXUriBuilder withNotifyHigh(boolean aNotifyHigh) {
        this.addProperty("notifyHigh", String.valueOf(aNotifyHigh));
        return this;
    }

    public JMXUriBuilder withNotifyLow(boolean aNotifyLow) {
        this.addProperty("notifyLow", String.valueOf(aNotifyLow));
        return this;
    }

    public JMXUriBuilder withThresholdHigh(Number aThresholdHigh) {
        this.addProperty("thresholdHigh", String.valueOf(aThresholdHigh));
        return this;
    }

    public JMXUriBuilder withThresholdLow(Number aThresholdLow) {
        this.addProperty("thresholdLow", String.valueOf(aThresholdLow));
        return this;
    }

    public JMXUriBuilder withNotifyDiffer(boolean aNotifyDiffer) {
        this.addProperty("notifyDiffer", String.valueOf(aNotifyDiffer));
        return this;
    }

    public JMXUriBuilder withNotifyMatch(boolean aNotifyMatch) {
        this.addProperty("notifyMatch", String.valueOf(aNotifyMatch));
        return this;
    }

    public JMXUriBuilder withStringToCompare(String aStringToCompare) {
        this.addProperty("stringToCompare", aStringToCompare);
        return this;
    }

    public JMXUriBuilder withTestConnectionOnStartup(boolean aTestConnectionOnStartup) {
        this.addProperty("testConnectionOnStartup", String.valueOf(aTestConnectionOnStartup));
        return this;
    }

    public JMXUriBuilder withReconnectOnConnectionFailure(boolean aReconnectOnConnectionFailure) {
        this.addProperty("reconnectOnConnectionFailure", String.valueOf(aReconnectOnConnectionFailure));
        return this;
    }

    public JMXUriBuilder withReconnectDelay(int aReconnectDelay) {
        this.addProperty("reconnectDelay", String.valueOf(aReconnectDelay));
        return this;
    }

    public JMXUriBuilder withObjectProperties(Map<String, String> aPropertiesSansKeyPrefix) {
        for (Map.Entry<String, String> entry : aPropertiesSansKeyPrefix.entrySet()) {
            this.addProperty("key." + entry.getKey(), entry.getValue());
        }
        return this;
    }

    public JMXUriBuilder withObjectPropertiesReference(String aReferenceToHashtable) {
        if (aReferenceToHashtable.startsWith("#")) {
            this.addProperty("objectProperties", aReferenceToHashtable);
        } else {
            this.addProperty("objectProperties", "#" + aReferenceToHashtable);
        }
        return this;
    }

    protected void addProperty(String aName, String aValue) {
        this.mQueryProps.put(aName, aValue);
    }

    public String getServerName() {
        return this.mServerName;
    }

    public void setServerName(String aServerName) {
        this.mServerName = aServerName;
    }

    public JMXUriBuilder withServerName(String aServerName) {
        this.setServerName(aServerName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("jmx:").append(this.getServerName());
        if (!this.mQueryProps.isEmpty()) {
            sb.append('?');
            String delim = "";
            for (Map.Entry<String, String> entry : this.mQueryProps.entrySet()) {
                sb.append(delim);
                sb.append(entry.getKey()).append('=').append(entry.getValue());
                delim = "&";
            }
        }
        return sb.toString();
    }
}

