/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.main.SimpleMainShutdownStrategy;
import org.apache.camel.util.concurrent.ThreadHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMainShutdownStrategy
extends SimpleMainShutdownStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultMainShutdownStrategy.class);
    private final AtomicBoolean hangupIntercepted = new AtomicBoolean();
    private volatile boolean hangupInterceptorEnabled;

    public void disableHangupSupport() {
        this.hangupInterceptorEnabled = false;
    }

    public void enableHangupSupport() {
        this.hangupInterceptorEnabled = true;
    }

    @Override
    public void await() throws InterruptedException {
        this.installHangupInterceptor();
        super.await();
    }

    @Override
    public void await(long timeout, TimeUnit unit) throws InterruptedException {
        this.installHangupInterceptor();
        super.await(timeout, unit);
    }

    private void handleHangup() {
        LOG.info("Received hang up - stopping the main instance.");
        this.shutdown();
    }

    private void installHangupInterceptor() {
        if (this.hangupIntercepted.compareAndSet(false, this.hangupInterceptorEnabled)) {
            Thread task = new Thread(this::handleHangup);
            task.setName(ThreadHelper.resolveThreadName(null, (String)"CamelHangupInterceptor"));
            Runtime.getRuntime().addShutdownHook(task);
        }
    }
}

