/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.language;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.SimpleBuilder;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.reifier.language.ExpressionReifier;

public class SimpleExpressionReifier
extends ExpressionReifier<SimpleExpression> {
    public SimpleExpressionReifier(CamelContext camelContext, ExpressionDefinition definition) {
        super(camelContext, (SimpleExpression)definition);
    }

    @Override
    public Expression createExpression() {
        final Expression expr = this.createBuilder().createExpression(this.camelContext);
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                return (T)expr.evaluate(exchange, type);
            }

            public String toString() {
                return ((SimpleExpression)SimpleExpressionReifier.this.definition).getExpression();
            }
        };
    }

    @Override
    public Predicate createPredicate() {
        final Predicate pred = this.createBuilder().createPredicate(this.camelContext);
        return new Predicate(){

            public boolean matches(Exchange exchange) {
                return pred.matches(exchange);
            }

            public String toString() {
                return ((SimpleExpression)SimpleExpressionReifier.this.definition).getExpression();
            }
        };
    }

    protected SimpleBuilder createBuilder() {
        String exp = this.parseString(((SimpleExpression)this.definition).getExpression());
        boolean isTrim = this.parseBoolean(((SimpleExpression)this.definition).getTrim(), true);
        if (exp != null && isTrim) {
            exp = exp.trim();
        }
        SimpleBuilder answer = new SimpleBuilder(exp);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("resultType", this.or(((SimpleExpression)this.definition).getResultType(), ((SimpleExpression)this.definition).getResultTypeName()));
        this.setProperties(answer, props);
        return answer;
    }
}

