/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedBacklogDebuggerMBean;
import org.apache.camel.impl.debugger.BacklogDebugger;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ManagementStrategy;

@ManagedResource(description="Managed BacklogDebugger")
public class ManagedBacklogDebugger
implements ManagedBacklogDebuggerMBean {
    private final CamelContext camelContext;
    private final BacklogDebugger backlogDebugger;

    public ManagedBacklogDebugger(CamelContext camelContext, BacklogDebugger backlogDebugger) {
        this.camelContext = camelContext;
        this.backlogDebugger = backlogDebugger;
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public BacklogDebugger getBacklogDebugger() {
        return this.backlogDebugger;
    }

    public String getCamelId() {
        return this.camelContext.getName();
    }

    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    public String getLoggingLevel() {
        return this.backlogDebugger.getLoggingLevel();
    }

    public void setLoggingLevel(String level) {
        this.backlogDebugger.setLoggingLevel(level);
    }

    public boolean isEnabled() {
        return this.backlogDebugger.isEnabled();
    }

    public void enableDebugger() {
        this.backlogDebugger.enableDebugger();
    }

    public void disableDebugger() {
        this.backlogDebugger.disableDebugger();
    }

    public void addBreakpoint(String nodeId) {
        this.backlogDebugger.addBreakpoint(nodeId);
    }

    public void addConditionalBreakpoint(String nodeId, String language, String predicate) {
        this.backlogDebugger.addConditionalBreakpoint(nodeId, language, predicate);
    }

    public void removeBreakpoint(String nodeId) {
        this.backlogDebugger.removeBreakpoint(nodeId);
    }

    public void removeAllBreakpoints() {
        this.backlogDebugger.removeAllBreakpoints();
    }

    public Set<String> getBreakpoints() {
        return this.backlogDebugger.getBreakpoints();
    }

    public void resumeBreakpoint(String nodeId) {
        this.backlogDebugger.resumeBreakpoint(nodeId);
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body) {
        this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body);
    }

    public void setMessageBodyOnBreakpoint(String nodeId, Object body, String type) {
        try {
            Class classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageBodyOnBreakpoint(nodeId, body, classType);
        }
        catch (ClassNotFoundException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void removeMessageBodyOnBreakpoint(String nodeId) {
        this.backlogDebugger.removeMessageBodyOnBreakpoint(nodeId);
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value) {
        try {
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value);
        }
        catch (NoTypeConversionAvailableException e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void setMessageHeaderOnBreakpoint(String nodeId, String headerName, Object value, String type) {
        try {
            Class classType = this.camelContext.getClassResolver().resolveMandatoryClass(type);
            this.backlogDebugger.setMessageHeaderOnBreakpoint(nodeId, headerName, value, classType);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
    }

    public void removeMessageHeaderOnBreakpoint(String nodeId, String headerName) {
        this.backlogDebugger.removeMessageHeaderOnBreakpoint(nodeId, headerName);
    }

    public void resumeAll() {
        this.backlogDebugger.resumeAll();
    }

    public void stepBreakpoint(String nodeId) {
        this.backlogDebugger.stepBreakpoint(nodeId);
    }

    public boolean isSingleStepMode() {
        return this.backlogDebugger.isSingleStepMode();
    }

    public void step() {
        this.backlogDebugger.step();
    }

    public Set<String> getSuspendedBreakpointNodeIds() {
        return this.backlogDebugger.getSuspendedBreakpointNodeIds();
    }

    public void disableBreakpoint(String nodeId) {
        this.backlogDebugger.disableBreakpoint(nodeId);
    }

    public void enableBreakpoint(String nodeId) {
        this.backlogDebugger.enableBreakpoint(nodeId);
    }

    public int getBodyMaxChars() {
        return this.backlogDebugger.getBodyMaxChars();
    }

    public void setBodyMaxChars(int bodyMaxChars) {
        this.backlogDebugger.setBodyMaxChars(bodyMaxChars);
    }

    public boolean isBodyIncludeStreams() {
        return this.backlogDebugger.isBodyIncludeStreams();
    }

    public void setBodyIncludeStreams(boolean bodyIncludeStreams) {
        this.backlogDebugger.setBodyIncludeStreams(bodyIncludeStreams);
    }

    public boolean isBodyIncludeFiles() {
        return this.backlogDebugger.isBodyIncludeFiles();
    }

    public void setBodyIncludeFiles(boolean bodyIncludeFiles) {
        this.backlogDebugger.setBodyIncludeFiles(bodyIncludeFiles);
    }

    public String dumpTracedMessagesAsXml(String nodeId) {
        return this.backlogDebugger.dumpTracedMessagesAsXml(nodeId);
    }

    public long getDebugCounter() {
        return this.backlogDebugger.getDebugCounter();
    }

    public void resetDebugCounter() {
        this.backlogDebugger.resetDebugCounter();
    }

    public String validateConditionalBreakpoint(String language, String predicate) {
        Language lan = null;
        try {
            lan = this.camelContext.resolveLanguage(language);
            lan.createPredicate(predicate);
            return null;
        }
        catch (Exception e) {
            if (lan == null) {
                return e.getMessage();
            }
            return "Invalid syntax " + predicate + " due: " + e.getMessage();
        }
    }

    public long getFallbackTimeout() {
        return this.backlogDebugger.getFallbackTimeout();
    }

    public void setFallbackTimeout(long fallbackTimeout) {
        this.backlogDebugger.setFallbackTimeout(fallbackTimeout);
    }
}

