/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.kafkaconnector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.kafkaconnector.CamelSinkConnectorConfig;
import org.apache.camel.kafkaconnector.CamelSinkTask;
import org.apache.camel.kafkaconnector.VersionUtil;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelSinkConnector
extends SinkConnector {
    private static Logger log = LoggerFactory.getLogger(CamelSinkConnector.class);
    private Map<String, String> configProps;

    public String version() {
        return VersionUtil.getVersion();
    }

    public void start(Map<String, String> configProps) {
        log.info("Connector config keys: {}", (Object)String.join((CharSequence)", ", configProps.keySet()));
        this.configProps = configProps;
    }

    public Class<? extends Task> taskClass() {
        return CamelSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        log.info("Setting task configurations for {} workers.", (Object)maxTasks);
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.configProps);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return CamelSinkConnectorConfig.conf();
    }
}

