/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.errorhandler;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.builder.DeadLetterChannelBuilder;
import org.apache.camel.builder.DefaultErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.ErrorHandlerBuilderSupport;
import org.apache.camel.builder.NoErrorHandlerBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.errorhandler.ErrorHandlerSupport;
import org.apache.camel.processor.errorhandler.ExceptionPolicy;
import org.apache.camel.processor.errorhandler.RedeliveryErrorHandler;
import org.apache.camel.processor.errorhandler.RedeliveryPolicy;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.reifier.errorhandler.DeadLetterChannelReifier;
import org.apache.camel.reifier.errorhandler.DefaultErrorHandlerReifier;
import org.apache.camel.reifier.errorhandler.ErrorHandlerRefReifier;
import org.apache.camel.reifier.errorhandler.NoErrorHandlerReifier;
import org.apache.camel.reifier.language.ExpressionReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public abstract class ErrorHandlerReifier<T extends ErrorHandlerBuilderSupport>
extends AbstractReifier {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";
    private static final Map<Class<?>, BiFunction<RouteContext, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>>> ERROR_HANDLERS;
    protected T definition;

    ErrorHandlerReifier(RouteContext routeContext, T definition) {
        super(routeContext);
        this.definition = definition;
    }

    public static void registerReifier(Class<?> errorHandlerClass, BiFunction<RouteContext, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> creator) {
        ERROR_HANDLERS.put(errorHandlerClass, creator);
    }

    public static ErrorHandlerReifier<? extends ErrorHandlerFactory> reifier(RouteContext routeContext, ErrorHandlerFactory definition) {
        BiFunction<RouteContext, ErrorHandlerFactory, ErrorHandlerReifier<? extends ErrorHandlerFactory>> reifier = ERROR_HANDLERS.get(definition.getClass());
        if (reifier != null) {
            return reifier.apply(routeContext, definition);
        }
        if (definition instanceof ErrorHandlerBuilderSupport) {
            return new ErrorHandlerReifier<ErrorHandlerBuilderSupport>(routeContext, (ErrorHandlerBuilderSupport)definition){

                @Override
                public Processor createErrorHandler(Processor processor) throws Exception {
                    return this.definition.createErrorHandler(this.routeContext, processor);
                }
            };
        }
        throw new IllegalStateException("Unsupported definition: " + definition);
    }

    public static ExceptionPolicy createExceptionPolicy(OnExceptionDefinition def, CamelContext camelContext) {
        Processor onExceptionOccurred;
        Processor onRedelivery;
        Predicate retryWhile;
        Predicate continued;
        Predicate handled = def.getHandledPolicy();
        if (handled == null && def.getHandled() != null) {
            handled = ExpressionReifier.reifier(camelContext, def.getHandled()).createPredicate();
        }
        if ((continued = def.getContinuedPolicy()) == null && def.getContinued() != null) {
            continued = ExpressionReifier.reifier(camelContext, def.getContinued()).createPredicate();
        }
        if ((retryWhile = def.getRetryWhilePolicy()) == null && def.getRetryWhile() != null) {
            retryWhile = ExpressionReifier.reifier(camelContext, def.getRetryWhile()).createPredicate();
        }
        if ((onRedelivery = def.getOnRedelivery()) == null && def.getOnRedeliveryRef() != null) {
            onRedelivery = (Processor)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)CamelContextHelper.parseText((CamelContext)camelContext, (String)def.getOnRedeliveryRef()), Processor.class);
        }
        if ((onExceptionOccurred = def.getOnExceptionOccurred()) == null && def.getOnExceptionOccurredRef() != null) {
            onExceptionOccurred = (Processor)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)CamelContextHelper.parseText((CamelContext)camelContext, (String)def.getOnExceptionOccurredRef()), Processor.class);
        }
        return new ExceptionPolicy(def.getId(), CamelContextHelper.getRouteId((NamedNode)def), def.getUseOriginalMessage() != null && CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)def.getUseOriginalMessage()) != false, def.getUseOriginalBody() != null && CamelContextHelper.parseBoolean((CamelContext)camelContext, (String)def.getUseOriginalBody()) != false, ObjectHelper.isNotEmpty(def.getOutputs()), handled, continued, retryWhile, onRedelivery, onExceptionOccurred, def.getRedeliveryPolicyRef(), ErrorHandlerReifier.getRedeliveryPolicy(def.getRedeliveryPolicyType()), def.getExceptions());
    }

    private static Map<ExceptionPolicy.RedeliveryOption, String> getRedeliveryPolicy(RedeliveryPolicyDefinition definition) {
        if (definition == null) {
            return null;
        }
        HashMap<ExceptionPolicy.RedeliveryOption, String> policy = new HashMap<ExceptionPolicy.RedeliveryOption, String>();
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveries, definition.getMaximumRedeliveries());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.redeliveryDelay, definition.getRedeliveryDelay());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.asyncDelayedRedelivery, definition.getAsyncDelayedRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.backOffMultiplier, definition.getBackOffMultiplier());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useExponentialBackOff, definition.getUseExponentialBackOff());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.collisionAvoidanceFactor, definition.getCollisionAvoidanceFactor());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.useCollisionAvoidance, definition.getUseCollisionAvoidance());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.maximumRedeliveryDelay, definition.getMaximumRedeliveryDelay());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retriesExhaustedLogLevel, definition.getRetriesExhaustedLogLevel());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogLevel, definition.getRetryAttemptedLogLevel());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.retryAttemptedLogInterval, definition.getRetryAttemptedLogInterval());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryAttempted, definition.getLogRetryAttempted());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logStackTrace, definition.getLogStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logRetryStackTrace, definition.getLogRetryStackTrace());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logHandled, definition.getLogHandled());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logNewException, definition.getLogNewException());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logContinued, definition.getLogContinued());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhausted, definition.getLogExhausted());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageHistory, definition.getLogExhaustedMessageHistory());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.logExhaustedMessageBody, definition.getLogExhaustedMessageBody());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.disableRedelivery, definition.getDisableRedelivery());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.delayPattern, definition.getDelayPattern());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.allowRedeliveryWhileStopping, definition.getAllowRedeliveryWhileStopping());
        ErrorHandlerReifier.setOption(policy, ExceptionPolicy.RedeliveryOption.exchangeFormatterRef, definition.getExchangeFormatterRef());
        return policy;
    }

    private static void setOption(Map<ExceptionPolicy.RedeliveryOption, String> policy, ExceptionPolicy.RedeliveryOption option, Object value) {
        if (value != null) {
            policy.put(option, value.toString());
        }
    }

    public static ErrorHandlerFactory lookupErrorHandlerFactory(RouteContext routeContext, String ref) {
        return ErrorHandlerReifier.lookupErrorHandlerFactory(routeContext, ref, true);
    }

    public static ErrorHandlerFactory lookupErrorHandlerFactory(RouteContext routeContext, String ref, boolean mandatory) {
        ErrorHandlerFactory answer;
        if (!ErrorHandlerReifier.isErrorHandlerFactoryConfigured(ref)) {
            RouteDefinition route = (RouteDefinition)routeContext.getRoute();
            answer = route.getErrorHandlerFactory();
            if (answer instanceof ErrorHandlerBuilderRef) {
                ErrorHandlerBuilderRef other = (ErrorHandlerBuilderRef)answer;
                String otherRef = other.getRef();
                if (!ErrorHandlerReifier.isErrorHandlerFactoryConfigured(otherRef)) {
                    answer = ErrorHandlerReifier.lookupErrorHandlerFactory(routeContext.getCamelContext());
                }
                if (answer == null) {
                    answer = new DefaultErrorHandlerBuilder();
                }
                routeContext.addErrorHandlerFactoryReference((ErrorHandlerFactory)other, answer);
            }
        } else {
            answer = mandatory ? (ErrorHandlerFactory)routeContext.mandatoryLookup(ref, ErrorHandlerBuilder.class) : (ErrorHandlerFactory)routeContext.lookup(ref, ErrorHandlerBuilder.class);
        }
        return answer;
    }

    protected static ErrorHandlerFactory lookupErrorHandlerFactory(CamelContext camelContext) {
        ErrorHandlerBuilderRef other;
        String otherRef;
        ErrorHandlerFactory answer = ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).getErrorHandlerFactory();
        if (answer instanceof ErrorHandlerBuilderRef && ErrorHandlerReifier.isErrorHandlerFactoryConfigured(otherRef = (other = (ErrorHandlerBuilderRef)answer).getRef()) && (answer = (ErrorHandlerFactory)camelContext.getRegistry().lookupByNameAndType(otherRef, ErrorHandlerBuilder.class)) == null) {
            throw new IllegalArgumentException("ErrorHandlerBuilder with id " + otherRef + " not found in registry.");
        }
        return answer;
    }

    public static boolean isErrorHandlerFactoryConfigured(String ref) {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(ref);
    }

    public abstract Processor createErrorHandler(Processor var1) throws Exception;

    public void configure(RouteContext routeContext, ErrorHandler handler) {
        if (handler instanceof ErrorHandlerSupport) {
            ErrorHandlerSupport handlerSupport = (ErrorHandlerSupport)handler;
            for (NamedNode exception : routeContext.getErrorHandlers(this.definition)) {
                ErrorHandlerBuilderSupport.addExceptionPolicy(handlerSupport, routeContext, (OnExceptionDefinition)exception);
            }
        }
        if (handler instanceof RedeliveryErrorHandler) {
            boolean original;
            boolean bl = original = ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy() || ((RedeliveryErrorHandler)handler).isUseOriginalMessagePolicy();
            if (original) {
                routeContext.setAllowUseOriginalMessage(Boolean.valueOf(true));
            }
        }
    }

    public static RedeliveryPolicy createRedeliveryPolicy(RedeliveryPolicyDefinition definition, CamelContext context, RedeliveryPolicy parentPolicy) {
        RedeliveryPolicy answer = parentPolicy != null ? parentPolicy.copy() : new RedeliveryPolicy();
        try {
            if (definition.getMaximumRedeliveries() != null) {
                answer.setMaximumRedeliveries(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getMaximumRedeliveries()).intValue());
            }
            if (definition.getRedeliveryDelay() != null) {
                answer.setRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getRedeliveryDelay()).longValue());
            }
            if (definition.getAsyncDelayedRedelivery() != null) {
                answer.setAsyncDelayedRedelivery(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAsyncDelayedRedelivery()).booleanValue());
            }
            if (definition.getRetriesExhaustedLogLevel() != null) {
                answer.setRetriesExhaustedLogLevel(LoggingLevel.valueOf((String)definition.getRetriesExhaustedLogLevel()));
            }
            if (definition.getRetryAttemptedLogLevel() != null) {
                answer.setRetryAttemptedLogLevel(LoggingLevel.valueOf((String)definition.getRetryAttemptedLogLevel()));
            }
            if (definition.getRetryAttemptedLogInterval() != null) {
                answer.setRetryAttemptedLogInterval(CamelContextHelper.parseInteger((CamelContext)context, (String)definition.getRetryAttemptedLogInterval()).intValue());
            }
            if (definition.getBackOffMultiplier() != null) {
                answer.setBackOffMultiplier(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getBackOffMultiplier()).doubleValue());
            }
            if (definition.getUseExponentialBackOff() != null) {
                answer.setUseExponentialBackOff(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseExponentialBackOff()).booleanValue());
            }
            if (definition.getCollisionAvoidanceFactor() != null) {
                answer.setCollisionAvoidanceFactor(CamelContextHelper.parseDouble((CamelContext)context, (String)definition.getCollisionAvoidanceFactor()).doubleValue());
            }
            if (definition.getUseCollisionAvoidance() != null) {
                answer.setUseCollisionAvoidance(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getUseCollisionAvoidance()).booleanValue());
            }
            if (definition.getMaximumRedeliveryDelay() != null) {
                answer.setMaximumRedeliveryDelay(CamelContextHelper.parseLong((CamelContext)context, (String)definition.getMaximumRedeliveryDelay()).longValue());
            }
            if (definition.getLogStackTrace() != null) {
                answer.setLogStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogStackTrace()).booleanValue());
            }
            if (definition.getLogRetryStackTrace() != null) {
                answer.setLogRetryStackTrace(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryStackTrace()).booleanValue());
            }
            if (definition.getLogHandled() != null) {
                answer.setLogHandled(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogHandled()).booleanValue());
            }
            if (definition.getLogNewException() != null) {
                answer.setLogNewException(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogNewException()).booleanValue());
            }
            if (definition.getLogContinued() != null) {
                answer.setLogContinued(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogContinued()).booleanValue());
            }
            if (definition.getLogRetryAttempted() != null) {
                answer.setLogRetryAttempted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogRetryAttempted()).booleanValue());
            }
            if (definition.getLogExhausted() != null) {
                answer.setLogExhausted(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhausted()).booleanValue());
            }
            if (definition.getLogExhaustedMessageHistory() != null) {
                answer.setLogExhaustedMessageHistory(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageHistory()).booleanValue());
            }
            if (definition.getLogExhaustedMessageBody() != null) {
                answer.setLogExhaustedMessageBody(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getLogExhaustedMessageBody()));
            }
            if (definition.getDisableRedelivery() != null && CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getDisableRedelivery()).booleanValue()) {
                answer.setMaximumRedeliveries(0);
            }
            if (definition.getDelayPattern() != null) {
                answer.setDelayPattern(CamelContextHelper.parseText((CamelContext)context, (String)definition.getDelayPattern()));
            }
            if (definition.getAllowRedeliveryWhileStopping() != null) {
                answer.setAllowRedeliveryWhileStopping(CamelContextHelper.parseBoolean((CamelContext)context, (String)definition.getAllowRedeliveryWhileStopping()).booleanValue());
            }
            if (definition.getExchangeFormatterRef() != null) {
                answer.setExchangeFormatterRef(CamelContextHelper.parseText((CamelContext)context, (String)definition.getExchangeFormatterRef()));
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException((Throwable)e);
        }
        return answer;
    }

    static {
        HashMap map = new HashMap();
        map.put(DeadLetterChannelBuilder.class, DeadLetterChannelReifier::new);
        map.put(DefaultErrorHandlerBuilder.class, DefaultErrorHandlerReifier::new);
        map.put(ErrorHandlerBuilderRef.class, ErrorHandlerRefReifier::new);
        map.put(NoErrorHandlerBuilder.class, NoErrorHandlerReifier::new);
        ERROR_HANDLERS = map;
    }
}

