/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.processor.Splitter;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.reifier.ExpressionReifier;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.support.CamelContextHelper;

public class SplitReifier
extends ExpressionReifier<SplitDefinition> {
    public SplitReifier(RouteContext routeContext, ProcessorDefinition<?> definition) {
        super(routeContext, (SplitDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        long timeout;
        Processor childProcessor = this.createChildProcessor(true);
        ((SplitDefinition)this.definition).setAggregationStrategy(this.createAggregationStrategy());
        boolean isParallelProcessing = this.parseBoolean(((SplitDefinition)this.definition).getParallelProcessing(), false);
        boolean isStreaming = this.parseBoolean(((SplitDefinition)this.definition).getStreaming(), false);
        boolean isShareUnitOfWork = this.parseBoolean(((SplitDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isParallelAggregate = this.parseBoolean(((SplitDefinition)this.definition).getParallelAggregate(), false);
        boolean isStopOnAggregateException = this.parseBoolean(((SplitDefinition)this.definition).getStopOnAggregateException(), false);
        boolean isStopOnException = this.parseBoolean(((SplitDefinition)this.definition).getStopOnException(), false);
        boolean shutdownThreadPool = this.willCreateNewThreadPool((ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        ExecutorService threadPool = this.getConfiguredExecutorService("Split", (ExecutorServiceAwareDefinition)((Object)this.definition), isParallelProcessing);
        long l = timeout = ((SplitDefinition)this.definition).getTimeout() != null ? this.parseLong(((SplitDefinition)this.definition).getTimeout()) : 0L;
        if (timeout > 0L && !isParallelProcessing) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        if (((SplitDefinition)this.definition).getOnPrepareRef() != null) {
            ((SplitDefinition)this.definition).setOnPrepare((Processor)CamelContextHelper.mandatoryLookup((CamelContext)this.camelContext, (String)this.parseString(((SplitDefinition)this.definition).getOnPrepareRef()), Processor.class));
        }
        Expression exp = this.createExpression(((SplitDefinition)this.definition).getExpression());
        Splitter answer = new Splitter(this.camelContext, exp, childProcessor, ((SplitDefinition)this.definition).getAggregationStrategy(), isParallelProcessing, threadPool, shutdownThreadPool, isStreaming, isStopOnException, timeout, ((SplitDefinition)this.definition).getOnPrepare(), isShareUnitOfWork, isParallelAggregate, isStopOnAggregateException);
        return answer;
    }

    private AggregationStrategy createAggregationStrategy() {
        AggregationStrategy strategy = ((SplitDefinition)this.definition).getAggregationStrategy();
        if (strategy == null && ((SplitDefinition)this.definition).getStrategyRef() != null) {
            Object aggStrategy = this.routeContext.lookup(((SplitDefinition)this.definition).getStrategyRef(), Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, ((SplitDefinition)this.definition).getStrategyMethodName());
                if (((SplitDefinition)this.definition).getStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                    adapter.setAllowNullOldExchange(this.parseBoolean(((SplitDefinition)this.definition).getStrategyMethodAllowNull(), false));
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + ((SplitDefinition)this.definition).getStrategyRef());
            }
        }
        if (strategy instanceof CamelContextAware) {
            ((CamelContextAware)strategy).setCamelContext(this.camelContext);
        }
        if (strategy != null && this.parseBoolean(((SplitDefinition)this.definition).getShareUnitOfWork(), false)) {
            strategy = new ShareUnitOfWorkAggregationStrategy(strategy);
        }
        return strategy;
    }
}

