/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.impl.engine.BaseRouteService;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.support.CamelContextHelper;

public class RouteService
extends BaseRouteService {
    private final RouteDefinition routeDefinition;

    public RouteService(Route route) {
        super(route);
        this.routeDefinition = (RouteDefinition)route.getRouteContext().getRoute();
    }

    public RouteDefinition getRouteDefinition() {
        return this.routeDefinition;
    }

    public Integer getStartupOrder() {
        return this.routeDefinition.getStartupOrder();
    }

    protected String getRouteDescription() {
        return RouteDefinitionHelper.getRouteMessage(this.routeDefinition.toString());
    }

    public boolean isAutoStartup() throws Exception {
        if (!this.getCamelContext().isAutoStartup().booleanValue()) {
            return false;
        }
        if (!this.getRouteContext().isAutoStartup().booleanValue()) {
            return false;
        }
        if (this.routeDefinition.getAutoStartup() == null) {
            return true;
        }
        Boolean isAutoStartup = CamelContextHelper.parseBoolean((CamelContext)this.getCamelContext(), (String)this.routeDefinition.getAutoStartup());
        return isAutoStartup != null && isAutoStartup != false;
    }

    public boolean isContextScopedErrorHandler() {
        if (!this.routeDefinition.isContextScopedErrorHandler()) {
            return false;
        }
        if (this.routeDefinition.getErrorHandlerRef() != null) {
            ErrorHandlerFactory routeScoped = this.getRouteContext().getErrorHandlerFactory();
            ErrorHandlerFactory contextScoped = ((ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class)).getErrorHandlerFactory();
            return routeScoped != null && contextScoped != null && routeScoped == contextScoped;
        }
        return true;
    }

    protected void doGetRouteScopedServices(List<Service> services) {
        for (ProcessorDefinition<?> output : this.routeDefinition.getOutputs()) {
            Processor onCompletionProcessor;
            OnCompletionDefinition onCompletionDefinition;
            if (output instanceof OnExceptionDefinition) {
                Processor errorHandler;
                OnExceptionDefinition onExceptionDefinition = (OnExceptionDefinition)output;
                if (!onExceptionDefinition.isRouteScoped() || !((errorHandler = this.getRouteContext().getOnException(onExceptionDefinition.getId())) instanceof Service)) continue;
                services.add((Service)errorHandler);
                continue;
            }
            if (!(output instanceof OnCompletionDefinition) || !(onCompletionDefinition = (OnCompletionDefinition)output).isRouteScoped() || !((onCompletionProcessor = this.getRouteContext().getOnCompletion(onCompletionDefinition.getId())) instanceof Service)) continue;
            services.add((Service)onCompletionProcessor);
        }
    }
}

