/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.model.Model;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.validator.CustomValidatorDefinition;
import org.apache.camel.model.validator.EndpointValidatorDefinition;
import org.apache.camel.model.validator.PredicateValidatorDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Validator;

public class ValidatorBuilder {
    private String type;
    private String uri;
    private ExpressionDefinition expression;
    private Class<? extends Validator> clazz;
    private String beanRef;

    public ValidatorBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ValidatorBuilder type(Class<?> type) {
        this.type = new DataType(type).toString();
        return this;
    }

    public ValidatorBuilder withUri(String uri) {
        this.resetType();
        this.uri = uri;
        return this;
    }

    public ValidatorBuilder withExpression(@AsPredicate Expression expression) {
        this.resetType();
        this.expression = new ExpressionDefinition(expression);
        return this;
    }

    public ValidatorBuilder withExpression(@AsPredicate Predicate predicate) {
        this.resetType();
        this.expression = new ExpressionDefinition(predicate);
        return this;
    }

    public ValidatorBuilder withJava(Class<? extends Validator> clazz) {
        this.resetType();
        this.clazz = clazz;
        return this;
    }

    public ValidatorBuilder withBean(String ref) {
        this.resetType();
        this.beanRef = ref;
        return this;
    }

    private void resetType() {
        this.uri = null;
        this.expression = null;
        this.clazz = null;
        this.beanRef = null;
    }

    public void configure(CamelContext camelContext) {
        ValidatorDefinition validator;
        if (this.uri != null) {
            EndpointValidatorDefinition etd = new EndpointValidatorDefinition();
            etd.setUri(this.uri);
            validator = etd;
        } else if (this.expression != null) {
            PredicateValidatorDefinition dtd = new PredicateValidatorDefinition();
            dtd.setExpression(this.expression);
            validator = dtd;
        } else if (this.clazz != null) {
            CustomValidatorDefinition ctd = new CustomValidatorDefinition();
            ctd.setClassName(this.clazz.getName());
            validator = ctd;
        } else if (this.beanRef != null) {
            CustomValidatorDefinition ctd = new CustomValidatorDefinition();
            ctd.setRef(this.beanRef);
            validator = ctd;
        } else {
            throw new IllegalArgumentException("No Validator type was specified");
        }
        camelContext.getValidatorRegistry();
        validator.setType(this.type);
        ((Model)camelContext.getExtension(Model.class)).getValidators().add(validator);
    }
}

