/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.spi.ExpressionResultTypeAware;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.PredicateToExpressionAdapter;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class SimpleBuilder
implements Predicate,
Expression,
ExpressionResultTypeAware,
PropertyConfigurer {
    private final String text;
    private Class<?> resultType;
    private volatile Expression expression;
    private volatile Predicate predicate;

    public SimpleBuilder(String text) {
        this.text = text;
    }

    public static SimpleBuilder simple(String text) {
        return new SimpleBuilder(text);
    }

    public static SimpleBuilder simple(String text, Class<?> resultType) {
        SimpleBuilder answer = SimpleBuilder.simple(text);
        answer.setResultType(resultType);
        return answer;
    }

    public static SimpleBuilder simpleF(String formatText, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values));
    }

    public static SimpleBuilder simpleF(String formatText, Class<?> resultType, Object ... values) {
        return SimpleBuilder.simple(String.format(formatText, values), resultType);
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public String getExpressionText() {
        return this.getText();
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public SimpleBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public boolean matches(Exchange exchange) {
        if (this.predicate == null) {
            this.predicate = this.createPredicate(exchange);
        }
        return this.predicate.matches(exchange);
    }

    public <T> T evaluate(Exchange exchange, Class<T> type) {
        if (this.expression == null) {
            this.expression = this.createExpression(exchange);
        }
        return (T)this.expression.evaluate(exchange, type);
    }

    private Predicate createPredicate(Exchange exchange) {
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ScriptHelper.resolveOptionalExternalScript((CamelContext)exchange.getContext(), (Exchange)exchange, (String)resolve);
            Language simple = exchange.getContext().resolveLanguage("simple");
            return simple.createPredicate(resolve);
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
    }

    private Expression createExpression(Exchange exchange) {
        try {
            String resolve = exchange.getContext().resolvePropertyPlaceholders(this.text);
            resolve = ScriptHelper.resolveOptionalExternalScript((CamelContext)exchange.getContext(), (Exchange)exchange, (String)resolve);
            Language simple = exchange.getContext().resolveLanguage("simple");
            return SimpleBuilder.createSimpleExpression(simple, resolve, this.resultType);
        }
        catch (Exception e) {
            throw CamelExecutionException.wrapCamelExecutionException((Exchange)exchange, (Throwable)e);
        }
    }

    private static Expression createSimpleExpression(Language simple, String expression, Class<?> resultType) {
        if (resultType == Boolean.class || resultType == Boolean.TYPE) {
            Predicate predicate = simple.createPredicate(expression);
            return PredicateToExpressionAdapter.toExpression((Predicate)predicate);
        }
        Expression exp = simple.createExpression(expression);
        if (resultType != null) {
            exp = ExpressionBuilder.convertToExpression((Expression)exp, resultType);
        }
        return exp;
    }

    public String toString() {
        return "Simple: " + this.text;
    }
}

