/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Message;
import org.apache.camel.Traceable;
import org.apache.camel.impl.engine.DefaultProducerCache;
import org.apache.camel.impl.engine.EmptyProducerCache;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingSlip
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(RoutingSlip.class);
    protected String id;
    protected String routeId;
    protected ProducerCache producerCache;
    protected int cacheSize;
    protected boolean ignoreInvalidEndpoints;
    protected String header;
    protected Expression expression;
    protected String uriDelimiter;
    protected final CamelContext camelContext;
    protected AsyncProcessor errorHandler;

    public RoutingSlip(CamelContext camelContext) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        this.camelContext = camelContext;
    }

    public RoutingSlip(CamelContext camelContext, Expression expression, String uriDelimiter) {
        ObjectHelper.notNull((Object)camelContext, (String)"camelContext");
        ObjectHelper.notNull((Object)expression, (String)"expression");
        this.camelContext = camelContext;
        this.expression = expression;
        this.uriDelimiter = uriDelimiter;
        this.header = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setDelimiter(String delimiter) {
        this.uriDelimiter = delimiter;
    }

    public boolean isIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(boolean ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public AsyncProcessor getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(AsyncProcessor errorHandler) {
        this.errorHandler = errorHandler;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "routingSlip[" + this.expression + "]";
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException((Throwable)new IllegalStateException("RoutingSlip has not been started: " + (Object)((Object)this)));
            callback.done(true);
            return true;
        }
        Expression exp = this.expression;
        Object slip = exchange.removeProperty("CamelEvaluateExpressionResult");
        if (slip != null) {
            exp = slip instanceof Expression ? (Expression)slip : ExpressionBuilder.constantExpression((Object)slip);
        }
        return this.doRoutingSlipWithExpression(exchange, exp, callback);
    }

    protected RoutingSlipIterator createRoutingSlipIterator(Exchange exchange, Expression expression) throws Exception {
        Object slip = expression.evaluate(exchange, Object.class);
        if (exchange.getException() != null) {
            throw exchange.getException();
        }
        final Iterator delegate = org.apache.camel.support.ObjectHelper.createIterator((Object)slip, (String)this.uriDelimiter);
        return new RoutingSlipIterator(){

            @Override
            public boolean hasNext(Exchange exchange) {
                return delegate.hasNext();
            }

            @Override
            public Object next(Exchange exchange) {
                return delegate.next();
            }
        };
    }

    private boolean doRoutingSlipWithExpression(Exchange exchange, Expression expression, AsyncCallback originalCallback) {
        RoutingSlipIterator iter;
        Exchange current = exchange;
        try {
            iter = this.createRoutingSlipIterator(exchange, expression);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            originalCallback.done(true);
            return true;
        }
        if (current.hasProperties()) {
            current.setProperty("CamelSlipEndpoint", null);
        }
        while (iter.hasNext(current)) {
            FailedToCreateProducerException e;
            Endpoint endpoint;
            try {
                endpoint = this.resolveEndpoint(iter, exchange);
                if (endpoint == null) {
                    continue;
                }
            }
            catch (Exception e2) {
                current.setException((Throwable)e2);
                break;
            }
            boolean sync = this.processExchange(endpoint, current, exchange, originalCallback, iter);
            current = this.prepareExchangeForRoutingSlip(current, endpoint);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)exchange.getExchangeId());
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing exchangeId: {} is continued being processed synchronously", (Object)exchange.getExchangeId());
            }
            if (this.isIgnoreInvalidEndpoints() && (e = (FailedToCreateProducerException)current.getException(FailedToCreateProducerException.class)) != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                }
                current.setException(null);
            }
            if (PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) continue;
            break;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)current);
        }
        ExchangeHelper.copyResults((Exchange)exchange, (Exchange)current);
        originalCallback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(RoutingSlipIterator iter, Exchange exchange) throws Exception {
        Object nextRecipient = iter.next(exchange);
        Endpoint endpoint = null;
        try {
            endpoint = ExchangeHelper.resolveEndpoint((Exchange)exchange, (Object)nextRecipient);
        }
        catch (Exception e) {
            if (this.isIgnoreInvalidEndpoints()) {
                LOG.info("Endpoint uri is invalid: " + nextRecipient + ". This exception will be ignored.", (Throwable)e);
            }
            throw e;
        }
        return endpoint;
    }

    protected Exchange prepareExchangeForRoutingSlip(Exchange current, Endpoint endpoint) {
        Exchange copy = ExchangeHelper.createCopy((Exchange)current, (boolean)true);
        ExchangeHelper.prepareOutToIn((Exchange)copy);
        MessageHelper.resetStreamCache((Message)copy.getIn());
        return copy;
    }

    protected AsyncProcessor createErrorHandler(RouteContext routeContext, Exchange exchange, AsyncProcessor processor, Endpoint endpoint) {
        AsyncProcessor answer = processor;
        boolean tryBlock = (Boolean)exchange.getProperty("TryRouteBlock", (Object)false, Boolean.TYPE);
        if (!tryBlock && routeContext != null && this.errorHandler != null) {
            answer = this.errorHandler;
        }
        return answer;
    }

    protected boolean processExchange(final Endpoint endpoint, Exchange exchange, final Exchange original, AsyncCallback originalCallback, final RoutingSlipIterator iter) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing exchangeId: {} >>> {}", (Object)exchange.getExchangeId(), (Object)exchange);
        }
        AsyncCallback callback = doneSync -> {
            if (!doneSync) {
                originalCallback.done(false);
            }
        };
        return this.producerCache.doInAsyncProducer(endpoint, exchange, callback, (p, ex, cb) -> {
            RouteContext routeContext = ex.getUnitOfWork() != null ? ex.getUnitOfWork().getRouteContext() : null;
            AsyncProcessor target = this.createErrorHandler(routeContext, ex, (AsyncProcessor)p, endpoint);
            ex.setProperty("CamelToEndpoint", (Object)endpoint.getEndpointUri());
            ex.setProperty("CamelSlipEndpoint", (Object)endpoint.getEndpointUri());
            ex.setProperty("CamelSlipProducer", (Object)p);
            return target.process(ex, new AsyncCallback(){

                public void done(boolean doneSync) {
                    ex.removeProperty("CamelSlipProducer");
                    if (doneSync) {
                        cb.done(true);
                        return;
                    }
                    try {
                        Exchange current = RoutingSlip.this.prepareExchangeForRoutingSlip(ex, endpoint);
                        while (iter.hasNext(current)) {
                            Endpoint endpoint1;
                            FailedToCreateProducerException e;
                            if (RoutingSlip.this.isIgnoreInvalidEndpoints() && (e = (FailedToCreateProducerException)current.getException(FailedToCreateProducerException.class)) != null) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Endpoint uri is invalid: " + endpoint + ". This exception will be ignored.", (Throwable)e);
                                }
                                current.setException(null);
                            }
                            if (!PipelineHelper.continueProcessing(current, "so breaking out of the routing slip", LOG)) break;
                            try {
                                endpoint1 = RoutingSlip.this.resolveEndpoint(iter, ex);
                                if (endpoint1 == null) {
                                    continue;
                                }
                            }
                            catch (Exception e2) {
                                current.setException((Throwable)e2);
                                break;
                            }
                            boolean sync = RoutingSlip.this.processExchange(endpoint1, current, original, cb, iter);
                            current = RoutingSlip.this.prepareExchangeForRoutingSlip(current, endpoint1);
                            if (sync) continue;
                            if (LOG.isTraceEnabled()) {
                                LOG.trace("Processing exchangeId: {} is continued being processed asynchronously", (Object)original.getExchangeId());
                            }
                            return;
                        }
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Processing complete for exchangeId: {} >>> {}", (Object)original.getExchangeId(), (Object)current);
                        }
                        ExchangeHelper.copyResults((Exchange)original, (Exchange)current);
                    }
                    catch (Throwable e) {
                        ex.setException(e);
                    }
                    cb.done(false);
                }
            });
        });
    }

    protected void doStart() throws Exception {
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache((Object)this, this.camelContext);
                LOG.debug("RoutingSlip {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("RoutingSlip {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.producerCache, this.errorHandler});
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    private Message getResultMessage(Exchange exchange) {
        return exchange.getMessage();
    }

    private void copyOutToIn(Exchange result, Exchange source) {
        result.setException((Throwable)source.getException());
        result.setIn(this.getResultMessage(source));
        result.getProperties().clear();
        result.getProperties().putAll(source.getProperties());
    }

    public AsyncProcessor newRoutingSlipProcessorForErrorHandler() {
        return new RoutingSlipProcessor();
    }

    private final class RoutingSlipProcessor
    extends AsyncProcessorSupport {
        private RoutingSlipProcessor() {
        }

        public boolean process(Exchange exchange, AsyncCallback callback) {
            AsyncProcessor producer = (AsyncProcessor)exchange.getProperty("CamelSlipProducer", AsyncProcessor.class);
            return producer.process(exchange, callback);
        }

        public String toString() {
            return "RoutingSlipProcessor";
        }
    }

    protected static interface RoutingSlipIterator {
        public boolean hasNext(Exchange var1);

        public Object next(Exchange var1);
    }
}

