/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.PropertiesComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesComponentFactoryResolver {
    public static final String RESOURCE_PATH = "META-INF/services/org/apache/camel/";
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesComponentFactoryResolver.class);
    private FactoryFinder factoryFinder;

    public PropertiesComponent resolve(CamelContext context) {
        Class<?> type = null;
        try {
            type = this.findFactory("properties-component-factory", context);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found PropertiesComponent: {} via: {}{}", new Object[]{type.getName(), this.factoryFinder.getResourcePath(), "properties-component-factory"});
            }
            if (PropertiesComponent.class.isAssignableFrom(type)) {
                PropertiesComponent answer = (PropertiesComponent)context.getInjector().newInstance(type, false);
                LOG.debug("Detected and using PropertiesComponent: {}", (Object)answer);
                return answer;
            }
            throw new IllegalArgumentException("Type is not a PropertiesComponent implementation. Found: " + type.getName());
        }
        return new org.apache.camel.component.properties.PropertiesComponent();
    }

    private Class<?> findFactory(String name, CamelContext context) throws IOException {
        if (this.factoryFinder == null) {
            this.factoryFinder = ((ExtendedCamelContext)context.adapt(ExtendedCamelContext.class)).getFactoryFinder(RESOURCE_PATH);
        }
        return this.factoryFinder.findClass(name).orElse(null);
    }
}

