/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import com.cedarsoftware.util.DeepEquals;
import com.cedarsoftware.util.ReflectionUtils;
import com.cedarsoftware.util.Traverser;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class GraphComparator {
    public static final String ROOT = "-root-";

    public static List<Delta> compare(Object source, Object target, final ID idFetcher) {
        LinkedHashSet<Delta> deltas = new LinkedHashSet<Delta>();
        HashSet<String> visited = new HashSet<String>();
        LinkedList<Delta> stack = new LinkedList<Delta>();
        stack.push(new Delta(0L, ROOT, ROOT, source, target, null));
        while (!stack.isEmpty()) {
            Delta delta = (Delta)stack.pop();
            String path = delta.srcPtr;
            if (!stack.isEmpty()) {
                path = path + "." + System.identityHashCode(((Delta)stack.peek()).srcValue);
            }
            if (visited.contains(path)) continue;
            Object srcValue = delta.srcValue;
            Object targetValue = delta.targetValue;
            visited.add(path);
            if (srcValue == targetValue) continue;
            if (srcValue == null || targetValue == null) {
                delta.setCmd(Delta.Command.OBJECT_ASSIGN_FIELD);
                deltas.add(delta);
                continue;
            }
            if (!(srcValue.getClass().equals(targetValue.getClass()) || srcValue instanceof Map && targetValue instanceof Map || srcValue instanceof Set && targetValue instanceof Set || srcValue instanceof List && targetValue instanceof List)) {
                delta.setCmd(Delta.Command.OBJECT_FIELD_TYPE_CHANGED);
                deltas.add(delta);
                continue;
            }
            if (GraphComparator.isLogicalPrimitive(srcValue.getClass())) {
                if (srcValue.equals(targetValue)) continue;
                delta.setCmd(Delta.Command.OBJECT_ASSIGN_FIELD);
                deltas.add(delta);
                continue;
            }
            if (srcValue.getClass().isArray()) {
                GraphComparator.compareArrays(delta, deltas, stack, idFetcher);
                continue;
            }
            if (srcValue instanceof Set) {
                GraphComparator.compareSets(delta, deltas, stack, idFetcher);
                continue;
            }
            if (srcValue instanceof Map) {
                GraphComparator.compareMaps(delta, deltas, stack, idFetcher);
                continue;
            }
            if (srcValue instanceof List) {
                GraphComparator.compareLists(delta, deltas, stack, idFetcher);
                continue;
            }
            if (srcValue instanceof Collection) {
                throw new RuntimeException("Detected custom Collection that does not extend List or Set: " + srcValue.getClass().getName() + ". GraphUtils.compare() needs to be updated to support it, obj id: " + delta.id + ", field: " + delta.fieldName);
            }
            if (GraphComparator.isIdObject(srcValue, idFetcher) && GraphComparator.isIdObject(targetValue, idFetcher)) {
                Object targetId;
                Object srcId = idFetcher.getId(srcValue);
                if (!srcId.equals(targetId = idFetcher.getId(targetValue))) {
                    delta.setCmd(Delta.Command.OBJECT_ASSIGN_FIELD);
                    deltas.add(delta);
                    continue;
                }
                Collection<Field> fields = ReflectionUtils.getDeepDeclaredFields(srcValue.getClass());
                String sysId = "(" + System.identityHashCode(srcValue) + ").";
                for (Field field : fields) {
                    try {
                        String srcPtr = sysId + field.getName();
                        stack.push(new Delta(srcId, field.getName(), srcPtr, field.get(srcValue), field.get(targetValue), null));
                    }
                    catch (Exception exception) {}
                }
                continue;
            }
            if (DeepEquals.deepEquals(srcValue, targetValue)) continue;
            delta.setCmd(Delta.Command.OBJECT_ASSIGN_FIELD);
            deltas.add(delta);
        }
        final HashSet potentialOrphans = new HashSet();
        Traverser.traverse(source, new Traverser.Visitor(){

            @Override
            public void process(Object o) {
                if (GraphComparator.isIdObject(o, idFetcher)) {
                    potentialOrphans.add(idFetcher.getId(o));
                }
            }
        });
        Traverser.traverse(target, new Traverser.Visitor(){

            @Override
            public void process(Object o) {
                if (GraphComparator.isIdObject(o, idFetcher)) {
                    potentialOrphans.remove(idFetcher.getId(o));
                }
            }
        });
        ArrayList<Delta> forReturn = new ArrayList<Delta>(deltas);
        for (Object id : potentialOrphans) {
            Delta orphanDelta = new Delta(id, null, "", null, null, null);
            orphanDelta.setCmd(Delta.Command.OBJECT_ORPHAN);
            forReturn.add(orphanDelta);
        }
        return forReturn;
    }

    private static boolean isLogicalPrimitive(Class<?> c) {
        return c.isPrimitive() || String.class == c || Date.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c) || Boolean.class.isAssignableFrom(c) || Calendar.class.isAssignableFrom(c) || TimeZone.class.isAssignableFrom(c) || Character.class == c;
    }

    private static boolean isIdObject(Object o, ID idFetcher) {
        if (o == null) {
            return false;
        }
        Class<?> c = o.getClass();
        if (GraphComparator.isLogicalPrimitive(c) || c.isArray() || Collection.class.isAssignableFrom(c) || Map.class.isAssignableFrom(c) || Object.class == c) {
            return false;
        }
        try {
            idFetcher.getId(o);
            return true;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private static void compareArrays(Delta delta, Collection<Delta> deltas, LinkedList<Delta> stack, ID idFetcher) {
        int targetLen;
        int srcLen = Array.getLength(delta.srcValue);
        if (srcLen != (targetLen = Array.getLength(delta.targetValue))) {
            delta.setCmd(Delta.Command.ARRAY_RESIZE);
            delta.setOptionalKey(targetLen);
            deltas.add(delta);
        }
        String sysId = "(" + System.identityHashCode(delta.srcValue) + ')';
        Class<?> compType = delta.targetValue.getClass().getComponentType();
        if (GraphComparator.isLogicalPrimitive(compType)) {
            for (int i = 0; i < targetLen; ++i) {
                Object targetValue = Array.get(delta.targetValue, i);
                String srcPtr = sysId + '[' + i + ']';
                if (i < srcLen) {
                    Object srcValue = Array.get(delta.srcValue, i);
                    if (!(srcValue == null && targetValue != null || srcValue != null && targetValue == null) && srcValue.equals(targetValue)) continue;
                    GraphComparator.copyArrayElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                    continue;
                }
                GraphComparator.copyArrayElement(delta, deltas, srcPtr, null, targetValue, i);
            }
        } else {
            for (int i = targetLen - 1; i >= 0; --i) {
                Object targetValue = Array.get(delta.targetValue, i);
                String srcPtr = sysId + '[' + i + ']';
                if (i < srcLen) {
                    Object srcValue = Array.get(delta.srcValue, i);
                    if (targetValue == null || srcValue == null) {
                        if (srcValue == targetValue) continue;
                        GraphComparator.copyArrayElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                        continue;
                    }
                    if (GraphComparator.isIdObject(srcValue, idFetcher) && GraphComparator.isIdObject(targetValue, idFetcher)) {
                        Object srcId = idFetcher.getId(srcValue);
                        Object targetId = idFetcher.getId(targetValue);
                        if (targetId.equals(srcId)) {
                            stack.push(new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetValue, i));
                            continue;
                        }
                        GraphComparator.copyArrayElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                        continue;
                    }
                    if (DeepEquals.deepEquals(srcValue, targetValue)) continue;
                    GraphComparator.copyArrayElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                    continue;
                }
                GraphComparator.copyArrayElement(delta, deltas, srcPtr, null, targetValue, i);
            }
        }
    }

    private static void copyArrayElement(Delta delta, Collection<Delta> deltas, String srcPtr, Object srcValue, Object targetValue, int index) {
        Delta copyDelta = new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetValue, index);
        copyDelta.setCmd(Delta.Command.ARRAY_SET_ELEMENT);
        deltas.add(copyDelta);
    }

    private static void compareSets(Delta delta, Collection<Delta> deltas, LinkedList<Delta> stack, ID idFetcher) {
        String srcPtr;
        Set srcSet = (Set)delta.srcValue;
        Set targetSet = (Set)delta.targetValue;
        HashMap targetIdToValue = new HashMap();
        for (Object targetValue : targetSet) {
            if (!GraphComparator.isIdObject(targetValue, idFetcher)) continue;
            targetIdToValue.put(idFetcher.getId(targetValue), targetValue);
        }
        HashMap srcIdToValue = new HashMap();
        String sysId = "(" + System.identityHashCode(srcSet) + ").remove(";
        for (Object srcValue : srcSet) {
            srcPtr = sysId + System.identityHashCode(srcValue) + ')';
            if (GraphComparator.isIdObject(srcValue, idFetcher)) {
                Object srcId = idFetcher.getId(srcValue);
                srcIdToValue.put(srcId, srcValue);
                if (targetIdToValue.containsKey(srcId)) {
                    stack.push(new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetIdToValue.get(srcId), null));
                    continue;
                }
                Delta removeDelta = new Delta(delta.id, delta.fieldName, srcPtr, srcValue, null, null);
                removeDelta.setCmd(Delta.Command.SET_REMOVE);
                deltas.add(removeDelta);
                continue;
            }
            if (targetSet.contains(srcValue)) continue;
            Delta removeDelta = new Delta(delta.id, delta.fieldName, srcPtr, srcValue, null, null);
            removeDelta.setCmd(Delta.Command.SET_REMOVE);
            deltas.add(removeDelta);
        }
        sysId = "(" + System.identityHashCode(targetSet) + ").add(";
        for (Object targetValue : targetSet) {
            srcPtr = sysId + System.identityHashCode(targetValue) + ')';
            if (GraphComparator.isIdObject(targetValue, idFetcher)) {
                Object targetId = idFetcher.getId(targetValue);
                if (srcIdToValue.containsKey(targetId)) continue;
                Delta addDelta = new Delta(delta.id, delta.fieldName, srcPtr, null, targetValue, null);
                addDelta.setCmd(Delta.Command.SET_ADD);
                deltas.add(addDelta);
                continue;
            }
            if (srcSet.contains(targetValue)) continue;
            Delta addDelta = new Delta(delta.id, delta.fieldName, srcPtr, null, targetValue, null);
            addDelta.setCmd(Delta.Command.SET_ADD);
            deltas.add(addDelta);
        }
    }

    private static void compareMaps(Delta delta, Collection<Delta> deltas, LinkedList<Delta> stack, ID idFetcher) {
        Map srcMap = (Map)delta.srcValue;
        Map targetMap = (Map)delta.targetValue;
        String sysId = "(" + System.identityHashCode(srcMap) + ')';
        for (Map.Entry entry : srcMap.entrySet()) {
            Object srcKey = entry.getKey();
            Object srcValue = entry.getValue();
            String srcPtr = sysId + "['" + System.identityHashCode(srcKey) + "']";
            if (targetMap.containsKey(srcKey)) {
                Object targetValue = targetMap.get(srcKey);
                if (srcValue == null || targetValue == null) {
                    if (srcValue == targetValue) continue;
                    GraphComparator.addMapPutDelta(delta, deltas, srcPtr, targetValue, srcKey);
                    continue;
                }
                if (GraphComparator.isIdObject(srcValue, idFetcher) && GraphComparator.isIdObject(targetValue, idFetcher)) {
                    if (idFetcher.getId(srcValue).equals(idFetcher.getId(targetValue))) {
                        stack.push(new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetValue, null));
                        continue;
                    }
                    GraphComparator.addMapPutDelta(delta, deltas, srcPtr, targetValue, srcKey);
                    continue;
                }
                if (DeepEquals.deepEquals(srcValue, targetValue)) continue;
                GraphComparator.addMapPutDelta(delta, deltas, srcPtr, targetValue, srcKey);
                continue;
            }
            Delta removeDelta = new Delta(delta.id, delta.fieldName, srcPtr, srcValue, null, srcKey);
            removeDelta.setCmd(Delta.Command.MAP_REMOVE);
            deltas.add(removeDelta);
        }
        for (Map.Entry entry : targetMap.entrySet()) {
            Object targetKey = entry.getKey();
            String srcPtr = sysId + "['" + System.identityHashCode(targetKey) + "']";
            if (srcMap.containsKey(targetKey)) continue;
            Delta putDelta = new Delta(delta.id, delta.fieldName, srcPtr, null, entry.getValue(), targetKey);
            putDelta.setCmd(Delta.Command.MAP_PUT);
            deltas.add(putDelta);
        }
    }

    private static void addMapPutDelta(Delta delta, Collection<Delta> deltas, String srcPtr, Object targetValue, Object key) {
        Delta putDelta = new Delta(delta.id, delta.fieldName, srcPtr, null, targetValue, key);
        putDelta.setCmd(Delta.Command.MAP_PUT);
        deltas.add(putDelta);
    }

    private static void compareLists(Delta delta, Collection<Delta> deltas, LinkedList<Delta> stack, ID idFetcher) {
        int targetLen;
        List srcList = (List)delta.srcValue;
        List targetList = (List)delta.targetValue;
        int srcLen = srcList.size();
        if (srcLen != (targetLen = targetList.size())) {
            delta.setCmd(Delta.Command.LIST_RESIZE);
            delta.setOptionalKey(targetLen);
            deltas.add(delta);
        }
        String sysId = "(" + System.identityHashCode(srcList) + ')';
        for (int i = targetLen - 1; i >= 0; --i) {
            Object targetValue = targetList.get(i);
            String srcPtr = sysId + '{' + i + '}';
            if (i < srcLen) {
                Object srcValue = srcList.get(i);
                if (targetValue == null || srcValue == null) {
                    if (srcValue == targetValue) continue;
                    GraphComparator.copyListElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                    continue;
                }
                if (GraphComparator.isIdObject(srcValue, idFetcher) && GraphComparator.isIdObject(targetValue, idFetcher)) {
                    Object srcId = idFetcher.getId(srcValue);
                    Object targetId = idFetcher.getId(targetValue);
                    if (targetId.equals(srcId)) {
                        stack.push(new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetValue, i));
                        continue;
                    }
                    GraphComparator.copyListElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                    continue;
                }
                if (DeepEquals.deepEquals(srcValue, targetValue)) continue;
                GraphComparator.copyListElement(delta, deltas, srcPtr, srcValue, targetValue, i);
                continue;
            }
            GraphComparator.copyListElement(delta, deltas, srcPtr, null, targetValue, i);
        }
    }

    private static void copyListElement(Delta delta, Collection<Delta> deltas, String srcPtr, Object srcValue, Object targetValue, int index) {
        Delta copyDelta = new Delta(delta.id, delta.fieldName, srcPtr, srcValue, targetValue, index);
        copyDelta.setCmd(Delta.Command.LIST_SET_ELEMENT);
        deltas.add(copyDelta);
    }

    public static List<DeltaError> applyDelta(Object source, List<Delta> commands, final ID idFetcher, DeltaProcessor deltaProcessor, boolean ... failFast) {
        final HashMap srcMap = new HashMap();
        Traverser.traverse(source, new Traverser.Visitor(){

            @Override
            public void process(Object o) {
                if (GraphComparator.isIdObject(o, idFetcher)) {
                    srcMap.put(idFetcher.getId(o), o);
                }
            }
        });
        ArrayList<DeltaError> errors = new ArrayList<DeltaError>();
        boolean failQuick = failFast != null && failFast.length == 1 && failFast[0];
        for (Delta delta : commands) {
            if (failQuick && errors.size() == 1) {
                return errors;
            }
            Object srcValue = srcMap.get(delta.id);
            if (srcValue == null) {
                errors.add(new DeltaError((Object)((Object)delta.cmd) + " failed, source object not found, obj id: " + delta.id, delta));
                continue;
            }
            Map<String, Field> fields = ReflectionUtils.getDeepDeclaredFieldMap(srcValue.getClass());
            Field field = fields.get(delta.fieldName);
            if (field == null && Delta.Command.OBJECT_ORPHAN != delta.cmd) {
                errors.add(new DeltaError((Object)((Object)delta.cmd) + " failed, field name missing: " + delta.fieldName + ", obj id: " + delta.id, delta));
                continue;
            }
            try {
                switch (delta.cmd) {
                    case ARRAY_SET_ELEMENT: {
                        deltaProcessor.processArraySetElement(srcValue, field, delta);
                        break;
                    }
                    case ARRAY_RESIZE: {
                        deltaProcessor.processArrayResize(srcValue, field, delta);
                        break;
                    }
                    case OBJECT_ASSIGN_FIELD: {
                        deltaProcessor.processObjectAssignField(srcValue, field, delta);
                        break;
                    }
                    case OBJECT_ORPHAN: {
                        deltaProcessor.processObjectOrphan(srcValue, field, delta);
                        break;
                    }
                    case OBJECT_FIELD_TYPE_CHANGED: {
                        deltaProcessor.processObjectTypeChanged(srcValue, field, delta);
                        break;
                    }
                    case SET_ADD: {
                        deltaProcessor.processSetAdd(srcValue, field, delta);
                        break;
                    }
                    case SET_REMOVE: {
                        deltaProcessor.processSetRemove(srcValue, field, delta);
                        break;
                    }
                    case MAP_PUT: {
                        deltaProcessor.processMapPut(srcValue, field, delta);
                        break;
                    }
                    case MAP_REMOVE: {
                        deltaProcessor.processMapRemove(srcValue, field, delta);
                        break;
                    }
                    case LIST_RESIZE: {
                        deltaProcessor.processListResize(srcValue, field, delta);
                        break;
                    }
                    case LIST_SET_ELEMENT: {
                        deltaProcessor.processListSetElement(srcValue, field, delta);
                        break;
                    }
                    default: {
                        errors.add(new DeltaError("Unknown command: " + (Object)((Object)delta.cmd), delta));
                        break;
                    }
                }
            }
            catch (Exception e) {
                StringBuilder str = new StringBuilder();
                Throwable t = e;
                do {
                    str.append(t.getMessage());
                    t = t.getCause();
                    if (t == null) continue;
                    str.append(", caused by: ");
                } while (t != null);
                errors.add(new DeltaError(str.toString(), delta));
            }
        }
        return errors;
    }

    public static DeltaProcessor getJavaDeltaProcessor() {
        return new JavaDeltaProcessor();
    }

    private static class JavaDeltaProcessor
    implements DeltaProcessor {
        private JavaDeltaProcessor() {
        }

        @Override
        public void processArraySetElement(Object source, Field field, Delta delta) {
            int srcArrayLen;
            if (!field.getType().isArray()) {
                throw new RuntimeException((Object)((Object)delta.cmd) + " failed, field: " + field.getName() + " is not an Array [] type, obj id: " + delta.id + ", position: " + DeltaProcessor.Helper.getStringValue(delta.optionalKey));
            }
            Object sourceArray = DeltaProcessor.Helper.getFieldValueAs(source, field, field.getType(), delta);
            int pos = DeltaProcessor.Helper.getResizeValue(delta);
            if (pos >= (srcArrayLen = Array.getLength(sourceArray))) {
                throw new ArrayIndexOutOfBoundsException((Object)((Object)delta.cmd) + " failed, index out of bounds: " + pos + ", array size: " + srcArrayLen + ", field: " + field.getName() + ", obj id: " + delta.id);
            }
            Array.set(sourceArray, pos, delta.targetValue);
        }

        @Override
        public void processArrayResize(Object source, Field field, Delta delta) {
            if (!field.getType().isArray()) {
                throw new RuntimeException((Object)((Object)delta.cmd) + " failed, field: " + field.getName() + " is not an Array [] type, obj id: " + delta.id + ", new size: " + DeltaProcessor.Helper.getStringValue(delta.optionalKey));
            }
            int newSize = DeltaProcessor.Helper.getResizeValue(delta);
            Object sourceArray = DeltaProcessor.Helper.getFieldValueAs(source, field, field.getType(), delta);
            int maxKeepLen = Math.min(newSize, Array.getLength(sourceArray));
            Object newArray = Array.newInstance(field.getType().getComponentType(), newSize);
            System.arraycopy(sourceArray, 0, newArray, 0, maxKeepLen);
            try {
                field.set(source, newArray);
            }
            catch (Exception e) {
                throw new RuntimeException((Object)((Object)delta.cmd) + " failed, could not reassign array to field: " + field.getName() + " with value: " + DeltaProcessor.Helper.getStringValue(delta.targetValue) + ", obj id: " + delta.id + ", optionalKey: " + delta.optionalKey, e);
            }
        }

        @Override
        public void processObjectAssignField(Object source, Field field, Delta delta) {
            try {
                field.set(source, delta.targetValue);
            }
            catch (Exception e) {
                throw new RuntimeException((Object)((Object)delta.cmd) + " failed, unable to set object field: " + field.getName() + " with value: " + DeltaProcessor.Helper.getStringValue(delta.targetValue) + ", obj id: " + delta.id, e);
            }
        }

        @Override
        public void processObjectOrphan(Object srcValue, Field field, Delta delta) {
        }

        @Override
        public void processObjectTypeChanged(Object srcValue, Field field, Delta delta) {
            throw new RuntimeException((Object)((Object)delta.cmd) + " failed, field: " + field.getName() + ", obj id: " + delta.id);
        }

        @Override
        public void processSetAdd(Object source, Field field, Delta delta) {
            Set set = (Set)DeltaProcessor.Helper.getFieldValueAs(source, field, Set.class, delta);
            set.add(delta.getTargetValue());
        }

        @Override
        public void processSetRemove(Object source, Field field, Delta delta) {
            Set set = (Set)DeltaProcessor.Helper.getFieldValueAs(source, field, Set.class, delta);
            set.remove(delta.getSourceValue());
        }

        @Override
        public void processMapPut(Object source, Field field, Delta delta) {
            Map map = (Map)DeltaProcessor.Helper.getFieldValueAs(source, field, Map.class, delta);
            map.put(delta.optionalKey, delta.getTargetValue());
        }

        @Override
        public void processMapRemove(Object source, Field field, Delta delta) {
            Map map = (Map)DeltaProcessor.Helper.getFieldValueAs(source, field, Map.class, delta);
            map.remove(delta.optionalKey);
        }

        @Override
        public void processListResize(Object source, Field field, Delta delta) {
            block3: {
                int deltaLen;
                List list;
                block2: {
                    list = (List)DeltaProcessor.Helper.getFieldValueAs(source, field, List.class, delta);
                    int newSize = DeltaProcessor.Helper.getResizeValue(delta);
                    deltaLen = newSize - list.size();
                    if (deltaLen <= 0) break block2;
                    for (int i = 0; i < deltaLen; ++i) {
                        list.add(null);
                    }
                    break block3;
                }
                if (deltaLen >= 0) break block3;
                deltaLen = -deltaLen;
                for (int i = 0; i < deltaLen; ++i) {
                    list.remove(list.size() - 1);
                }
            }
        }

        @Override
        public void processListSetElement(Object source, Field field, Delta delta) {
            int listLen;
            List list = (List)DeltaProcessor.Helper.getFieldValueAs(source, field, List.class, delta);
            int pos = DeltaProcessor.Helper.getResizeValue(delta);
            if (pos >= (listLen = list.size())) {
                throw new IndexOutOfBoundsException((Object)((Object)delta.cmd) + " failed, index out of bounds: " + pos + ", list size: " + list.size() + ", field: " + field.getName() + ", obj id: " + delta.id);
            }
            list.set(pos, delta.targetValue);
        }
    }

    public static interface DeltaProcessor {
        public void processArraySetElement(Object var1, Field var2, Delta var3);

        public void processArrayResize(Object var1, Field var2, Delta var3);

        public void processObjectAssignField(Object var1, Field var2, Delta var3);

        public void processObjectOrphan(Object var1, Field var2, Delta var3);

        public void processObjectTypeChanged(Object var1, Field var2, Delta var3);

        public void processSetAdd(Object var1, Field var2, Delta var3);

        public void processSetRemove(Object var1, Field var2, Delta var3);

        public void processMapPut(Object var1, Field var2, Delta var3);

        public void processMapRemove(Object var1, Field var2, Delta var3);

        public void processListResize(Object var1, Field var2, Delta var3);

        public void processListSetElement(Object var1, Field var2, Delta var3);

        public static class Helper {
            private static Object getFieldValueAs(Object source, Field field, Class<?> type, Delta delta) {
                Object fieldValue;
                try {
                    fieldValue = field.get(source);
                }
                catch (Exception e) {
                    throw new RuntimeException((Object)((Object)delta.cmd) + " failed, unable to access field: " + field.getName() + ", obj id: " + delta.id + ", optionalKey: " + Helper.getStringValue(delta.optionalKey), e);
                }
                if (fieldValue == null) {
                    throw new RuntimeException((Object)((Object)delta.cmd) + " failed, null value at field: " + field.getName() + ", obj id: " + delta.id + ", optionalKey: " + Helper.getStringValue(delta.optionalKey));
                }
                if (!type.isAssignableFrom(fieldValue.getClass())) {
                    throw new ClassCastException((Object)((Object)delta.cmd) + " failed, field: " + field.getName() + " is not of type: " + type.getName() + ", obj id: " + delta.id + ", optionalKey: " + Helper.getStringValue(delta.optionalKey));
                }
                return fieldValue;
            }

            private static int getResizeValue(Delta delta) {
                boolean rightType;
                boolean bl = rightType = delta.optionalKey instanceof Integer || delta.optionalKey instanceof Long || delta.optionalKey instanceof Short || delta.optionalKey instanceof Byte || delta.optionalKey instanceof BigInteger;
                if (rightType && ((Number)delta.optionalKey).intValue() >= 0) {
                    return ((Number)delta.optionalKey).intValue();
                }
                throw new IllegalArgumentException((Object)((Object)delta.cmd) + " failed, the optionalKey must be a integer value 0 or greater, field: " + delta.fieldName + ", obj id: " + delta.id + ", optionalKey: " + Helper.getStringValue(delta.optionalKey));
            }

            private static String getStringValue(Object foo) {
                if (foo == null) {
                    return "null";
                }
                if (foo.getClass().isArray()) {
                    StringBuilder s = new StringBuilder();
                    s.append('[');
                    int len = Array.getLength(foo);
                    for (int i = 0; i < len; ++i) {
                        Object element = Array.get(foo, i);
                        s.append(element == null ? "null" : element.toString());
                        if (i >= len - 1) continue;
                        s.append(',');
                    }
                    s.append(']');
                    return s.toString();
                }
                return foo.toString();
            }
        }
    }

    public static class DeltaError
    extends Delta {
        private static final long serialVersionUID = 6248596026486571238L;
        public String error;

        public DeltaError(String error, Delta delta) {
            super(delta.getId(), delta.fieldName, delta.srcPtr, delta.srcValue, delta.targetValue, delta.optionalKey);
            this.error = error;
        }

        public String getError() {
            return this.error;
        }
    }

    public static class Delta
    implements Serializable {
        private static final long serialVersionUID = -4388236892818050806L;
        private String srcPtr;
        private Object id;
        private String fieldName;
        private Object srcValue;
        private Object targetValue;
        private Object optionalKey;
        private Command cmd;

        public Delta(Object id, String fieldName, String srcPtr, Object srcValue, Object targetValue, Object optKey) {
            this.id = id;
            this.fieldName = fieldName;
            this.srcPtr = srcPtr;
            this.srcValue = srcValue;
            this.targetValue = targetValue;
            this.optionalKey = optKey;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public Object getSourceValue() {
            return this.srcValue;
        }

        public void setSourceValue(Object srcValue) {
            this.srcValue = srcValue;
        }

        public Object getTargetValue() {
            return this.targetValue;
        }

        public void setTargetValue(Object targetValue) {
            this.targetValue = targetValue;
        }

        public Object getOptionalKey() {
            return this.optionalKey;
        }

        public void setOptionalKey(Object optionalKey) {
            this.optionalKey = optionalKey;
        }

        public Command getCmd() {
            return this.cmd;
        }

        public void setCmd(Command cmd) {
            this.cmd = cmd;
        }

        public String toString() {
            return "Delta {id=" + this.id + ", fieldName='" + this.fieldName + '\'' + ", srcPtr=" + this.srcPtr + ", srcValue=" + this.srcValue + ", targetValue=" + this.targetValue + ", optionalKey=" + this.optionalKey + ", cmd='" + (Object)((Object)this.cmd) + '\'' + '}';
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Delta delta = (Delta)other;
            return this.srcPtr.equals(delta.srcPtr);
        }

        public int hashCode() {
            return this.srcPtr.hashCode();
        }

        public static enum Command {
            ARRAY_SET_ELEMENT("array.setElement"),
            ARRAY_RESIZE("array.resize"),
            OBJECT_ASSIGN_FIELD("object.assignField"),
            OBJECT_ORPHAN("object.orphan"),
            OBJECT_FIELD_TYPE_CHANGED("object.fieldTypeChanged"),
            SET_ADD("set.add"),
            SET_REMOVE("set.remove"),
            MAP_PUT("map.put"),
            MAP_REMOVE("map.remove"),
            LIST_RESIZE("list.resize"),
            LIST_SET_ELEMENT("list.setElement");

            private String name;

            private Command(String name) {
                this.name = name.intern();
            }

            public String getName() {
                return this.name;
            }

            public static Command fromName(String name) {
                if (name == null || "".equals(name.trim())) {
                    throw new IllegalArgumentException("Name is required for Command.forName()");
                }
                name = name.toLowerCase();
                for (Command t : Command.values()) {
                    if (!t.getName().equals(name)) continue;
                    return t;
                }
                throw new IllegalArgumentException("Unknown Command enum: " + name);
            }
        }
    }

    public static interface ID {
        public Object getId(Object var1);
    }
}

