/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cron;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.cron.CronComponent;
import org.apache.camel.component.cron.SpringCronEndpoint;
import org.apache.camel.component.cron.api.CamelCronConfiguration;
import org.apache.camel.component.cron.api.CamelCronService;

public class CamelSpringCronService
implements CamelCronService,
CamelContextAware {
    private CamelContext context;

    public Endpoint createEndpoint(CamelCronConfiguration configuration) throws Exception {
        CronComponent cronComponent = (CronComponent)this.context.getComponent("cron", CronComponent.class);
        String uri = "cron:" + configuration.getName();
        SpringCronEndpoint cronEndpoint = new SpringCronEndpoint(uri, (Component)cronComponent);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("scheduler", "spring");
        options.put("scheduler.cron", configuration.getSchedule());
        cronEndpoint.configureProperties(options);
        return cronEndpoint;
    }

    public String getId() {
        return "spring";
    }

    public void setCamelContext(CamelContext camelContext) {
        this.context = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }
}

