/*
 * Decompiled with CFR 0.152.
 */
package com.ethlo.time;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.temporal.Temporal;

public interface TemporalHandler<T> {
    default public T handle(LocalDateTime localDateTime) {
        return this.fallback(localDateTime);
    }

    default public T handle(LocalDate localDate) {
        return this.fallback(localDate);
    }

    default public T handle(YearMonth yearMonth) {
        return this.fallback(yearMonth);
    }

    default public T handle(Year year) {
        return this.fallback(year);
    }

    default public T handle(OffsetDateTime offsetDateTime) {
        return this.fallback(offsetDateTime);
    }

    default public T fallback(Temporal temporal) {
        throw new UnsupportedOperationException("Unhandled type " + temporal.getClass());
    }
}

