/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kamelet;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.kamelet.KameletComponent;
import org.apache.camel.component.kamelet.KameletProducer;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.service.ServiceHelper;

@ManagedResource(description="Managed Kamelet Processor")
public class KameletProcessor
extends AsyncProcessorSupport
implements CamelContextAware,
Navigate<Processor>,
Traceable,
IdAware,
RouteIdAware {
    private final String name;
    private final AsyncProcessor processor;
    private KameletProducer producer;
    private KameletComponent component;
    private CamelContext camelContext;
    private String id;
    private String routeId;

    public KameletProcessor(CamelContext camelContext, String name, Processor processor) {
        this.camelContext = camelContext;
        this.name = name;
        this.processor = AsyncProcessorConverterHelper.convert((Processor)processor);
    }

    @ManagedAttribute(description="Kamelet name (templateId/routeId?options)")
    public String getName() {
        return this.name;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        return this.producer.process(exchange, callback);
    }

    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>();
        answer.add((Processor)this.processor);
        return answer;
    }

    public boolean hasNext() {
        return true;
    }

    public String getTraceLabel() {
        return "kamelet";
    }

    protected void doBuild() throws Exception {
        if (this.component == null) {
            this.component = (KameletComponent)this.camelContext.getComponent("kamelet", KameletComponent.class);
        }
        if (this.producer == null) {
            this.producer = (KameletProducer)this.camelContext.getEndpoint("kamelet://" + this.name).createAsyncProducer();
        }
        ServiceHelper.buildService((Object[])new Object[]{this.processor, this.producer});
        this.component.addKameletEip(this.producer.getKey(), (Processor)this.processor);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object[])new Object[]{this.processor, this.producer});
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object[])new Object[]{this.processor, this.producer});
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object[])new Object[]{this.processor, this.producer});
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.processor, this.producer});
        this.component.removeKameletEip(this.producer.getKey());
    }
}

