/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.tokenizer;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.TokenizerBuilder;
import org.apache.camel.model.TokenizerDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Tokenizer;

@Metadata(firstVersion="4.8.0", label="eip,transformation,ai", title="LangChain4J Tokenizer")
@XmlRootElement(name="langChain4j")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LangChain4jTokenizerDefinition
extends TokenizerDefinition {
    @XmlAttribute(required=true)
    @Metadata(javaType="org.apache.camel.model.tokenizer.TokenizerType", required=true, enums="OPEN_AI,AZURE,QWEN")
    private String tokenizerType;
    @XmlAttribute(required=true)
    @Metadata(javaType="java.lang.Integer", required=true)
    private String maxTokens;
    @XmlAttribute(required=true)
    @Metadata(javaType="java.lang.Integer", required=true)
    private String maxOverlap;

    public LangChain4jTokenizerDefinition() {
    }

    public LangChain4jTokenizerDefinition(LangChain4jTokenizerDefinition source) {
        super(source);
        this.maxTokens = source.maxTokens;
        this.maxOverlap = source.maxOverlap;
        this.tokenizerType = source.tokenizerType;
    }

    public String getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(String maxTokens) {
        this.maxTokens = maxTokens;
    }

    public String getMaxOverlap() {
        return this.maxOverlap;
    }

    public void setMaxOverlap(String maxOverlap) {
        this.maxOverlap = maxOverlap;
    }

    public String getTokenizerType() {
        return this.tokenizerType;
    }

    public void setTokenizerType(String tokenizerType) {
        this.tokenizerType = tokenizerType;
    }

    private static String toName(String name) {
        return "langchain4j-" + name;
    }

    @Override
    public LangChain4jTokenizerDefinition copyDefinition() {
        return new LangChain4jTokenizerDefinition(this);
    }

    @XmlTransient
    public static class CharacterBuilder
    extends Builder {
        @Override
        protected String name() {
            return LangChain4jTokenizerDefinition.toName("character");
        }
    }

    @XmlTransient
    public static class LineBuilder
    extends Builder {
        @Override
        protected String name() {
            return LangChain4jTokenizerDefinition.toName("line");
        }
    }

    @XmlTransient
    public static class SentenceBuilder
    extends Builder {
        @Override
        protected String name() {
            return LangChain4jTokenizerDefinition.toName("sentence");
        }
    }

    @XmlTransient
    public static class WordBuilder
    extends Builder {
        @Override
        protected String name() {
            return LangChain4jTokenizerDefinition.toName("word");
        }
    }

    @XmlTransient
    public static class ParagraphBuilder
    extends Builder {
        @Override
        protected String name() {
            return LangChain4jTokenizerDefinition.toName("paragraph");
        }
    }

    @XmlTransient
    public static abstract class Builder
    implements TokenizerBuilder<LangChain4jTokenizerDefinition> {
        private int maxTokens;
        private int maxOverlap;
        private TokenizerType tokenizerType;
        private Tokenizer.Configuration configuration;

        public Builder maxTokens(int maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public Builder maxOverlap(int maxOverlap) {
            this.maxOverlap = maxOverlap;
            return this;
        }

        public Builder using(TokenizerType tokenizer) {
            this.tokenizerType = tokenizer;
            return this;
        }

        public Builder configuration(Tokenizer.Configuration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public LangChain4jTokenizerDefinition end() {
            LangChain4jTokenizerDefinition tokenizer = new LangChain4jTokenizerDefinition();
            if (this.configuration != null) {
                tokenizer.setConfiguration(this.configuration);
            } else {
                tokenizer.setMaxTokens(Integer.toString(this.maxTokens));
                tokenizer.setMaxOverlap(Integer.toString(this.maxOverlap));
                tokenizer.setTokenizerType(this.tokenizerType.name());
            }
            tokenizer.setTokenizerName(this.name());
            return tokenizer;
        }

        protected abstract String name();
    }

    @XmlTransient
    public static enum TokenizerType {
        OPEN_AI,
        AZURE,
        QWEN;

    }
}

