/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;
import org.w3c.dom.Node;

@Metadata(firstVersion="2.0.0", label="dataformat,transformation", title="TidyMarkup")
@XmlRootElement(name="tidyMarkup")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TidyMarkupDataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> dataObjectType;
    @XmlAttribute(name="dataObjectType")
    @Metadata(defaultValue="org.w3c.dom.Node", enums="org.w3c.dom.Node,java.lang.String")
    private String dataObjectTypeName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String omitXmlDeclaration;

    public TidyMarkupDataFormat() {
        super("tidyMarkup");
        this.setDataObjectType(Node.class);
    }

    public TidyMarkupDataFormat(Class<?> dataObjectType) {
        this();
        if (!dataObjectType.isAssignableFrom(String.class) && !dataObjectType.isAssignableFrom(Node.class)) {
            throw new IllegalArgumentException("TidyMarkupDataFormat only supports returning a String or a org.w3c.dom.Node object");
        }
        this.setDataObjectType(dataObjectType);
    }

    private TidyMarkupDataFormat(Builder builder) {
        this();
        this.dataObjectType = builder.dataObjectType;
        this.dataObjectTypeName = builder.dataObjectTypeName;
        this.omitXmlDeclaration = builder.omitXmlDeclaration;
    }

    public void setDataObjectType(Class<?> dataObjectType) {
        this.dataObjectType = dataObjectType;
    }

    public Class<?> getDataObjectType() {
        return this.dataObjectType;
    }

    public String getDataObjectTypeName() {
        return this.dataObjectTypeName;
    }

    public void setDataObjectTypeName(String dataObjectTypeName) {
        this.dataObjectTypeName = dataObjectTypeName;
    }

    public String getOmitXmlDeclaration() {
        return this.omitXmlDeclaration;
    }

    public void setOmitXmlDeclaration(String omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<TidyMarkupDataFormat> {
        private Class<?> dataObjectType;
        private String dataObjectTypeName;
        private String omitXmlDeclaration;

        public Builder dataObjectType(Class<?> dataObjectType) {
            this.dataObjectType = dataObjectType;
            return this;
        }

        public Builder dataObjectTypeName(String dataObjectTypeName) {
            this.dataObjectTypeName = dataObjectTypeName;
            return this;
        }

        public Builder omitXmlDeclaration(String omitXmlDeclaration) {
            this.omitXmlDeclaration = omitXmlDeclaration;
            return this;
        }

        public Builder omitXmlDeclaration(boolean omitXmlDeclaration) {
            this.omitXmlDeclaration = Boolean.toString(omitXmlDeclaration);
            return this;
        }

        @Override
        public TidyMarkupDataFormat end() {
            return new TidyMarkupDataFormat(this);
        }
    }
}

