/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RouteTemplateHelper {
    private static final Logger LOG = LoggerFactory.getLogger(RouteTemplateHelper.class);

    private RouteTemplateHelper() {
    }

    public static void loadRouteTemplateFromLocation(CamelContext camelContext, RouteTemplateLoaderListener listener, String templateId, String location) throws Exception {
        if (location == null) {
            throw new IllegalArgumentException("Location is empty");
        }
        ExtendedCamelContext ecc = (ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class);
        boolean found = false;
        String[] stringArray = location.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            Object path;
            Object name = path = stringArray[i];
            Resource res = null;
            String ext = FileUtil.onlyExt((String)path);
            if (ext != null) {
                res = ecc.getResourceLoader().resolveResource((String)name);
            }
            if (res == null || !res.exists()) {
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                name = (String)path + templateId + ".kamelet.yaml";
                res = ecc.getResourceLoader().resolveResource((String)name);
            }
            if (!res.exists()) continue;
            try {
                if (listener != null) {
                    listener.loadRouteTemplate(res);
                }
            }
            catch (Exception e) {
                LOG.warn("RouteTemplateLoaderListener error due to " + e.getMessage() + ". This exception is ignored", (Throwable)e);
            }
            ecc.getRoutesLoader().loadRoutes(new Resource[]{res});
            found = true;
            break;
        }
        if (!found) {
            Object path = location;
            if (!((String)path).endsWith("/")) {
                path = (String)path + "/";
            }
            String target = (String)path + templateId + ".kamelet.yaml";
            ecc.getRoutesLoader().loadRoutes(new Resource[]{ecc.getResourceLoader().resolveResource(target)});
        }
    }
}

