/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;

@Converter(generateLoader=true)
public final class FileConverter {
    private FileConverter() {
    }

    @Converter
    public static File genericToFile(GenericFile<File> genericFile, Exchange exchange) throws IOException {
        File file;
        Object body = genericFile.getBody();
        if (body instanceof byte[]) {
            byte[] bos = (byte[])body;
            Object destDir = System.getProperty("java.io.tmpdir");
            if (destDir != null && !((String)destDir).endsWith(File.separator)) {
                destDir = (String)destDir + File.separator;
            }
            if (!(file = new File((String)destDir, genericFile.getFileName())).getCanonicalPath().startsWith((String)destDir)) {
                throw new IOException("File is not jailed to the destination directory");
            }
            Files.write(file.toPath(), bos, StandardOpenOption.CREATE);
            file.deleteOnExit();
        } else {
            file = (File)body;
        }
        return file;
    }
}

