/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.jira;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelJiraSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_JIRA_PATH_TYPE_CONF = "camel.source.path.type";
    public static final String CAMEL_SOURCE_JIRA_PATH_TYPE_DOC = "Operation to perform. Consumers: NewIssues, NewComments. Producers: AddIssue, AttachFile, DeleteIssue, TransitionIssue, UpdateIssue, Watchers. See this class javadoc description for more information. One of: [ADDCOMMENT] [ADDISSUE] [ATTACH] [DELETEISSUE] [NEWISSUES] [NEWCOMMENTS] [WATCHUPDATES] [UPDATEISSUE] [TRANSITIONISSUE] [WATCHERS] [ADDISSUELINK] [ADDWORKLOG] [FETCHISSUE] [FETCHCOMMENTS]";
    public static final String CAMEL_SOURCE_JIRA_PATH_TYPE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_CONF = "camel.source.endpoint.delay";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_DOC = "Time in milliseconds to elapse for the next poll.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_DEFAULT = "6000";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_CONF = "camel.source.endpoint.jiraUrl";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_DOC = "The Jira server url, example: http://my_jira.com:8081";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF = "camel.source.endpoint.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JQL_CONF = "camel.source.endpoint.jql";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JQL_DOC = "JQL is the query language from JIRA which allows you to retrieve the data you want. For example jql=project=MyProject Where MyProject is the product key in Jira. It is important to use the RAW() and set the JQL inside it to prevent camel parsing it, example: RAW(project in (MYP, COM) AND resolution = Unresolved)";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_JQL_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_CONF = "camel.source.endpoint.maxResults";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_DOC = "Max number of issues to search for";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_DEFAULT = "50";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_CONF = "camel.source.endpoint.sendOnlyUpdatedField";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_DOC = "Indicator for sending only changed fields in exchange body or issue object. By default consumer sends only changed fields.";
    public static final Boolean CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_DEFAULT = true;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_CONF = "camel.source.endpoint.watchedFields";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_DOC = "Comma separated list of fields to watch for changes. Status,Priority are the defaults.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_DEFAULT = "Status,Priority";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_CONF = "camel.source.endpoint.exceptionHandler";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_DOC = "To let the consumer use a custom ExceptionHandler. Notice if the option bridgeErrorHandler is enabled then this option is not in use. By default the consumer will deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_CONF = "camel.source.endpoint.exchangePattern";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_DOC = "Sets the exchange pattern when the consumer creates an exchange. One of: [InOnly] [InOut] [InOptionalOut]";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_CONF = "camel.source.endpoint.synchronous";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_DOC = "Sets whether synchronous processing should be strictly used, or Camel is allowed to use asynchronous processing (if supported).";
    public static final Boolean CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_DEFAULT = false;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_CONF = "camel.source.endpoint.accessToken";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_DOC = "(OAuth only) The access token generated by the Jira server.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_CONF = "camel.source.endpoint.consumerKey";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_DOC = "(OAuth only) The consumer key from Jira settings.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_CONF = "camel.source.endpoint.password";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_DOC = "(Basic authentication only) The password to authenticate to the Jira server. Use only if username basic authentication is used.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_CONF = "camel.source.endpoint.privateKey";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_DOC = "(OAuth only) The private key generated by the client to encrypt the conversation to the server.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_CONF = "camel.source.endpoint.username";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_DOC = "(Basic authentication only) The username to authenticate to the Jira server. Use only if OAuth is not enabled on the Jira server. Do not set the username and OAuth token parameter, if they are both set, the username basic authentication takes precedence.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_CONF = "camel.source.endpoint.verificationCode";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_DOC = "(OAuth only) The verification code from Jira generated in the first step of the authorization proccess.";
    public static final String CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_DELAY_CONF = "camel.component.jira.delay";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_DELAY_DOC = "Time in milliseconds to elapse for the next poll.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_DELAY_DEFAULT = "6000";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_CONF = "camel.component.jira.jiraUrl";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_DOC = "The Jira server url, example: http://my_jira.com:8081";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_CONF = "camel.component.jira.bridgeErrorHandler";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_DOC = "Allows for bridging the consumer to the Camel routing Error Handler, which mean any exceptions occurred while the consumer is trying to pickup incoming messages, or the likes, will now be processed as a message and handled by the routing Error Handler. By default the consumer will use the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that will be logged at WARN or ERROR level and ignored.";
    public static final Boolean CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT = false;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_CONF = "camel.component.jira.autowiredEnabled";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_DOC = "Whether autowiring is enabled. This is used for automatic autowiring options (the option must be marked as autowired) by looking up in the registry to find if there is a single instance of matching type, which then gets configured on the component. This can be used for automatic configuring JDBC data sources, JMS connection factories, AWS Clients, etc.";
    public static final Boolean CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT = true;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_CONF = "camel.component.jira.configuration";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_DOC = "To use a shared base jira configuration.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_CONF = "camel.component.jira.accessToken";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_DOC = "(OAuth only) The access token generated by the Jira server.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_CONF = "camel.component.jira.consumerKey";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_DOC = "(OAuth only) The consumer key from Jira settings.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_CONF = "camel.component.jira.password";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_DOC = "(Basic authentication only) The password to authenticate to the Jira server. Use only if username basic authentication is used.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_CONF = "camel.component.jira.privateKey";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_DOC = "(OAuth only) The private key generated by the client to encrypt the conversation to the server.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_CONF = "camel.component.jira.username";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_DOC = "(Basic authentication only) The username to authenticate to the Jira server. Use only if OAuth is not enabled on the Jira server. Do not set the username and OAuth token parameter, if they are both set, the username basic authentication takes precedence.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_DEFAULT = null;
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_CONF = "camel.component.jira.verificationCode";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_DOC = "(OAuth only) The verification code from Jira generated in the first step of the authorization proccess.";
    public static final String CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_DEFAULT = null;

    public CamelJiraSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelJiraSourceConnectorConfig(Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_JIRA_PATH_TYPE_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_PATH_TYPE_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JIRA_PATH_TYPE_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JIRA_ENDPOINT_JIRA_URL_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_JQL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_JQL_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_JQL_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_MAX_RESULTS_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_SEND_ONLY_UPDATED_FIELD_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_WATCHED_FIELDS_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_EXCEPTION_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_EXCHANGE_PATTERN_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_SYNCHRONOUS_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_CONSUMER_KEY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_PRIVATE_KEY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_ENDPOINT_VERIFICATION_CODE_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_DELAY_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_COMPONENT_DELAY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_DELAY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_DEFAULT, ConfigDef.Importance.HIGH, CAMEL_SOURCE_JIRA_COMPONENT_JIRA_URL_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_BRIDGE_ERROR_HANDLER_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_CONF, ConfigDef.Type.BOOLEAN, CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_AUTOWIRED_ENABLED_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_CONF, ConfigDef.Type.STRING, CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_CONFIGURATION_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_ACCESS_TOKEN_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_CONSUMER_KEY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_PASSWORD_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_PRIVATE_KEY_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_USERNAME_DOC);
        conf.define(CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_CONF, ConfigDef.Type.PASSWORD, CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_JIRA_COMPONENT_VERIFICATION_CODE_DOC);
        return conf;
    }
}