/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.LambdaRouteBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.FaultToleranceConfigurationProperties;
import org.apache.camel.main.HealthConfigurationProperties;
import org.apache.camel.main.HystrixConfigurationProperties;
import org.apache.camel.main.LraConfigurationProperties;
import org.apache.camel.main.Resilience4jConfigurationProperties;
import org.apache.camel.main.RestConfigurationProperties;
import org.apache.camel.main.ThreadPoolConfigurationProperties;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.Configurer;

@Configurer(bootstrap=true)
public class MainConfigurationProperties
extends DefaultConfigurationProperties<MainConfigurationProperties>
implements BootstrapCloseable {
    private boolean autoConfigurationEnabled = true;
    private boolean autoConfigurationEnvironmentVariablesEnabled = true;
    private boolean autoConfigurationFailFast = true;
    private boolean autoConfigurationLogSummary = true;
    private int durationHitExitCode;
    private String packageScanRouteBuilders;
    private String routesBuilderClasses;
    private String configurationClasses;
    private List<RoutesBuilder> routesBuilders = new ArrayList<RoutesBuilder>();
    private List<Object> configurations = new ArrayList<Object>();
    private HealthConfigurationProperties healthConfigurationProperties;
    private LraConfigurationProperties lraConfigurationProperties;
    private ThreadPoolConfigurationProperties threadPool;
    private HystrixConfigurationProperties hystrixConfigurationProperties;
    private Resilience4jConfigurationProperties resilience4jConfigurationProperties;
    private FaultToleranceConfigurationProperties faultToleranceConfigurationProperties;
    private RestConfigurationProperties restConfigurationProperties;

    public void close() {
        if (this.healthConfigurationProperties != null) {
            this.healthConfigurationProperties.close();
            this.healthConfigurationProperties = null;
        }
        if (this.lraConfigurationProperties != null) {
            this.lraConfigurationProperties.close();
            this.lraConfigurationProperties = null;
        }
        if (this.threadPool != null) {
            this.threadPool.close();
            this.threadPool = null;
        }
        if (this.hystrixConfigurationProperties != null) {
            this.hystrixConfigurationProperties.close();
            this.hystrixConfigurationProperties = null;
        }
        if (this.resilience4jConfigurationProperties != null) {
            this.resilience4jConfigurationProperties.close();
            this.resilience4jConfigurationProperties = null;
        }
        if (this.faultToleranceConfigurationProperties != null) {
            this.faultToleranceConfigurationProperties.close();
            this.faultToleranceConfigurationProperties = null;
        }
        if (this.restConfigurationProperties != null) {
            this.restConfigurationProperties.close();
            this.restConfigurationProperties = null;
        }
        this.routesBuilders.clear();
        this.routesBuilders = null;
        this.configurations.clear();
        this.configurations = null;
    }

    public HealthConfigurationProperties health() {
        if (this.healthConfigurationProperties == null) {
            this.healthConfigurationProperties = new HealthConfigurationProperties(this);
        }
        return this.healthConfigurationProperties;
    }

    public LraConfigurationProperties lra() {
        if (this.lraConfigurationProperties == null) {
            this.lraConfigurationProperties = new LraConfigurationProperties(this);
        }
        return this.lraConfigurationProperties;
    }

    public ThreadPoolConfigurationProperties threadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPoolConfigurationProperties(this);
        }
        return this.threadPool;
    }

    @Deprecated
    public HystrixConfigurationProperties hystrix() {
        if (this.hystrixConfigurationProperties == null) {
            this.hystrixConfigurationProperties = new HystrixConfigurationProperties(this);
        }
        return this.hystrixConfigurationProperties;
    }

    public Resilience4jConfigurationProperties resilience4j() {
        if (this.resilience4jConfigurationProperties == null) {
            this.resilience4jConfigurationProperties = new Resilience4jConfigurationProperties(this);
        }
        return this.resilience4jConfigurationProperties;
    }

    public FaultToleranceConfigurationProperties faultTolerance() {
        if (this.faultToleranceConfigurationProperties == null) {
            this.faultToleranceConfigurationProperties = new FaultToleranceConfigurationProperties(this);
        }
        return this.faultToleranceConfigurationProperties;
    }

    public RestConfigurationProperties rest() {
        if (this.restConfigurationProperties == null) {
            this.restConfigurationProperties = new RestConfigurationProperties(this);
        }
        return this.restConfigurationProperties;
    }

    public boolean isAutoConfigurationEnabled() {
        return this.autoConfigurationEnabled;
    }

    public void setAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
    }

    public boolean isAutoConfigurationEnvironmentVariablesEnabled() {
        return this.autoConfigurationEnvironmentVariablesEnabled;
    }

    public void setAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
    }

    public boolean isAutoConfigurationFailFast() {
        return this.autoConfigurationFailFast;
    }

    public void setAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
    }

    public boolean isAutoConfigurationLogSummary() {
        return this.autoConfigurationLogSummary;
    }

    public void setAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
    }

    public String getPackageScanRouteBuilders() {
        return this.packageScanRouteBuilders;
    }

    public void setPackageScanRouteBuilders(String packageScanRouteBuilders) {
        this.packageScanRouteBuilders = packageScanRouteBuilders;
    }

    public int getDurationHitExitCode() {
        return this.durationHitExitCode;
    }

    public void setDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
    }

    public String getConfigurationClasses() {
        return this.configurationClasses;
    }

    public void setConfigurationClasses(String configurations) {
        this.configurationClasses = configurations;
    }

    public void addConfigurationClass(Class<?> ... configuration) {
        String existing = this.configurationClasses;
        if (existing == null) {
            existing = "";
        }
        if (configuration != null) {
            for (Class<?> clazz : configuration) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setConfigurationClasses(existing);
    }

    public void addConfiguration(Object configuration) {
        this.configurations.add(configuration);
    }

    public List<Object> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<Object> configurations) {
        this.configurations = configurations;
    }

    public String getRoutesBuilderClasses() {
        return this.routesBuilderClasses;
    }

    public void setRoutesBuilderClasses(String builders) {
        this.routesBuilderClasses = builders;
    }

    public List<RoutesBuilder> getRoutesBuilders() {
        return this.routesBuilders;
    }

    public void setRoutesBuilders(List<RoutesBuilder> routesBuilders) {
        this.routesBuilders = routesBuilders;
    }

    public void addRoutesBuilder(RoutesBuilder routeBuilder) {
        this.routesBuilders.add(routeBuilder);
    }

    public void addRoutesBuilder(Class<?> ... routeBuilder) {
        String existing = this.routesBuilderClasses;
        if (existing == null) {
            existing = "";
        }
        if (routeBuilder != null) {
            for (Class<?> clazz : routeBuilder) {
                if (!existing.isEmpty()) {
                    existing = existing + ",";
                }
                existing = existing + clazz.getName();
            }
        }
        this.setRoutesBuilderClasses(existing);
    }

    public void addLambdaRouteBuilder(final LambdaRouteBuilder routeBuilder) {
        this.routesBuilders.add((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                routeBuilder.accept((Object)this);
            }
        });
    }

    public MainConfigurationProperties withAutoConfigurationEnabled(boolean autoConfigurationEnabled) {
        this.autoConfigurationEnabled = autoConfigurationEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationEnvironmentVariablesEnabled(boolean autoConfigurationEnvironmentVariablesEnabled) {
        this.autoConfigurationEnvironmentVariablesEnabled = autoConfigurationEnvironmentVariablesEnabled;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationFailFast(boolean autoConfigurationFailFast) {
        this.autoConfigurationFailFast = autoConfigurationFailFast;
        return this;
    }

    public MainConfigurationProperties withAutoConfigurationLogSummary(boolean autoConfigurationLogSummary) {
        this.autoConfigurationLogSummary = autoConfigurationLogSummary;
        return this;
    }

    public MainConfigurationProperties withDurationHitExitCode(int durationHitExitCode) {
        this.durationHitExitCode = durationHitExitCode;
        return this;
    }

    public MainConfigurationProperties withPackageScanRouteBuilders(String packageScanRouteBuilders) {
        this.packageScanRouteBuilders = packageScanRouteBuilders;
        return this;
    }

    public MainConfigurationProperties withConfigurationClasses(String configurations) {
        this.setConfigurationClasses(configurations);
        return this;
    }

    public MainConfigurationProperties withAdditionalConfigurationClasses(Class ... configuration) {
        this.addConfigurationClass(configuration);
        return this;
    }

    public MainConfigurationProperties withAdditionalConfiguration(Object configuration) {
        this.addConfiguration(configuration);
        return this;
    }

    public MainConfigurationProperties withConfigurations(List<Object> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilderClasses(String builders) {
        this.setRoutesBuilderClasses(builders);
        return this;
    }

    public MainConfigurationProperties withRoutesBuilders(List<RoutesBuilder> builders) {
        this.setRoutesBuilders(builders);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(RoutesBuilder builder) {
        this.addRoutesBuilder(builder);
        return this;
    }

    public MainConfigurationProperties withAdditionalRoutesBuilder(Class ... builders) {
        this.addRoutesBuilder(builders);
        return this;
    }

    public MainConfigurationProperties withAdditionalLambdaRouteBuilder(LambdaRouteBuilder builder) {
        this.addLambdaRouteBuilder(builder);
        return this;
    }
}

