/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.SearchRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.SearchResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJiraConsumer
extends ScheduledPollConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractJiraConsumer.class);
    private final JiraEndpoint endpoint;

    public AbstractJiraConsumer(JiraEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.setDelay(endpoint.getDelay());
    }

    protected List<Issue> getIssues() {
        return this.getIssues(this.endpoint.getJql(), 0, 50, this.endpoint.getMaxResults());
    }

    protected List<Issue> getIssues(String jql, int start, int maxPerQuery, int maxResults) {
        LOG.debug("Start indexing current JIRA issues...");
        ArrayList<Issue> issues = new ArrayList<Issue>();
        while (true) {
            SearchRestClient searchRestClient = this.endpoint.getClient().getSearchClient();
            SearchResult searchResult = (SearchResult)searchRestClient.searchJql(jql, Integer.valueOf(maxResults), Integer.valueOf(start), null).claim();
            for (Issue issue : searchResult.getIssues()) {
                issues.add(issue);
            }
            if (start >= searchResult.getTotal() || maxResults > 0 && issues.size() >= maxResults) break;
            start += maxPerQuery;
        }
        LOG.debug("End indexing current JIRA issues. {} issues indexed.", (Object)issues.size());
        return issues;
    }

    protected JiraRestClient client() {
        return this.endpoint.getClient();
    }

    protected abstract int poll() throws Exception;
}

